/**
 * ts-agent-sdk Database Types
 *
 * Common types for database operations.
 */

/**
 * Result of a D1 query.
 */
export interface D1QueryResult<T = Record<string, unknown>> {
  success: boolean;
  results: T[];
  meta: {
    served_by?: string;
    duration?: number;
    changes?: number;
    last_row_id?: number;
    changed_db?: boolean;
    size_after?: number;
    rows_read?: number;
    rows_written?: number;
  };
}

/**
 * Result from Cloudflare D1 REST API.
 */
export interface D1APIResponse<T = Record<string, unknown>> {
  success: boolean;
  errors: { code: number; message: string }[];
  messages: string[];
  result: D1QueryResult<T>[];
}

/**
 * Options for count queries.
 */
export interface CountOptions {
  where?: Record<string, unknown>;
}

/**
 * Options for select queries.
 */
export interface SelectOptions {
  columns?: string[];
  where?: Record<string, unknown>;
  orderBy?: string | { column: string; direction: 'ASC' | 'DESC' };
  limit?: number;
  offset?: number;
}

/**
 * Represents a parameter that can be bound to a SQL query.
 */
export type SQLParam = string | number | boolean | null | Uint8Array;

/**
 * Aggregate function result.
 */
export interface AggregateResult {
  count?: number;
  sum?: number;
  avg?: number;
  min?: number | string;
  max?: number | string;
}
