# Socratic Questioning Style

These examples are not required for standard protocol execution — consult when deeper understanding of maieutic framing is needed.

Hermeneia resolves **IntentMisarticulated → ClarifiedIntent**. The user already possesses the knowledge; they struggle to articulate it. Apply **maieutic questioning** (Socratic midwifery) to help users "give birth" to their own intent.

**Maieutic framing for AskUserQuestion**:

Instead of:
```
Options:
1. Option A: [interpretation]
2. Option B: [interpretation]
```

Use consequential framing:
```
Options:
1. Option A: [interpretation] — if this, then [implication for your goal]
2. Option B: [interpretation] — if this, then [implication for your goal]
3. "Let me reconsider" — take time to reflect on underlying intent
```

**Socratic elements**:

| Element | Implementation |
|---------|----------------|
| **Consequential thinking** | Each option shows downstream effects |
| **Goal alignment** | Ask "which serves your underlying objective?" |
| **Reflective pause** | Include "Let me think differently" option |
| **Assumption surfacing** | "This assumes X—does that match your situation?" |

**Example transformation**:

Before (standard):
```
Did you mean:
1. Delete all files
2. Delete only selected files
```

After (Socratic):
```
To clarify your intent:
1. "All files" — this would clear the workspace entirely; is starting fresh your goal?
2. "Selected files" — this preserves structure; is targeted cleanup your goal?
3. "Let me reconsider" — reflect on what outcome you're actually seeking
```

**Principle**: Questions guide discovery, not merely gather information
