---
name: commit
description: Create git commits with appropriate commit messages. Use when the user asks to commit, create a commit, write a commit message, or mentions "commit" in the context of saving changes to git.
---

# Git Commit

## Step 1: Gather Context

Run the skill's context-gathering script:

```bash
<skill-location-dir>/scripts/gather-commit-context.sh
```

The script outputs the current working directory first. Verify you are in the correct repository before proceeding.

## Step 2: Decide Commit Style

**One-line** when: \<100 lines, simple change, user asks for "short/quick commit"

**Detailed** when: >100 lines, multiple components, user asks for "detailed commit"

**Match project style**: Use conventional commits (feat:, fix:) only if recent commits use them.

## Step 3: Create Commit

```bash
git commit -m "message"
git commit -m "title" -m "- bullet 1
- bullet 2"
```

## Rules

- NEVER include attribution markers in commit messages. This includes but is not limited to:
  - "Co-Authored-By" or "Co-authored-by" headers
  - "Generated by", "Created by", "Written by" followed by any AI/LLM name
  - Footers like "🤖 Generated with [Claude Code](https://claude.com/claude-code)" or similar
  - Any mention of AI tools: Claude, GPT, Copilot, Codex, Gemini, Cursor, or other LLMs/assistants
  - Any text or links indicating AI involvement in creating the commit
- NEVER do `git add .`
- If pre-commit modifies files: add them and retry
- If pre-commit fails: ask user
