---
name: gobi-onboarding
description: 고비 데스크탑 3.0 대화형 음성 온보딩 가이드
metadata:
  version: 2.4
  author: lifidea
  created: 2026-02-04
  updated: 2026-02-12
---

## When to Use

이 스킬은 사용자가 온보딩을 요청할 때 활성화한다.

### 트리거 키워드
- "온보딩 시작" / "온보딩 계속" / "이어서 하자"
- "onboarding" / "시작 도우미"

### 참고
- 음성 출력 규칙은 RVA 시스템 프롬프트에서 이미 적용되므로, 이 스킬에서는 온보딩 플로우만 담당한다.

### 언어 설정
- 사용자의 언어에 맞춰 응답한다. 사용자가 영어로 말하면 영어로, 한국어로 말하면 한국어로 진행한다.
- 아래 스크립트 예시는 한국어 기준이며, 영어 사용자에게는 동일한 내용을 영어로 자연스럽게 전달한다.

## 온보딩 철학

**"목표 중심 온보딩: Build Knowledge → Create Content → Share"**

1. **Goal-Oriented**: 목표 중심 온보딩 (Build K → Create → Share)
2. **Voice-First**: 모든 단계 음성 진행
3. **적응형**: 사용자 환경 맞춤
4. **점진적 공개**: 필수만 먼저
5. **대신 골라주기**: 선택 어려우면 제안
6. **시각적 피드백**: 진행률 & 결과

사용자는 복잡한 개념을 배우는 게 아니라, 가치를 체험하는 것이다. 각 단계마다 "이걸 하면 이런 좋은 일이 생겨요"를 먼저 보여주고, 행동은 최대한 단순하게 안내한다.

## 용어 설명 가이드

초보 사용자가 전문 용어에서 혼란을 느끼지 않도록, 각 용어를 첫 등장 시 한국어 대체어와 비유를 함께 말한다. 사용자가 이미 아는 듯하면 비유는 생략 가능.

| 용어 | 한국어 대체어 | 비유 | 사용 시점 |
|------|-------------|------|-----------|
| PKM | 개인 지식 관리 | 나만의 두 번째 뇌 만들기 | 1단계 오프닝 |
| 인제스트 | 가져오기 | 흩어진 자료를 한 곳에 모으는 것 | 3단계 오프닝 |
| 인덱스 | 자동 정리/목록 | 도서관 목록 | 3단계 |
| DRB | 아침 뉴스 브리핑 | 매일 아침 관심 주제 뉴스 모음 | 3단계 |
| 동기화 | 프로필 공개 | 명함 교환 | BRAIN.md 동기화 시 |
| Writeup | 글 작성 | AI가 초안을 대신 써주는 것 | 4단계 |
| Video | 영상 변환 | 슬라이드를 자동으로 영상으로 만드는 것 | 4단계 |
| Timeline | 시간순 보기 | 자료를 시간 순서대로 보는 달력 | 3단계 |
| Graph | 지식 그래프 | 자료 간 연결을 보여주는 지도 | 3단계 |

## Pre-boarding (온보딩 진입 조건)

온보딩을 시작하기 전에 아래 조건이 완료되어 있어야 한다. 이 단계들은 온보딩 플로우에 포함되지 않으며, 별도로 안내한다.

- 고비 데스크탑 설치 완료
- 구글 계정으로 로그인 완료
- 메인 볼트 생성 완료

### Pre-boarding 미완료 시 대응

- 사용자: "온보딩 시작할게요" (볼트 미생성 상태)
- 에이전트: "온보딩을 시작하려면 먼저 볼트를 만들어야 해요. 볼트는 내 지식을 담는 공간이에요. 새 볼트 만들기를 눌러서 하나 만들어주세요. 만들고 나면 다시 '온보딩 시작'이라고 말해주세요."

## 오프닝 인사

### 에이전트 웰컴 스크립트

> 안녕하세요! 온보딩을 시작할게요.
> 지금부터 여섯 단계로 진행되는데, 필수 단계만 하면 십오 분이면 충분해요.
> 먼저 피케이엠을 소개하고, 프로필을 파악하고, 지식을 구축하고, 콘텐츠를 만들어보고, 지식을 공유하고, 마무리하는 순서예요.
> 바로 시작할까요?

### 사용자 응답 시나리오

#### A. 바로 시작
- 사용자: "네" / "시작할게요"
- 에이전트: "좋아요! 그럼 첫 번째 단계부터 시작할게요."

#### B. 먼저 설명 요청
- 사용자: "이게 뭔가요?" / "먼저 설명해주세요"
- 에이전트: "고비 데스크탑은 내 지식을 모으고, 정리하고, 공유할 수 있는 도구예요. 메모, 파일, 메일 같은 걸 한 곳에 모아두면, 에이아이가 자동으로 정리해주고, 나중에 뭐든 물어보면 내 자료를 바탕으로 답변해줘요. 준비되시면 시작할까요?"

#### C. 일부 이미 완료
- 사용자: "이미 인제스트는 했어요"
- 에이전트: "아, 벌써 진행하셨군요! 어디까지 하셨는지 확인해볼게요. 잠시만요."
- (진행 상태 확인 후 해당 단계부터 이어서 안내)

## 1단계: PKM과 GD 소개

### 에이전트 오프닝

> 첫 번째 단계는 피케이엠과 고비 데스크탑 소개예요.
> 먼저 피케이엠이 뭔지, 그리고 고비 데스크탑으로 어떤 걸 할 수 있는지 알려드릴게요.

### 1-1. PKM 목표 소개

> 피케이엠은 개인 지식 관리라고 하는데, 쉽게 말하면 나만의 두 번째 뇌를 만드는 거예요.
> 세 가지 목표가 있어요.
> 첫째, 매일 보는 정보를 내 지식으로 바꾸는 거예요. 그냥 읽고 넘기는 게 아니라, 쌓아두면 나만의 자산이 돼요.
> 둘째, 내 생각과 경험을 체계적으로 정리할 수 있어요. 나중에 필요할 때 바로 찾을 수 있죠.
> 셋째, 이렇게 정리한 지식으로 생산성을 높일 수 있어요. 글을 쓰거나, 결정을 내리거나, 새로운 아이디어를 만들 때 활용할 수 있어요.

#### 사용자 응답 시나리오

##### A. 이해함
- 사용자: "아, 그렇군요" / "좋아요"
- 에이전트: "그러면 고비 데스크탑이 어떻게 도와주는지 알려드릴게요."

##### B. 질문
- 사용자: "피케이엠이 왜 필요해요?"
- 에이전트: "우리가 매일 보는 정보가 엄청 많잖아요. 뉴스, 메일, 아티클, 메모... 그런데 대부분 그냥 흘려보내죠. 피케이엠을 하면 이런 정보를 체계적으로 쌓아서, 나중에 필요할 때 바로 꺼내 쓸 수 있어요."

##### C. 건너뛰기
- 사용자: "이미 알아요" / "넘어가주세요"
- 에이전트: "이미 아시는군요! 바로 다음으로 넘어갈게요."

### 1-2. GD 핵심 기능 소개

> 고비 데스크탑은 피케이엠을 쉽게 할 수 있게 도와주는 도구예요. 세 가지 핵심 기능이 있어요.
> 첫째, 지금처럼 음성으로 대화하면서 지식을 관리할 수 있어요. 타이핑할 필요 없이 말하기만 하면 돼요.
> 둘째, 에이아이가 자료를 자동으로 정리해줘요. 파일을 넣으면 알아서 분류하고 요약해요.
> 셋째, 웹 클리핑, 메일, 문서 같은 걸 자동으로 가져와서 관리해줘요.

#### 사용자 응답 시나리오

##### A. 관심 표현
- 사용자: "오, 좋네요" / "신기하다"
- 에이전트: "맞죠? 직접 체험해보면 더 좋아요. 다음 단계에서 프로필을 먼저 만들어볼게요."

##### B. 구체적 질문
- 사용자: "자동 정리가 정확해요?" / "어떤 파일을 넣을 수 있어요?"
- 에이전트: (질문에 맞춰 구체적으로 답변 후) "자세한 건 뒤에서 직접 체험해보실 수 있어요. 다음 단계로 넘어갈까요?"

### 완료 확인 & 전환

> 첫 번째 단계 완료! 피케이엠과 고비 데스크탑에 대해 알아봤어요.
> 다음으로 넘어가기 전에 하나만 여쭤볼게요.

### 옵시디언 연동 (선택)

> 혹시 옵시디언을 사용하시거나 관심 있으세요?
> 옵시디언을 연결하면 프로필을 만든 뒤 바로 확인할 수 있고, 나중에 지식 그래프도 직접 탐색할 수 있어요.
> 연결 안 해도 온보딩은 동일하게 진행돼요.

#### 사용자 응답 시나리오

##### A. 옵시디언 사용 / 관심 있음
- 사용자: "네" / "옵시디언 쓰고 있어요" / "해볼게요"
- 에이전트: "좋아요! 옵시디언에서 이 볼트 폴더를 열어주세요. 'Open folder as vault'를 선택하면 돼요."
- (`obsidian_enabled = true`로 설정)
- 사용자가 이미 옵시디언에서 볼트를 열고 있는 경우: "이미 열려 있으시군요! 바로 다음으로 넘어갈게요."

##### B. 옵시디언 사용 안 함 / 관심 없음
- 사용자: "아니요" / "안 할래요" / "나중에요"
- 에이전트: "괜찮아요! 옵시디언 없이도 동일하게 진행할 수 있어요. 나중에 관심 생기면 언제든 연결할 수 있어요."
- (`obsidian_enabled = false`로 설정)

**상태 추적**: `obsidian_enabled`는 대화 컨텍스트에서 추적한다. 세션 재개 시 ("온보딩 계속") 사용자에게 간단히 확인한다: "지난번에 옵시디언 연결하셨었나요?"

> 그러면 프로필을 만들어볼게요. 어떤 분인지 파악해서 맞춤으로 도와드릴게요.

## 2단계: 사용자 파악

### 에이전트 오프닝

> 두 번째 단계는 사용자 파악이에요.
> 어떤 분인지 알면 맞춤으로 도와드릴 수 있어요.
> 먼저 간단히 자기소개 부탁드려도 될까요? 이름과 하시는 일을 알려주세요.

### 2-1. 이름 & 기본 프로필 확인

기본 프로필 정보를 확보해야 맞춤 서비스를 제공할 수 있다. 아래 정보를 대화를 통해 자연스럽게 파악한다.

**확보 목표 (최소 3개 이상):**
- **이름** (필수)
- **성별** (선택)
- **지역/위치** (선택 — 시간대, 언어, 지역 맞춤 콘텐츠에 활용)
- **나이/연령대** (선택)
- **직업/역할** (필수)
- **직위/포지션** (선택)
- **관심 분야** (필수)

> 반갑습니다! 맞춤으로 도와드리려면 몇 가지 알아야 해요.
> 어떤 일을 하시는지, 어디 계시는지, 관심 분야가 뭔지 알려주시면 딱 맞는 프로필을 만들어드릴게요.

#### 사용자 응답 시나리오

##### A. 상세히 알려줌
- 사용자: "저는 홍길동이고, 서울에서 소프트웨어 엔지니어로 일해요"
- 에이전트: "좋아요! 혹시 특히 관심 있는 분야가 있으세요? 예를 들어 에이아이, 웹 개발, 데이터 같은 거요."

##### B. 간략히 알려줌
- 사용자: "김철수요"
- 에이전트: "반갑습니다, 철수 님! 맞춤으로 도와드리려면 좀 더 알아야 해요. 어떤 일을 하시는지, 어디 계시는지 알려주실 수 있어요?"

##### C. 거부
- 사용자: "알려주기 싫어요"
- 에이전트: "괜찮아요! 다만 기본 정보가 있으면 더 잘 도와드릴 수 있어요. 나중에 언제든 알려주셔도 돼요. 일단 기본 프로필로 시작할게요."

**후속 질문 가이드:**

- 이름만 알려준 경우: "어떤 일을 하시는지 알려주실 수 있어요?"
- 직업만 알려준 경우: "어떤 분야에서 일하시는지 좀 더 알려주실 수 있어요? 예를 들어 전문 영역이나 주로 다루는 주제가 있으면요."
- 관심사만 알려준 경우: "좋아요! 혹시 직업이나 하시는 일도 알려주실 수 있어요? 프로필이 더 풍성해져요."
- 너무 넓은 경우 (예: "IT"): "IT 쪽이시군요! 좀 더 구체적으로 어떤 분야인지 알려주실 수 있어요? 예를 들어 개발, 데이터, 보안 같은 게 있을 수 있어요."
- 지역/나이 정보가 없는 경우: "혹시 어디에서 활동하시는지도 알려주실 수 있어요? 시간대나 지역에 맞는 콘텐츠를 추천해드릴 수 있어요."

### 2-2. 웹 검색으로 프로필 보강

이름과 직업/역할 정보를 확보한 후, 웹 검색으로 추가 정보를 자동 발견한다.

#### 검색 결과가 있는 경우
- 에이전트: (백그라운드에서 이름 + 직업 키워드로 웹 검색 수행)
- 에이전트: "혹시 이 [홈페이지/블로그]가 맞으세요?" (검색 결과 제시)
- 사용자 확인 시: "좋아요! 여기서 정보를 가져와서 프로필을 보강할게요." (인제스트 진행)
- 사용자 부정 시: "알겠어요. 혹시 다른 홈페이지나 블로그가 있으세요?"

#### 검색 결과가 없는 경우
- 에이전트: "혹시 개인 홈페이지나 블로그가 있으세요?"

##### A. 홈페이지 있음
- 사용자: "제 블로그 주소는 example.com이에요"
- 에이전트: "좋아요! 지금 가져오고 있어요. 잠시만 기다려주세요." (백그라운드 처리, 완료 시 알림)
- **`BRAIN.md` 업데이트**: 홈페이지에서 추출한 프로필 정보(이름, 소속, 전문 분야, 관심사 등)를 `BRAIN.md`에 반영
- 에이전트 (`obsidian_enabled = true`): "프로필이 만들어졌어요! 옵시디언에서 BRAIN.md를 열어보세요. 수정할 부분이 있으면 말씀해주세요."
- 에이전트 (`obsidian_enabled = false`): "프로필이 만들어졌어요! 화면에서 확인해보세요. 수정할 부분이 있으면 말씀해주세요."

##### B. 홈페이지 없음
- 사용자: "없어요"
- 에이전트: "괜찮아요. 앞에서 알려주신 정보로 프로필 초안을 만들어드릴게요."
- **`BRAIN.md` 업데이트**: 사용자가 알려준 정보(이름, 직업, 관심사 등)를 `BRAIN.md`에 반영

### 2-3. 관심사 & 목표 파악

> 프로필이 준비됐으니, 이제 고비 데스크탑으로 뭘 하고 싶은지 알려주세요.
> 크게 세 가지가 있는데요.
> 첫째, 지식 구축 — 자료를 모으고 정리하는 거예요.
> 둘째, 콘텐츠 생성 — 정리한 지식으로 글이나 영상을 만드는 거예요.
> 셋째, 지식 공유 — 커뮤니티에서 다른 사람들과 나누는 거예요.
> 어떤 게 가장 끌리세요?

#### 사용자 응답 시나리오

##### A. 특정 목표 선택
- 사용자: "자료 정리가 급해요" / "글 쓰기를 도와줬으면 해요"
- 에이전트: "좋아요! 그러면 [선택한 목표]를 중심으로 진행할게요. 나머지도 간단히 체험해볼 수 있어요."
- (선택한 목표에 해당하는 단계를 더 깊이 있게 진행)

##### B. 여러 목표
- 사용자: "다 해보고 싶어요"
- 에이전트: "좋아요! 순서대로 다 체험해볼게요. 지식 구축부터 시작할게요."

##### C. 잘 모르겠는 사용자
- 사용자: "잘 모르겠어요"
- 에이전트: "제가 골라드릴게요. 일단 자료를 모으고 정리하는 것부터 시작해봐요. 가장 기본이 되는 거예요."

### BRAIN.md 업데이트 & 동기화

2단계에서 파악한 사용자 정보를 `BRAIN.md` (볼트 루트)에 반영한다.

**업데이트 내용:**
- `title`: 사용자의 이름이 포함된 브레인 명칭
- `description`: 홈페이지/대화에서 추출한 프로필 요약 (이름, 소속, 전문 분야, 관심사)
- 본문 `## Welcome to My Second Brain` 섹션에 프로필 상세 내용 작성

**동기화 제안 (필수 체크포인트):**

BRAIN.md 업데이트 직후 반드시 제안한다. 건너뛰어도 되지만, 제안 자체는 항상 해야 한다.

- 에이전트: "프로필을 커뮤니티와 동기화하면 명함을 교환하듯이 다른 전문가들이 나를 찾을 수 있어요. 동기화할까요?"
- 사용자 동의시: `.gobi/syncfiles`에 아래 파일 추가
  - `BRAIN.md` (프로필)
  - `BRAIN_PROMPT.md` (커뮤니티 에이전트 프롬프트 — 존재하는 경우)
  - `BRAIN_PROFILE.md` (상세 프로필 — 존재하는 경우)
  - `BRAIN.jpg` (프로필 이미지 — 존재하는 경우)
- 사용자 거절/무응답 시: "괜찮아요, 나중에 마음이 바뀌면 '프로필 동기화'라고 말해주세요. 다음 단계로 넘어갈게요."

### 완료 확인 & 전환

> 두 번째 단계 완료! 프로필이 잘 만들어졌어요.
> 다음은 지식 구축이에요. 자료를 가져오고 정리해볼 거예요.

## 3단계: 지식 구축 (Build Knowledge)

### 에이전트 오프닝

> 세 번째 단계는 지식 구축이에요.
> 기존에 가지고 있는 자료를 가져오고, 에이아이가 정리해주는 걸 체험해볼 거예요.
> 참고로, 자료는 모두 내 컴퓨터에만 저장돼요. 외부로 나가지 않으니 안심하세요.

### 3-1. Web & Doc Ingestion

> 어떤 자료를 가져오고 싶으세요?
> 웹 아티클, 문서 파일, 기존 노트 등 여러 가지를 가져올 수 있어요.

#### 사용자 응답 시나리오

##### A. 구글에 정보가 많은 사용자
- 사용자: "메일이랑 캘린더를 주로 써요" / "구글 드라이브에 자료가 많아요"
- 에이전트: "그럼 구글 워크스페이스를 연결하면 딱이에요. 캘린더, 메일, 드라이브를 한번에 연결할 수 있어요. 구글 연동 설정을 열어드릴까요?"
- (Google Workspace 세팅 안내)

##### B. 노트 앱을 사용하는 사용자
- 사용자: "애플 노트를 쓰고 있어요" / "노션에 자료가 있어요"
- 에이전트: "기존 노트를 가져올 수 있는 도구가 있어요. 옵시디언 임포터라고 하는데, 애플 노트나 노션에서 자료를 한번에 가져올 수 있어요. 지금 연결해볼까요?"
- (Obsidian Importer 안내)

##### C. 웹 중심 사용자
- 사용자: "웹에서 자료를 많이 모아요" / "아티클 읽는 걸 좋아해요"
- 에이전트: "그럼 웹 클리핑이 딱이에요. 관심 있는 웹페이지 주소를 저장하면 `Ingest/Clippings` 폴더에 원본 마크다운이 저장돼요. 그러면 이아이씨 워커가 자동으로 요약하고 정리해서 `AI/Summary`에 넣어줘요. 피케이엠 관련 좋은 아티클로 먼저 연습해볼까요?"
- 에이전트: "세컨드 브레인이라는 개념에 대한 좋은 글들이 있어요. 하나 골라서 클리핑해볼까요?"
- (아래 예시 아티클 중 하나를 제시하여 클리핑 체험 유도)

**옵시디언 활성화 시 웹 클리퍼 안내** (`obsidian_enabled = true`인 경우만):

예시 아티클을 제시하기 전에 웹 클리퍼 설치를 먼저 안내한다.

> 옵시디언을 연결하셨으니, 웹 클리퍼도 같이 설치하면 더 편해요. 브라우저 확장 프로그램인데, 웹페이지를 바로 볼트에 저장할 수 있어요.

- 웹 클리퍼 설치 안내 후 설정 화면 표시:

![[_Settings_/Prompts/_files_/owc-config.png]]

**텍스트 폴백** (이미지가 보이지 않는 환경): 웹 클리퍼 설정에서 세 가지만 맞춰주세요. 1) 저장 폴더를 `Ingest/Clippings`로 지정, 2) 태그에 `clipping` 추가, 3) 파일명을 `{{date}} {{title}}`로 설정.

> 설치하셨으면 방금 설정 화면처럼 맞춰주세요. 이제 예시 아티클을 웹 클리퍼로 직접 클리핑해볼게요.

- 사용자가 웹 클리퍼로 예시 아티클을 직접 클리핑하도록 유도

**옵시디언 미활성화 시** (`obsidian_enabled = false`): 기존 플로우 그대로 진행 (Web Clipper는 Post-boarding에서 안내)

**예시 아티클 (세컨드 브레인 주제):**
- [Building a Second Brain: The Definitive Introductory Guide](https://fortelabs.com/blog/basboverview/) - Tiago Forte
- [The PARA Method: The Simple System for Organizing Your Digital Life](https://fortelabs.com/blog/para/) - Tiago Forte
- [두 번째 뇌를 만드는 10가지 원칙](https://brunch.co.kr/@analysisman/7) - 분석맨
- [제텔카스텐의 네 가지 기본 원칙](https://brunch.co.kr/@analysisman/34) - 분석맨

##### D. 문서가 있는 사용자
- 사용자: "파일이 있어요" / "문서를 넣고 싶어요" / "PDF가 있어요"
- 에이전트: "좋아요! 문서를 바로 넣을 수 있어요. 지금 문서 폴더를 열어드릴게요."
- (`Ingest/Documents` 폴더를 열어줌)
- 에이전트: "이 폴더에 파일을 드래그해서 넣어주세요. 피디에프, 워드, 이펍 같은 문서를 넣으면 이디엠이 자동으로 마크다운으로 변환해줘요."
- (EDM 프롬프트가 자동으로 마크다운 변환 처리)

##### E. 잘 모르겠는 사용자
- 사용자: "뭘 넣어야 할지 모르겠어요"
- 에이전트: "제가 골라드릴게요. 가장 쉬운 건 폴더 연결이에요. 컴퓨터에 있는 문서 폴더 하나만 연결하면 돼요. 나중에 더 추가할 수 있으니까 부담 없이 시작해봐요."

##### F. 혼란
- 사용자: "인제스트가 뭐예요?"
- 에이전트: "인제스트는 '가져오기'라고 생각하시면 돼요. 여기저기 흩어진 내 자료를 한 곳에 모으는 거예요. 한번 연결해두면 새 파일이 생길 때마다 알아서 가져와요."

##### G. 건너뛰기
- 사용자: "나중에 할게요"
- 에이전트: "최소 하나는 연결해야 에이아이가 도움을 줄 수 있어요. 가장 쉬운 건 폴더 연결이에요. 문서 폴더 하나만 골라보시겠어요?"

##### H. 추가 질문
- 사용자: "내 자료가 외부로 나가나요?"
- 에이전트: "아니요, 자료는 내 컴퓨터에 그대로 있어요. 고비가 그 파일들을 읽어서 정리해주는 것뿐이에요."
- 사용자: "여러 개 연결할 수 있나요?"
- 에이전트: "네, 원하는 만큼 연결할 수 있어요. 지금은 하나만 하고, 나중에 더 추가해도 돼요."

### 3-2. Timeline & Graph 시각화

인제스트 완료 후, 결과를 시각적으로 보여준다.

> 자료가 들어오고 있어요! 어떻게 정리되는지 보여드릴게요.

![[_Settings_/Prompts/_files_/graph-example.png]]

**텍스트 폴백** (이미지가 보이지 않는 환경): "지식 그래프는 노트들이 주제별로 연결된 네트워크 지도예요. 가운데 BRAIN.md가 있고, 주변에 클리핑, 토픽, 라운드업 노트들이 연결돼 있어요."

> 이렇게 주제별로 연결된 지식 그래프가 만들어져요. 자료가 쌓일수록 그래프가 풍성해져요.
> 타임라인으로도 볼 수 있는데, 시간 순서대로 내가 어떤 자료를 모았는지 한눈에 볼 수 있어요.
> 이만큼 정리됐어요! 앞으로 자료를 더 넣으면 자동으로 정리돼요.

### 3-3. DRB 활성화 (뉴스 브리핑)

#### 활성화 전 확인 (필수)
1. `orchestrator.yaml`의 `nodes` 배열에서 `Daily Research Briefing (DRB)` 항목 존재 여부 확인
2. 이미 존재하면: "뉴스 브리핑은 이미 설정돼 있어요! 매일 아침 다섯 시에 자동으로 브리핑이 만들어져요." → 활성화 제안 건너뛰기
3. 없으면: 사용자 동의 후 `orchestrator.yaml`에 DRB 노드 추가

> 매일 아침 다섯 시에 관심 주제의 최신 뉴스와 논문을 자동으로 찾아서 브리핑을 만들어줄 수 있어요.
> 뉴스 브리핑이라고 하는데, 켜볼까요?

#### 사용자 응답 시나리오

##### A. 활성화
- 사용자: "네, 켜주세요" / "좋아요"
- 에이전트: "좋아요! 뉴스 브리핑을 켰어요. 내일 아침에 첫 브리핑이 준비될 거예요."

##### B. 거절/나중에
- 사용자: "나중에요" / "안 할래요"
- 에이전트: "알겠어요. 나중에 설정에서 언제든 켤 수 있어요."

##### C. 혼란
- 사용자: "뉴스 브리핑이 뭐예요?"
- 에이전트: "내가 관심 있는 주제의 최신 소식을 매일 자동으로 모아서 정리해주는 거예요. 매일 아침 나만의 뉴스 모음이 준비돼요."

### 3-4. Topic Index 활성화

#### 활성화 전 확인 (필수)
1. `orchestrator.yaml`의 `nodes` 배열에서 `Topic Index Update (TIU)` 항목 존재 여부 확인
2. 이미 존재하면: "토픽 인덱스는 이미 켜져 있어요!" → 토픽 선택 단계로 바로 진행
3. 없으면: 사용자 동의 후 `orchestrator.yaml`에 TIU 노드 추가

> 토픽 인덱스를 켜면 주제별로 자동 분류해줘요.

#### 사용자 응답 시나리오

##### A. 토픽 인덱스 설정
- 사용자: "네, 보여주세요" / "토픽 인덱스도 할게요"
- 에이전트: "연결한 자료를 분석해보니 이런 주제들이 있어요." (가능한 토픽 목록 표시)
- 에이전트: "이 중에서 자동 정리할 주제를 골라주세요. 여러 개 골라도 돼요."

##### B. 나중에
- 사용자: "나중에 할게요"
- 에이전트: "알겠어요. 자료가 좀 쌓이면 그때 켜는 것도 좋아요."

##### C. 혼란
- 사용자: "인덱스가 뭐예요?" / "왜 필요해요?"
- 에이전트: "인덱스는 도서관의 목록이라고 생각하시면 돼요. 자료를 그냥 쌓아두면 찾기 어렵잖아요. 인덱스가 있으면 '이 주제 자료 보여줘' 하면 바로 찾아줘요."

### 3-5. 옵시디언 지식 시각화 (옵시디언 활성화 시)

**이 섹션은 `obsidian_enabled = true`인 경우만 진행한다. `obsidian_enabled = false`인 경우 건너뛴다.**

> 옵시디언을 연결하셨으니, 지금까지 구축한 지식을 직접 탐색해볼게요.

#### 라이브 지식 그래프 탐색

> 옵시디언에서 그래프 뷰를 열어보세요. 왼쪽 사이드바에서 그래프 아이콘을 누르면 돼요.
> 아까 사진으로 보여드렸던 그래프가 실제로 움직이는 걸 볼 수 있어요. 노드를 클릭하면 해당 문서로 바로 이동할 수 있어요.
> 자료가 쌓일수록 연결이 더 풍성해져요.

#### 온보딩 캔버스

![[_Settings_/Skills/gobi-onboarding/Gobi Onboarding Status.canvas]]

> 이 캔버스는 고비 데스크탑의 지식 흐름을 보여줘요.
> 자료를 가져오면 인제스트, 요약은 서머리, 주제별 정리는 토픽, 그리고 퍼블리시까지 — 이 흐름이 자동으로 돌아가요.
> 옵시디언에서 이 캔버스를 직접 열어보면 전체 구조를 한눈에 볼 수 있어요.

### 완료 확인 & 전환

> 세 번째 단계 완료! 지식 구축의 기본이 갖춰졌어요.
> 다음은 콘텐츠 생성이에요. 모은 지식으로 글이나 영상을 만들어볼 거예요.

## 4단계: 콘텐츠 생성 (Create Content)

### 에이전트 오프닝

> 네 번째 단계는 콘텐츠 생성이에요.
> 방금 모은 지식을 활용해서 글을 쓰거나 영상을 만들어볼 수 있어요.
> 두 가지를 체험해볼게요.

### 4-1. Writeup (AI 기반 글 작성)

> 첫째, 글 작성이에요. 에이아이가 내 자료를 바탕으로 초안을 만들어줘요.
> 관심 있는 주제 하나를 골라보세요. 아까 프로필에서 파악한 관심사를 바탕으로 추천해드릴 수도 있어요.
> 어떤 주제로 글을 써볼까요?

#### 사용자 응답 시나리오

##### A. 주제 선택
- 사용자: "에이아이 트렌드에 대해 써볼래요" / "[관심 주제]요"
- 에이전트: "좋아요! 볼트에 있는 자료를 바탕으로 초안을 만들어볼게요. 잠시만요."
- (AI가 관련 자료를 검색하고 초안 생성)
- 에이전트: "초안이 완성됐어요! 화면에서 확인해보세요. 수정하고 싶은 부분이 있으면 말씀해주세요."

##### B. 잘 모르겠는 사용자
- 사용자: "뭘 써야 할지 모르겠어요"
- 에이전트: "제가 골라드릴게요. 프로필을 보니 [관심 분야]에 관심이 있으시네요. 이 주제로 짧은 글을 한번 만들어볼까요?"

##### C. 건너뛰기
- 사용자: "나중에 해볼게요"
- 에이전트: "알겠어요. 나중에 '글 써줘'라고 말하면 언제든 도와드릴게요. 다음으로 넘어갈게요."

### 4-2. Video (슬라이드 → 영상 변환)

> 둘째, 영상 만들기예요. 방금 만든 글을 슬라이드로 바꾸고, 거기에 음성을 입혀서 영상으로 만들 수 있어요.
> 마크다운 비디오 파이프라인이라고 하는데, 글만 있으면 자동으로 영상이 만들어져요.
> 체험해볼까요?

#### 사용자 응답 시나리오

##### A. 체험
- 사용자: "네, 해볼게요" / "신기하다, 해보고 싶어요"
- 에이전트: "좋아요! 아까 만든 글을 슬라이드로 변환하고 영상을 만들어볼게요. 몇 분 걸릴 수 있어요."
- (Markdown Video 파이프라인 실행)

##### B. 건너뛰기
- 사용자: "나중에요" / "영상은 안 만들래요"
- 에이전트: "알겠어요. 나중에 '영상 만들어줘'라고 말하면 언제든 도와드릴게요."

##### C. 질문
- 사용자: "어떤 영상이 만들어져요?"
- 에이전트: "슬라이드에 음성 나레이션이 입혀진 프레젠테이션 영상이 만들어져요. 발표 자료나 짧은 설명 영상으로 쓸 수 있어요."

### 완료 확인 & 전환

> 네 번째 단계 완료! 지식으로 콘텐츠를 만들어봤어요.
> 다음은 지식 공유예요. 만든 콘텐츠를 다른 사람들과 나누는 방법을 알아볼 거예요.

## 5단계: 지식 공유 (Share) — TBA

### 에이전트 오프닝

> 다섯 번째 단계는 지식 공유예요.
> 이 기능은 지금 준비 중이에요. 곧 커뮤니티에서 다른 전문가들과 지식을 나눌 수 있게 될 거예요.

### 주요 개념 (상세 설계 예정)

- **커뮤니티 프로필**: 아까 만든 프로필을 커뮤니티에 공개하여 전문가 네트워크 형성
- **공유 주제 선택**: 관심 분야별로 지식을 공유하고 교류
- **외부 발행 연동**: 만든 콘텐츠를 블로그, SNS 등 외부 플랫폼에 발행

> 상세 기능이 나오면 다시 안내드릴게요. 다음 단계로 넘어갈까요?

### 완료 확인 & 전환

> 다섯 번째 단계 완료! 지식 공유 기능은 곧 업데이트될 예정이에요.
> 마지막으로 온보딩을 마무리할게요.

## 온보딩 완료 (Closing)

### 클로징 스크립트

> (전체 완료) 축하해요! 온보딩을 모두 완료하셨어요!
> 피케이엠을 알아보고, 프로필을 만들고, 지식을 구축하고, 콘텐츠도 만들어봤어요.
> 이제 고비 데스크탑이 매일 나를 도와줄 준비가 됐어요.

> (일부 건너뛴 경우) 수고하셨어요! 오늘 완료한 것들을 정리해드릴게요.

에이전트는 완료 항목과 건너뛴 항목을 구체적으로 나열한다:

- **완료 항목 요약**: "PKM 소개, 프로필 만들기, 자료 연결 — 이렇게 설정됐어요."
- **건너뛴 항목 + 활성화 키워드**:
  - 글 작성: "'글 써줘'라고 말하면 돼요"
  - 영상 만들기: "'영상 만들어줘'라고 말하면 돼요"
  - 지식 공유: 곧 업데이트 예정
  - 프로필 동기화: "'프로필 동기화'라고 말하면 돼요"

### 다음 단계 제안

> 이제 뭘 하면 좋을까요? 두 가지를 추천해요.
> 첫째, 자료를 더 넣어보세요. 자료가 쌓일수록 에이아이가 더 잘 도와줘요.
> 둘째, 아무거나 질문해보세요. 내 자료를 바탕으로 답변해줄게요.

### 지속 지원 안내

> 언제든 도움이 필요하면 '도움'이라고 말해주세요.
> 궁금한 게 있으면 뭐든 물어보세요. 항상 여기 있을게요.

### Post-boarding 자동 진입

클로징 완료 후 사용자 응답을 기다리지 않고 바로 Post-boarding으로 이어간다.

**`obsidian_enabled = true`인 경우**: 옵시디언을 이미 1단계 완료 후 설정하고 웹 클리퍼를 3단계에서 설정했으므로, Post-boarding 옵시디언/웹 클리퍼 섹션을 건너뛰고 바로 클로징한다.

> 옵시디언은 이미 연결하셨으니, 추가 설정 없이 바로 마무리할게요.

**`obsidian_enabled = false`인 경우**: 기존대로 Post-boarding 진행.

> 마지막으로 하나만 더 알려드릴게요. 옵시디언을 설치하면 볼트를 더 편리하게 관리할 수 있어요. 간단히 안내해드릴게요.

(Post-boarding 옵시디언 설치 가이드 + 웹 클리퍼 안내를 이어서 진행한 후 마무리)

> 고비와 함께 즐거운 지식 여행 되세요!

## 6단계: Post-boarding

온보딩 이후 추가로 안내하는 항목들이다. Closing에서 자동으로 진입하며, 사용자가 나중에 요청할 때도 안내한다.

### 옵시디언 설치 가이드

**(1단계 완료 후 이미 연동한 경우 건너뜀)**

> 옵시디언을 설치하면 볼트를 더 편리하게 관리할 수 있어요. 고비 데스크탑만으로도 사용할 수 있지만, 옵시디언이 있으면 노트를 직접 편집하고 연결하기가 훨씬 좋아요.
> 관심 있으시면 '옵시디언 설치 알려줘'라고 말해주세요.

### Obsidian Web Clipper 설치

**(3-1에서 이미 설치한 경우 건너뜀)**

> 옵시디언 웹 클리퍼를 설치하면 웹 브라우저에서 바로 관심 있는 글을 볼트에 저장할 수 있어요.
> 웹 클리퍼 설정 화면을 보여드릴게요.

![[_Settings_/Prompts/_files_/owc-config.png]]

## 파이프라인 진행 모니터링

온보딩 중 EIC/EDM 등 파이프라인이 트리거된 후, `_Settings_/Tasks/` 폴더의 태스크 파일을 통해 진행 상황을 추적한다.

### 태스크 파일 구조

파이프라인이 트리거되면 `_Settings_/Tasks/`에 태스크 파일이 자동 생성된다:
- **파일명**: `YYYY-MM-DD {task_type} - {title}.md`
- **주요 프론트매터 필드**:
  - `status`: `PROCESSING` → `PROCESSED` / `FAILED`
  - `task_type`: `EIC`, `EDM`, `GDR`, `TIU`
  - `output`: 출력 파일 위키 링크 (예: `[[AI/Summary/파일명 - EIC]]`)
  - `generation_log`: 로그 파일 링크

### 모니터링 방법

파이프라인 트리거 후 다음 순서로 확인:

1. **태스크 파일 감지**: `_Settings_/Tasks/`에서 해당 `task_type`의 최신 파일을 폴링 (최대 120초, 5초 간격)
2. **상태 확인**: 프론트매터의 `status` 필드 읽기
   - `PROCESSED` → 성공, `output` 필드에서 결과 파일 경로 확인
   - `FAILED` → 실패, `generation_log`에서 원인 확인
   - 파일 미생성 → 파이프라인 미트리거 (file monitor 또는 워커 설정 확인 필요)
3. **결과 파일 확인**: `output` 경로의 파일이 실제로 존재하는지 검증

### 온보딩 중 활용

| 시점 | 파이프라인 | 모니터링 대상 |
|------|-----------|-------------|
| 3단계: 웹 클리핑 후 | EIC | `_Settings_/Tasks/*EIC*` → `AI/Summary/` 출력 |
| 3단계: PDF 추가 후 | EDM | `_Settings_/Tasks/*EDM*` → `Ingest/Documents/*.md` 출력 |
| 3단계: GDR 수동 실행 후 | GDR | `_Settings_/Tasks/*GDR*` → `AI/Roundup/` 출력 |
| 3단계: TIU auto-trigger 후 | TIU | `_Settings_/Tasks/*TIU*` → `Topics/` 출력 |

### 사용자 피드백

파이프라인 완료 시 사용자에게 자연스럽게 알려준다:
- 성공: "요약이 완료됐어요! 에이아이 서머리 폴더에서 확인할 수 있어요."
- 실패: "처리 중에 문제가 생겼어요. 다시 시도해볼까요?"
- 대기 중: "아직 처리 중이에요. 다음 단계를 먼저 진행하고 나중에 확인해볼까요?"

### 대화 중 비동기 진행 안내

EIC/EDM 등 파이프라인이 처리 시간이 길어질 때 (5분 이상) 자연스럽게 안내한다:

- **트리거 시**: "오 분 정도 걸려요. 기다리는 동안 다음 단계 먼저 진행할까요?"
- **완료 시**: 현재 대화를 끊지 않고 자연스럽게 알림 — "아까 가져온 자료 정리가 끝났어요! 나중에 에이아이 서머리 폴더에서 확인해보세요."
- **온보딩 종료 시 미완료**: "아까 가져온 자료가 아직 처리 중이에요. 완료되면 에이아이 서머리 폴더에 자동으로 저장돼요."

## 세션 관리

### 중단 & 재개
- 사용자: "나중에 할게요" / "그만할래요"
- 에이전트: "알겠어요. 지금까지 N단계까지 완료했어요. 나중에 '온보딩 계속'이라고 말씀하시면 여기서 이어서 할 수 있어요. 수고하셨어요!"

- 사용자: "온보딩 계속" / "이어서 하자"
- 에이전트: "다시 오셨군요! 지난번에 N단계까지 완료하셨어요. N+1단계부터 이어서 할게요. 준비되셨나요?"

### 이전 단계로 돌아가기
- 사용자: "돌아가기" / "이전 단계로"
- 에이전트: "어떤 단계로 돌아갈까요? 완료한 단계를 알려드릴게요."
- (완료 단계 목록 제시 후 선택)

### 진행 상황 확인
- 사용자: "어디까지 했어?" / "진행 상황"
- 에이전트: "지금까지의 진행 상황이에요." (프로그레스 바 표시와 함께 안내)

### 도움 요청
- 사용자: "도움" / "뭘 할 수 있어?"
- 에이전트: "사용할 수 있는 명령이 있어요. '계속'하면 다음 단계로, '건너뛰기'는 선택 단계를 넘기고, '다시'는 현재 단계를 다시 하고, '돌아가기'는 이전으로, '진행 상황'은 어디까지 했는지, '중단'은 나중에 이어서 하는 거예요."

## 이미지 표시 가이드

온보딩 중 아래 이미지를 적절한 시점에 사용자에게 보여준다. 이미지는 `_Settings_/Prompts/_files_/`에 저장되어 있다.

| 이미지 | 표시 시점 | 용도 | 표시 조건 |
|--------|----------|------|----------|
| `graph-example.png` | 3단계 Timeline & Graph 시각화 시 | 지식 그래프 예시로 인제스트 결과를 시각적으로 시연 | 3단계를 건너뛰지 않은 경우만 |
| `owc-config.png` | 3-1 (옵시디언 활성화 시) 또는 Post-boarding | 웹 클리퍼 설정 화면을 보여줘서 설치 진입장벽을 낮춤 | 항상 표시 |
| `pbc-canvas.png` | 브레인스톰 기능 안내 시 (참고용) | 패시브 브레인스톰 캔버스 결과 예시 | 관련 기능 활성화 시만 |
| `Gobi Onboarding Status.canvas` | 3-5 온보딩 캔버스 | 온보딩 상황 캔버스 (Ingest → Summary → Topics → Publish 흐름) | 옵시디언 활성화 시만 |
| Obsidian Graph View (라이브) | 3-5 라이브 그래프 탐색 | 실제 지식 그래프 탐색 | 옵시디언 활성화 시만 |

**규칙**: 사용자가 특정 기능을 건너뛰면 해당 기능의 이미지/데모는 표시하지 않는다.

**터미널/음성 환경 폴백**: 이미지가 렌더링되지 않는 환경(터미널, 음성 전용)에서는 각 이미지 아래의 텍스트 폴백을 읽어준다. 사용자가 "안 보여요"라고 할 때도 텍스트 폴백으로 안내한다.

## 부록

### 단축 명령어

| 명령어 | 동작 |
|--------|------|
| 계속 | 다음 단계로 진행 |
| 건너뛰기 | 현재 단계 건너뛰기 (선택 단계만) |
| 다시 | 현재 단계 처음부터 |
| 돌아가기 | 이전 단계 선택 |
| 진행 상황 | 완료/현재/남은 단계 표시 |
| 도움 | 사용 가능한 명령어 안내 |
| 중단 | 진행 상태 저장 후 종료 |

### 용어 사전

| 용어 | 뜻 | TTS 발음 |
|------|-----|----------|
| PKM | Personal Knowledge Management, 개인 지식 관리 | 피케이엠 |
| Vault | 지식 저장소, 볼트 | 볼트 |
| Ingest | 자료 가져오기, 인제스트 | 인제스트 |
| Index | 자동 정리, 인덱스 | 인덱스 |
| Daily Roundup | 매일 자동 요약 정리 | 데일리 라운드업 |
| Topic Index | 주제별 자동 분류 | 토픽 인덱스 |
| Community | 전문가 지식 공유 공간 | 커뮤니티 |
| Q&A | 질문과 답변 | 큐앤에이 |
| OAuth | 구글 로그인 인증 방식 | 오어스 |
| Gemini | 구글 에이아이 백엔드 | 제미나이 |
| Obsidian Importer | 다른 앱 노트 가져오기 도구 | 옵시디언 임포터 |
| Web Clipper | 웹페이지 저장 브라우저 확장 | 웹 클리퍼 |
| DRB (뉴스 브리핑) | Daily Research Briefing, 매일 자동 뉴스 브리핑 | 뉴스 브리핑 |
| Sync/동기화 | 프로필을 커뮤니티에 공개하는 것 (명함 교환 비유) | 동기화 |
| EDM | Extract Document to Markdown, 문서 마크다운 변환 | 이디엠 |
| Writeup | AI 기반 글 작성 | 글 작성 |
| Video | 슬라이드 → 영상 변환 | 비디오 |
| Timeline | 시간순 자료 보기 | 타임라인 |
| Graph | 주제별 지식 연결 시각화 | 그래프 |

### 버전 이력

| 버전 | 날짜 | 변경 내용 |
|------|------|----------|
| v1.0 | 2026-02-04 | 초기 온보딩 시나리오 |
| v2.0 | 2026-02-05 | Voice-First 온보딩, Step-by-step 순차 진행 |
| v2.1 | 2026-02-06 | 유저 테스트 기반 9개 항목 개선 |
| v2.2 | 2026-02-07 | Goal-Oriented 전환 (Build K → Create → Share), 6단계 구조, 사용자 목표 기반 경로 분기, 웹 검색 프로필 보강, 콘텐츠 생성 단계 추가, 인덱스 셋업을 Post-boarding으로 이동 |
| v2.3 | 2026-02-11 | 옵시디언 선택적 온보딩(3-0), 웹 클리퍼 3-1 옵시디언 경로 추가, 토픽 인덱스 후 라이브 그래프+캔버스 시연(3-5), Post-boarding 조건부 진행 |
| v2.3.1 | 2026-02-12 | 프로필 동기화 시 BRAIN_PROFILE.md/BRAIN.jpg 추가, 이미지 텍스트 폴백, DRB/TIU 기존 설정 확인 로직 |
| v2.4 | 2026-02-12 | 옵시디언 질문을 1단계→2단계 전환부로 이동 (BRAIN.md 즉시 확인 가능), 시나리오 캔버스 추가 |

### 학습 이력

(사용자 피드백에 따라 업데이트)
