---
name: attio-mcp-usage
description: Provides universal workflow patterns and best practices for using the Attio MCP server. Complements the attio-workspace-schema skill with HOW-TO guidance for MCP tools and error prevention.
---

# Attio MCP Usage Guide

Universal workflow patterns and best practices for the Attio MCP server.

## Purpose

Teaches universal patterns for:

- Structuring multi-step workflows
- Preventing common API errors
- Using MCP tools correctly
- Building integrations

## Related Skills

**attio-workspace-schema** - Reference for YOUR workspace-specific:

- Attribute slugs and types
- Select/status option values
- List IDs and names
- Read-only fields

> Always check the schema skill for workspace-specific data

## Quick Links

- [Workflows](resources/workflows.md) - Universal workflow patterns
- [Golden Rules](resources/golden-rules.md) - Error prevention system
- [Tool Reference](resources/tool-reference.md) - MCP tool signatures
- [Integration Patterns](resources/integration-patterns.md) - Pattern index

## Pattern Selection

See [Pattern Selection Guide](resources/patterns/README.md) for keyword-based routing to the right pattern for your workflow.

## When to Use This Skill

- Planning multi-step workflows
- Troubleshooting API errors
- Learning MCP tool syntax
- Building integrations
- Understanding best practices

## Key Principles

1. **Schema skill = WHAT** (your specific fields/lists)
2. **Usage skill = HOW** (universal patterns)
3. **Cross-reference** when you need workspace specifics
