---
name: {{skill_name}}
description: {{use_case.description}} for your Attio workspace. Use when working with {{workspace.primary_object}} to implement {{use_case.name}} workflows.
---

# {{skill_name_title}}

{{use_case.description}}.

## When to Use This Skill

Use this skill when you need to:

{{#use_case.workflow_steps}}

- {{description}}
  {{/use_case.workflow_steps}}
  {{^use_case.workflow_steps}}
- Work with {{workspace.primary_object}} records
- Implement {{use_case.name}} workflows
- Follow best practices for {{use_case.name}}
  {{/use_case.workflow_steps}}

## Related Skills

- **attio-mcp-usage** - Universal MCP tool patterns and error prevention
- **attio-workspace-schema** - Your workspace-specific attribute slugs and option values

> Always check the schema skill for workspace-specific attribute slugs and option values

## Quick Links

- [Workflows](resources/workflows.md) - Step-by-step workflow patterns
- [Tool Reference](resources/tool-reference.md) - MCP tool signatures for this workflow
- [Examples](resources/examples.md) - Real-world interaction examples

## Primary Object: {{workspace.primary_object}}

This workflow primarily operates on **{{workspace.primary_object}}** records.

{{#workspace.primary_object_data.has_attributes}}

### Key Attributes

| Attribute | Type | Required | Multi-Select |
| --------- | ---- | -------- | ------------ |

{{#workspace.primary_object_data.attributes}}
| `{{api_slug}}` | {{type}} | {{#is_required}}Yes{{/is_required}}{{^is_required}}No{{/is_required}} | {{#is_multiselect}}Yes{{/is_multiselect}}{{^is_multiselect}}No{{/is_multiselect}} |
{{/workspace.primary_object_data.attributes}}
{{/workspace.primary_object_data.has_attributes}}
{{#workspace.primary_object_data.has_options}}

### Status & Select Options

{{#workspace.primary_object_data.attributes_with_options}}
**{{api_slug}}** ({{type}}):
{{{options_formatted}}}

{{/workspace.primary_object_data.attributes_with_options}}
{{/workspace.primary_object_data.has_options}}

## Workflow Overview

{{#use_case.workflow_steps}}

### {{name}}

{{description}}

**Tools**: {{tools_joined}}

{{/use_case.workflow_steps}}
{{#workspace.has_lists}}

## Lists

| List | Object | ID  |
| ---- | ------ | --- |

{{#workspace.lists}}
| {{name}} | {{parent_object}} | `{{id}}` |
{{/workspace.lists}}
{{/workspace.has_lists}}

## Key Principles

1. **Schema first** - Always check attio-workspace-schema for your specific attributes
2. **API slugs** - Use API slugs, never display names
3. **Validate UUIDs** - Always validate record and list IDs before operations
4. **Array fields** - Multi-select fields require arrays even for single values

---

_Generated by attio-skill-generator on {{metadata.generated_at}}_
_Use case: {{metadata.use_case_key}}_
