# {{use_case.name}} Examples

Real-world interaction examples for {{use_case.description}}.

---

{{#use_case.example_interactions}}

## Example: "{{trigger}}"

**User Request**: {{trigger}}

**Workflow**:

{{response}}

---

{{/use_case.example_interactions}}

## Common Scenarios

### Scenario 1: Process Single Record

**User**: "Process the {{workspace.primary_object}} record for Acme Inc"

**Claude**:

1. Search for {{workspace.primary_object}} by name/domain:
   ```json
   { "resource_type": "{{workspace.primary_object}}", "query": "Acme Inc" }
   ```
2. If found, get full record details
3. Apply workflow steps as defined
4. Update record with results
5. Add note documenting actions taken

### Scenario 2: Batch Process List

**User**: "Process all {{workspace.primary_object}} in the [List Name] list"

**Claude**:

1. Get list entries:
   ```json
   { "list_id": "list-uuid", "limit": 100 }
   ```
2. For each entry (with 100ms delay):
   - Get record details
   - Apply workflow steps
   - Update record
   - Track progress
3. Report summary:
   - Total processed: X
   - Successful: Y
   - Failed: Z

### Scenario 3: Create and Add to List

**User**: "Create a new {{workspace.primary_object}} for [Name] and add to [List]"

**Claude**:

1. Check if record already exists (prevent duplicates)
2. Create new record:
   ```json
   {
     "resource_type": "{{workspace.primary_object}}",
     "data": {"name": "Record Name", ...}
   }
   ```
3. Add to list:
   ```json
   {
     "list_id": "list-uuid",
     "record_id": "new-record-uuid",
     "resource_type": "{{workspace.primary_object}}"
   }
   ```
4. Create follow-up task if needed

### Scenario 4: Move Between Lists

**User**: "Move [Record] from [List A] to [List B]"

**Claude**:

1. Find record in List A (get entry_id)
2. Remove from List A:
   ```json
   { "list_id": "list-a-uuid", "entry_id": "entry-uuid" }
   ```
3. Add to List B:
   ```json
   {
     "list_id": "list-b-uuid",
     "record_id": "record-uuid",
     "resource_type": "{{workspace.primary_object}}"
   }
   ```
4. Update status/stage field if applicable
5. Add note documenting the move

---

## Error Handling Examples

### Invalid UUID

**Error**: "Invalid UUID format"

**Solution**:

1. Verify UUID matches pattern: `xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx`
2. Re-fetch the correct ID using search or list operations
3. Retry with correct UUID

### Field Validation Error

**Error**: "Invalid value for field [field_name]"

**Solution**:

1. Check attio-workspace-schema for field type
2. For select/status: use `records_get_attribute_options` to get valid values
3. For multi-select: ensure value is an array
4. Retry with corrected value

### Record Not Found

**Error**: "Record not found"

**Solution**:

1. Verify the record exists using search
2. Check if you have the correct resource_type
3. If record was deleted, inform user and suggest alternatives

---

## Best Practices

1. **Always search before create** - Prevent duplicates
2. **Validate before update** - Check field exists and is writable
3. **Document changes** - Add notes for audit trail
4. **Handle errors gracefully** - Inform user of failures
5. **Respect rate limits** - Add delays for batch operations

---

_Generated by attio-skill-generator_
