# Tool Reference: {{use_case.name}}

MCP tools used in this workflow with {{workspace.primary_object}}-specific examples.

---

## Search Operations

### records_search

Search for {{workspace.primary_object}} records by query.

```json
{
  "resource_type": "{{workspace.primary_object}}",
  "query": "search term",
  "limit": 10
}
```

**Use when**: Finding existing records before creating duplicates.

---

## Record Operations

### create-record

Create new {{workspace.primary_object}} record.

```json
{
  "resource_type": "{{workspace.primary_object}}",
  "data": {
    "name": "Record Name"
  }
}
```

**Important**: Check attio-workspace-schema for required fields.

### update-record

Update existing {{workspace.primary_object}} record.

```json
{
  "resource_type": "{{workspace.primary_object}}",
  "record_id": "uuid-here",
  "data": {
    "field_slug": "new_value"
  }
}
```

**Important**: Only include fields you want to change.

### get-record

Get full details for a {{workspace.primary_object}} record.

```json
{
  "resource_type": "{{workspace.primary_object}}",
  "record_id": "uuid-here"
}
```

---

## List Operations

### get-lists

Get all lists in the workspace.

```json
{}
```

**Response includes**: List ID, name, parent_object for each list.

### get-list-entries

Get entries from a specific list.

```json
{
  "list_id": "uuid-here",
  "limit": 50
}
```

### add-record-to-list

Add {{workspace.primary_object}} to a list.

```json
{
  "list_id": "uuid-here",
  "record_id": "uuid-here",
  "resource_type": "{{workspace.primary_object}}"
}
```

**Important**: List must have `parent_object` = `{{workspace.primary_object}}`.

### remove-record-from-list

Remove {{workspace.primary_object}} from a list.

```json
{
  "list_id": "uuid-here",
  "entry_id": "entry-uuid-here"
}
```

**Note**: Use entry_id (from list), not record_id.

---

## Task Operations

### create-task

Create follow-up task linked to {{workspace.primary_object}}.

```json
{
  "content": "Task description",
  "title": "Task title",
  "linked_records": [
    {
      "target_object": "{{workspace.primary_object}}",
      "target_record_id": "uuid-here"
    }
  ],
  "due_at": "2024-12-20T10:00:00Z"
}
```

### update-task

Update existing task.

```json
{
  "task_id": "uuid-here",
  "data": {
    "status": "completed"
  }
}
```

---

## Note Operations

### create-note

Add note to {{workspace.primary_object}} record. Supports full markdown formatting.

```json
{
  "resource_type": "{{workspace.primary_object}}",
  "record_id": "uuid-here",
  "title": "Note title",
  "content": "Note content with context",
  "format": "markdown"
}
```

**Markdown support**: Use `\n` for line breaks. Supports headings (`#`), lists (`-` or `1.`), bold (`**text**`), and nested structures with 2-space indentation.

**Example with markdown**:

```json
{
  "resource_type": "{{workspace.primary_object}}",
  "record_id": "uuid-here",
  "title": "Meeting Notes",
  "content": "## Summary\n- Key point 1\n- Key point 2\n\n## Next Steps\n1. Action item",
  "format": "markdown"
}
```

### get-notes

Get notes for a record.

```json
{
  "resource_type": "{{workspace.primary_object}}",
  "record_id": "uuid-here"
}
```

---

## Discovery Operations

### records_discover_attributes

Discover attributes for {{workspace.primary_object}}.

```json
{
  "resource_type": "{{workspace.primary_object}}"
}
```

**Use when**: Need to know available fields and their types.

### records_get_attribute_options

Get valid options for select/status fields.

```json
{
  "resource_type": "{{workspace.primary_object}}",
  "attribute": "status_field_slug"
}
```

**Use when**: Need valid option values for select/status updates.

---

## Important Validation Rules

### UUID Format

Always validate UUIDs before operations:

```
Format: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
Example: 88709359-01f6-478b-ba66-c07347891b6f
```

### Array Fields

Multi-select fields require arrays even for single values:

```json
// Correct
"domains": ["example.com"]

// Wrong
"domains": "example.com"
```

### Data Types

Match types exactly from schema:

- **Numbers**: `85` (not `"85"`)
- **Booleans**: `true` (not `"true"`)
- **Dates**: `"2024-12-14"` (ISO 8601)

### Read-Only Fields

Some fields cannot be updated (e.g., `created_at`, computed fields).
Check attio-workspace-schema for `is_writable` flag.

---

_Generated by attio-skill-generator_
