# {{use_case.name}} Workflows

Detailed workflow patterns for {{use_case.description}}.

---

{{#use_case.workflow_steps}}

## {{name}}

{{description}}

### Tools Required

{{#tools}}

- `{{.}}`
  {{/tools}}
  {{^tools}}
- Check tool-reference.md for applicable tools
  {{/tools}}

{{#example}}

### Pattern

```
{{example}}
```

{{/example}}

{{#scoring_criteria}}

### Scoring Criteria

| Criterion | Points |
| --------- | ------ |

{{#scoring_criteria}}
| {{criterion}} | {{points}} |
{{/scoring_criteria}}
{{/scoring_criteria}}

{{#routing_rules}}

### Routing Rules

{{#routing_rules}}

- **If** {{condition}}: {{action}}
  {{/routing_rules}}
  {{/routing_rules}}

{{#milestones}}

### Milestones

{{#milestones}}

- [ ] {{.}}
      {{/milestones}}
      {{/milestones}}

---

{{/use_case.workflow_steps}}

## Universal Patterns

### Find or Create

```
1. Search for existing record by unique identifier (domain, email, etc.)
2. If found, return existing record
3. If not found, create new record
4. Return record ID for subsequent operations
```

### Batch Update

```
1. Get records from list using get-list-entries
2. Iterate with rate limiting (100ms delay recommended)
3. Update each record with error handling
4. Log progress and collect failures
5. Report summary when complete
```

### Pipeline Movement

```
1. Validate current stage is valid transition source
2. Update status/stage field
3. Move to/from appropriate lists
4. Create note documenting stage change
5. Create follow-up task if needed
```

## Cross-References

- **Attribute slugs**: Check attio-workspace-schema for YOUR workspace values
- **List IDs**: Use `get-lists` to discover available lists
- **Option values**: Use `records_get_attribute_options` for valid select/status values

---

_Generated by attio-skill-generator_
