# Learning Capture Patterns

This reference provides detailed patterns for different types of learning sessions.

## Technical/Programming Sessions

### Structure
```markdown
# [Technology/Language] Learnings: [Topic]

## Summary
[What was built, debugged, or learned]

## Technical Concepts Covered
1. [Concept 1]: Brief explanation
2. [Concept 2]: Brief explanation

## Implementation Details

### [Feature/Component Name]
**Purpose:** What it does
**Implementation:**
```[language]
[code example]
```
**Key points:**
- [Important detail 1]
- [Important detail 2]

**Gotchas:**
- [Common pitfall and how to avoid]

## Commands/Syntax Quick Reference
```bash
# [Description]
command --flag value

# [Description]
another-command
```

## Debugging Lessons
**Problem:** [Issue encountered]
**Root cause:** [What was actually wrong]
**Solution:** [How it was fixed]
**Prevention:** [How to avoid in future]

## Next Steps
- [ ] Practice by [specific exercise]
- [ ] Read documentation on [topic]
- [ ] Build [mini-project] to reinforce
```

## Conceptual/Theory Sessions

### Structure
```markdown
# Learnings: [Concept/Theory Name]

## Core Concept
[Clear, concise explanation of the main idea]

## Why It Matters
[Context and significance in the broader field]

## Key Principles

### Principle 1: [Name]
**Explanation:** [What it is]
**Application:** [How to use it]
**Example:** [Concrete illustration]

### Principle 2: [Name]
[...]

## Mental Models
[Frameworks or ways of thinking about this concept]

## Real-World Applications
1. **[Use case 1]:** [Description]
2. **[Use case 2]:** [Description]

## Common Misconceptions
- **Myth:** [Common misunderstanding]
  **Reality:** [Actual truth]

## Related Concepts
- [Concept A]: [How it relates]
- [Concept B]: [How it relates]

## Further Reading
- [Resource 1]
- [Resource 2]
```

## Research/Discovery Sessions

### Structure
```markdown
# Research Findings: [Topic]

## Research Question(s)
1. [Primary question explored]
2. [Secondary question]

## Methodology
[How information was gathered - searches, sources consulted, analysis approach]

## Key Findings

### Finding 1: [Headline]
**Evidence:** [What supports this]
**Source:** [Where this came from]
**Implications:** [What this means]
**Confidence level:** [High/Medium/Low and why]

### Finding 2: [Headline]
[...]

## Synthesis
[Bringing findings together - patterns, contradictions, overall picture]

## Gaps and Uncertainties
- [What we don't know yet]
- [Conflicting information]
- [Areas needing more research]

## Actionable Insights
1. [What to do with finding 1]
2. [What to do with finding 2]

## Sources Consulted
- [Source 1]: [Key information found]
- [Source 2]: [Key information found]

## Follow-Up Research
- [ ] Investigate [specific aspect]
- [ ] Compare with [alternative approach]
- [ ] Validate [finding] with [method]
```

## Problem-Solving Sessions

### Structure
```markdown
# Problem Resolution: [Issue Description]

## The Problem
**Symptoms:** [What went wrong]
**Impact:** [Who/what was affected]
**Context:** [When/where it occurred]

## Investigation Process
1. [First diagnostic step taken]
   - Finding: [What was learned]
2. [Second step]
   - Finding: [What was learned]

## Root Cause Analysis
**Identified cause:** [The actual problem]
**Why it occurred:** [Underlying factors]
**How it manifested:** [Why symptoms appeared as they did]

## Solution Implemented

### Immediate Fix
```[language/format]
[Code, configuration, or steps taken]
```
**Why this works:** [Explanation]

### Long-term Prevention
- [Change 1 to prevent recurrence]
- [Change 2 to catch earlier]

## Lessons Learned
1. **[Lesson 1]:** [Insight gained]
   - Apply by: [How to use this knowledge]
2. **[Lesson 2]:** [Insight gained]
   - Apply by: [How to use this knowledge]

## Red Flags for Future
[Warning signs to watch for that indicate similar issues]

## Testing/Validation
[How solution was verified]

## Documentation Updates Needed
- [ ] Update [document/wiki] with [information]
- [ ] Add to troubleshooting guide
```

## Decision Documentation Sessions

### Structure
```markdown
# Decision: [What was decided]

## Context
**Situation:** [What prompted this decision]
**Constraints:** [Limitations, requirements, deadlines]
**Stakeholders:** [Who is affected or involved]

## Options Considered

### Option 1: [Name]
**Description:** [What this would involve]
**Pros:**
- [Advantage 1]
- [Advantage 2]

**Cons:**
- [Disadvantage 1]
- [Disadvantage 2]

**Estimated effort:** [Time/resources needed]

### Option 2: [Name]
[...]

## Decision Made
**Chosen approach:** [Option selected]

## Rationale
[Why this option was selected over others]

Key factors:
1. [Factor 1 and its weight]
2. [Factor 2 and its weight]

## Implementation Plan
1. [Step 1 with owner and timeline]
2. [Step 2 with owner and timeline]

## Success Criteria
[How we'll know this decision was correct]
- [Metric 1]
- [Metric 2]

## Risks and Mitigations
- **Risk:** [Potential problem]
  **Mitigation:** [How to address]

## Review Date
[When to reassess this decision]
```

## Workshop/Brainstorming Sessions

### Structure
```markdown
# Workshop: [Topic/Goal]

## Session Goal
[What we were trying to achieve]

## Participants
[Who was involved and their roles]

## Key Ideas Generated

### Theme 1: [Name]
**Ideas:**
1. [Idea 1]
   - Potential: [Why interesting]
   - Challenges: [What's difficult]
2. [Idea 2]
   [...]

### Theme 2: [Name]
[...]

## Emerging Patterns
[Common threads or insights across ideas]

## Most Promising Directions
1. **[Direction 1]:** [Why it's promising]
   - Next step: [How to explore]
2. **[Direction 2]:** [Why it's promising]
   - Next step: [How to explore]

## Challenges Identified
- [Challenge 1]: [Potential approaches]
- [Challenge 2]: [Potential approaches]

## Action Items
- [ ] [Person]: [Task with context]
- [ ] [Person]: [Task with context]

## Parking Lot
[Ideas or topics to revisit later]
```

## Tutorial/Training Sessions

### Structure
```markdown
# Training: [Topic/Skill]

## Learning Objectives
By the end of this session, I should be able to:
- [Objective 1]
- [Objective 2]
- [Objective 3]

## Prerequisites
[What knowledge/setup was needed]

## Core Concepts

### Concept 1: [Name]
**Definition:** [What it is]
**Why it's important:** [Context]
**How to use:** [Application]

## Hands-On Practice

### Exercise 1: [Name]
**Task:** [What was built/done]
**New skills used:**
- [Skill 1]
- [Skill 2]

**Key learnings:**
- [Learning 1]
- [Learning 2]

**Code/output:**
```[language]
[example]
```

## Tips and Best Practices
- [Tip 1]: [Why it helps]
- [Tip 2]: [Why it helps]

## Common Mistakes
- [Mistake 1]: [How to avoid]
- [Mistake 2]: [How to avoid]

## Resources for Practice
- [Resource 1]: [What to practice]
- [Resource 2]: [What to practice]

## Self-Assessment
**What I can do now:** [Capabilities gained]
**What I need more practice on:** [Areas to develop]
**Next learning step:** [What to study next]
```

## Usage Guidelines

1. **Choose the pattern** that best matches the session type
2. **Adapt sections** as needed - not every section applies to every session
3. **Prioritize quality over completeness** - better to have fewer well-captured learnings than many superficial ones
4. **Include examples** - concrete illustrations make learnings stick
5. **Make it actionable** - always include what to do with this knowledge
