# Obsidian Vault Context

## Vault Structure
- Daily notes: /Calendar/YYYY-MM-DD.md
- Projects: /Efforts/[project-name]/
- Knowledge: /Atlas/[domain]/
- Templates: /.templates/

## Naming Conventions
- Use lowercase with hyphens for file names
- Date format: YYYY-MM-DD
- Tag format: #category/subcategory

## Common Workflows
- Daily notes use template: [[.templates/Daily Note]]
- Project notes include status:: and priority:: in frontmatter
- Literature notes link to source:: in frontmatter
- Weekly reviews happen on Monday mornings

## Quality Standards
- All notes must have frontmatter with: title, created, tags
- Link to related notes using [[wikilinks]]
- Use callouts for important information
- Keep notes atomic (one main idea per note)
- Add notes to relevant MOCs

## Automation Rules
- When creating project notes, add to relevant MOC
- When organizing notes, preserve existing links
- Always preview changes before applying to multiple files
- Backup vault before major batch operations