---
name: 3-levels-of-money
description: |
  Dan Koe's framework for understanding your relationship with money and escaping wage slavery.

  TRIGGERS:
  - When user feels trapped in their job or "wage slavery"
  - When user asks about money mindset or relationship with money
  - When user wants to escape the 9-5
  - When user feels empty despite making money
  - When user asks about pursuing their "life's work"
  - When user mentions feeling like they're in survival mode

  CAPABILITIES:
  - Diagnose which money level the user is at
  - Provide the path to the next level
  - Apply the Anti-Vision protocol for motivation
  - Guide through the phases of development (Dissonance → Uncertainty → Discovery)
---

# The 3 Levels of Money

From Dan Koe's article "The 3 Levels Of Money (How To Escape Wage Slavery)"

## The Framework

Everyone plays one of three money games:

### Level 1: Survival (90% of people)
**Money as master.** Make enough to not die.

Characteristics:
- Work is seen as necessary suffering
- Exchanging time is the only way to make money
- Retirement is the only escape
- Inherited patterns from parents (save for emergencies, pursue high-paying job as end goal)
- Compare down ("at least I'm not homeless")
- Hope to win the lottery

Shadow patterns at this level:
- Judge wealthy people as immoral or lucky
- Bond with friends by complaining
- Mistake being cheap for wisdom
- Manufacture drama for excitement instead of pursuing exciting goals

### Level 2: Success (9% of people)
**Money as scoreboard.** Make enough to matter.

Characteristics:
- Escaped the job but built a new 9-5
- Chase revenue and status
- Feel empty despite the money
- Identity tied to income
- Neglect other life domains (mind, body, spirit, relationships)

The trap: Thinking the solution to emptiness is to stop making money. Wrong. Money at level 3 reflects complex development and value.

### Level 3: Sacred (1% of people)
**Money as energy.** Make enough to authentically create.

Characteristics:
- Work feels like play
- Discipline is the default
- Can't wait to get up and do what you love
- Learning and earning collapse into one
- Feel responsibility to customers
- Don't need an escape because you wouldn't want to be doing anything else

## The Path Between Levels

**You cannot skip levels.**

Level 1 → Level 2: Solve survival problems
- Get fed up with living by someone else's script
- Experience dissonance (realize where your path leads)
- Enter uncertainty (experiment with side hustles, skills)
- Discovery (find hidden value you can offer)
- Enter a "channel" of intense development

Level 2 → Level 3: Solve success problems
- Get fed up with chasing success in isolation
- Have a meaning crisis
- Realize your work isn't your life's work (if it was, it wouldn't be for sale)
- Develop other life domains (mind, body, spirit)
- Find work that you'd do regardless of payment

## The Development Phases

Every level transition follows three phases:

1. **Dissonance**: Become aware of where your life is heading. Map it out. Feel the pain.
2. **Uncertainty**: Use distaste as fuel to experiment. Learn, fail, persist.
3. **Discovery**: Realize you have hidden value. Focus energy. Get sucked in.

Accelerants:
- **Channels**: Periods of intense, obsessive development that compress years into months
- **Glitches**: High-risk accelerants (life crisis, do-or-die situations)

## The Max Story (Level 1 → Level 2 Example)

Marketing coordinator, $45K, gaming weekends, Monday dread.

Trigger: Sees friends making 3x at startup. Gets rejected for promotion. Does life math: 3% raises = $52K in 5 years while rent increases $200/month yearly.

Process:
1. Buys self-help books, watches Hormozi, joins communities (uncertainty)
2. Tries dropshipping, crypto, FBA (all fail)
3. Realizes he has one skill: Google Ads from his job
4. Finds a Twitter thread on freelancing with Google Ads
5. Emails local gym: "Only pay me if it works"
6. First $500 from his own will. Internal shift.
7. Month 15: Quits job.

Key: He started with his profession (existing skill) and amplified it.

## Application Questions

To diagnose level:
- Do you see work as necessary suffering? (Level 1)
- Do you feel empty despite revenue growth? (Level 2)
- Does your work feel like play? (Level 3)

To create dissonance:
- In 5 years, if nothing changes, what does your average day look like?
- What areas of life are you sacrificing for money?
- Who would you become if your only identity was your revenue?

To find the path:
- What pain point, passion, or profession could become independent income?
- What skills have you developed that others would pay for?
- What would you do if you didn't need the money?

## Key Quotes

"Money is not evil. That's level 1 thinking."

"If Loom was truly his life's work, it wouldn't be for sale."

"You can make millions at any level - but your relationship with money is drastically different."

"Happiness is resistance being overcome."

## The Meta Model: Creator Path

The most accessible path to Level 3 in the digital age:
1. Build your own thing and put it in front of people
2. Start with pain point, passion, or profession
3. Use digital leverage (content, products, software)
4. Pursue meaning-driven markets

You're not becoming a "content creator" - you're using creator tools to pursue your life's work.
