---
name: advertising
description: |
  Dan Koe's framework for learning advertising as the meta-skill for ambitious people.

  TRIGGERS:
  - When user thinks marketing is sleazy or manipulative
  - When user can't sell their work or get clients
  - When user asks about copywriting or persuasion
  - When user has skills but no income from them
  - When user asks how to get their work noticed
  - When user resists self-promotion

  CAPABILITIES:
  - Reframe advertising as natural and ethical
  - Teach the 3 foundations of value communication
  - Provide learning path for advertising skills
  - Show how to use AI to accelerate learning
  - Connect advertising to getting what you want in life
---

# Every Ambitious Person Must Learn This Skill

From Dan Koe's article "Every ambitious person must learn this skill"

## The Uncomfortable Truth

**If you don't advertise your work, you will not earn money from that work.**

This means: If you can't illustrate how what you do benefits someone else's life, you'll be forced to do someone else's work. You won't control the advertising. You'll be more susceptible to manipulation.

If you don't create a product to sell, you'll sell products for someone else. Your creativity won't be self-directed.

## The Reframe

You already advertise. You just do it unconsciously:
- Describe your weekend (present a version of yourself)
- Persuade friends to go to a specific restaurant
- Plead your case in job interviews
- Recommend your favorite show
- Choose what to wear on a first date
- Get your kids to eat vegetables
- Tell stories

**If you practiced this consciously:**
- You'd get more of what you want
- You'd control how much damage you do (avoid manipulation)
- You'd be less susceptible to being manipulated

## The Historical Truth

Michelangelo advertised to the Medicis.
Shakespeare wrote for commercial theater.
The starving artist is a modern myth.

Historical artists were great marketers. That's why you know their names.

Even in nature: Animals that don't signal (advertise) their value don't reproduce. Peacocks advertise.

**Advertising is natural selection in a capitalistic society.**

## The Moral Question

Advertising carries baggage, but it's just a concept - a description of an act.

It's not inherently manipulative. But if used by those at lower stages of psychological and moral development, their manipulative tendencies shine through.

**You can't persuade someone to buy a bad product** (unless they're drunk - which is unethical territory).

The goal: Get what you want in life without becoming someone you hate.

## The 3 Foundations

To immediately improve your perceived value, nail these:

### 1. What is the big problem you solve?

- Be specific
- Make it relatable
- Something people recognize in themselves

### 2. What is the desired outcome you promise?

- Where do they end up?
- What does their life look like after?
- Paint the picture

### 3. What is your unique mechanism?

- How do YOU solve the problem?
- What's different about your approach?
- Why should they trust your method?

**To get these right:** Target a specific person. Understand their problems and desires more than they do.

## The Learning Path

### Level 1: Tactical Foundation
**Read:** Ca$hvertising by Drew Eric Whitman
- Great beginner introduction to direct response marketing
- Very tactical
- Adapt the tactics to your authentic voice

### Level 2: Deep Psychology
**Read:**
- Flow by Mihaly Csikszentmihalyi (understand flow psychology, apply to products)
- Breakthrough Advertising by Eugene Schwartz (customer psychology, positioning)

### Level 3: Practical Application
**Take:** Any course on direct response marketing/copywriting
- Courses are more practical
- Learn fundamentals by doing

## Using AI to Learn Faster

**Imitate, then innovate.** Learn the rules before breaking them.

**The Process:**

1. Find content that performed well (newsletter, landing page, post)
2. Paste into AI with this prompt:
```
I want you to break down the exact structure of this [newsletter/landing page/etc] so I can replicate it with other topics or ideas. Break down:
- Macro structure
- Structure of each section
- Psychological tactics used to hold attention
- Core types of ideas that compose it

Make this comprehensive, include examples, and act as if you are teaching me how to replicate it.
```

3. Now you have a mini-course on that style
4. Ask AI to guide you through creating your own version
5. Ask for improvement suggestions as you write

**Apply this to:** Your own top-performing content to understand why it worked.

## Combining Learning

**If you don't know what to write about, write about the difficult thing you're trying to learn.**

Learning is doing. Reading 10 books doesn't increase skill - you still make the same mistakes until you practice.

**The Protege Effect:** The teacher learns more than the student.

Write about:
- Advertising
- Psychology
- Human behavior
- Whatever you're learning

Think of writing as slightly more formal notes. You don't need to be an expert - share what you're learning.

## The Practical Path

1. **Find something that worked** (not yours - someone you respect)
2. **Break it down with AI** (structure, psychology, tactics)
3. **Create your version** with AI guiding you
4. **Post it publicly** (internet = no barrier to entry)
5. **Get feedback from reality** (not from books)
6. **Refine and repeat**

## Key Quotes

"You say you despise marketing, sales, and advertising, yet you do it everyday. You just do it unconsciously."

"The starving artist is a modern myth. Historical artists were great marketers."

"You can't persuade someone to buy a bad product."

"Learning is doing. Most people don't understand that."

## The Bottom Line

Advertising isn't evil. It's communication.

The question isn't whether to advertise. You already do.

The question is: Will you do it consciously and ethically to get what you want? Or unconsciously while being manipulated by those who learned it?

Every skill you have is worthless if nobody knows about it.
