# How to Use AI Better Than 99% of People

Dan Koe's framework for using AI effectively through prompt engineering and workflow design.

## Source

Based on: ["How to use AI better than 99% of people"](https://letters.thedankoe.com/p/how-to-use-ai-better-than-99-of-people)

## The Core Problem

Most people type one sentence and expect magic. AI then guesses based on the average of everything it's trained on → average output.

## The Solution

Think of AI as a digital employee. Write 500-2000 word prompts. Narrow the context to prevent guessing.

## When to Use

- User gets mediocre AI outputs
- User wants AI to help with content creation
- User asks about AI for business or learning
- User treats AI like a slot machine

## The Two-Step System

### Step 1: Create Detailed Instructions
Four options:
1. Write it yourself (if expert)
2. Ask AI to create a guide (if well-known task)
3. Feed expert source → extract guide
4. Reverse-engineer examples you like (favorite)

### Step 2: Turn into Context-Gathering Prompt
- Phase 1: Context gathering (interview)
- Phase 2: Execution (create + refine)

## Key Concepts

- **Prompt Creator**: A prompt that creates prompts
- **Prompt Library**: Document your processes as prompts
- **For utility tasks**: Use AI freely
- **For meaning tasks**: Be careful not to avoid skill development
