# How to Articulate Yourself Intelligently

Dan Koe's frameworks for articulating ideas intelligently in writing and speaking.

## Source

Based on: ["How to articulate yourself intelligently"](https://letters.thedankoe.com/p/how-to-articulate-yourself-intelligently)

## The Core Insight

The best communicators have an "inner album of greatest hits" - 8-10 core ideas that connect to almost any topic. They don't improvise from scratch; they remix proven material.

## When to Use

- User wants to write a post, thread, or newsletter
- User is preparing for a podcast or presentation
- User wants to explain a complex idea clearly
- User struggles to communicate their thoughts

## The Three Methods

| Method | Level | Best For |
|--------|-------|----------|
| Micro Story (Problem-Amplify-Solution) | Beginner | Social posts, quick explanations |
| Pyramid Principle | Intermediate | Essays, presentations, arguments |
| Cross-Domain Synthesis | Advanced | Thought leadership, newsletters |

## Key Concepts

- **Inner Album of Greatest Hits**: Your 8-10 biggest ideas
- **Idea Legos**: Modular components (anecdotes, metaphors, frameworks)
- **Practice Loop**: Consume → Write → Speak → Notice what lands → Refine
