---
name: articulation
description: |
  Dan Koe's frameworks for articulating ideas intelligently in writing and speaking.

  TRIGGERS:
  - When user wants to write a post, thread, or newsletter
  - When user is preparing for a podcast or presentation
  - When user wants to explain a complex idea clearly
  - When user says "help me articulate" or "how do I explain"
  - When user is drafting content that needs to be compelling
  - When user struggles to communicate their thoughts

  CAPABILITIES:
  - Apply the Micro Story framework (beginner)
  - Apply the Pyramid Principle (intermediate)
  - Apply Cross-Domain Synthesis (advanced)
  - Build an "inner album of greatest hits"
  - Create "Idea Legos" for flexible content creation
---

# How to Articulate Yourself Intelligently

From Dan Koe's article "How to articulate yourself intelligently"

## The Core Insight

The best communicators don't directly answer questions. They have an "inner album of greatest hits" - their 8-10 biggest ideas that connect to almost any topic.

When asked a question, they:
1. Identify which of their core ideas relates
2. Speak that idea with confidence
3. Expand based on conversation flow

This is why they seem so articulate - they're not improvising from scratch. They're remixing proven material.

## The Inner Album of Greatest Hits

Before you can articulate well, you need ideas worth articulating.

**Build your album:**
1. Identify 8-10 ideas you return to repeatedly
2. Ideas that can connect to multiple topics
3. Ideas you've refined through thinking and conversation
4. Your unique perspectives on universal problems

**How to develop these:**
- Notice which ideas you keep coming back to
- Pay attention to what resonates when you share it
- Refine through writing and conversation
- Cross-pollinate from different domains

## The Three Articulation Methods

Choose based on your skill level and context:

### Method 1: Micro Story (Beginner)

The classic Problem-Agitate-Solution structure.

**Structure:**
1. **Problem**: State a relatable problem clearly
2. **Amplify**: Show the negative outcome if unsolved (create urgency)
3. **Solution**: State the solution concisely

**Example:**
- Problem: "Most people can't explain their ideas clearly."
- Amplify: "This means their best thinking never spreads. They stay invisible."
- Solution: "The fix: Build an inner album of your 8-10 best ideas."

**Best for:** Social posts, quick explanations, hooks

### Method 2: Pyramid Principle (Intermediate)

Lead with the conclusion, then support it. From Barbara Minto's consulting framework.

**Structure:**
1. **Main Idea**: Lead with key conclusion/thesis
2. **Key Arguments**: 3-5 supporting points
3. **Evidence**: Data, examples, analysis for each argument

**Example:**
- Main idea: "Generalists will win in the AI age"
- Arguments: (1) AI commoditizes specialist knowledge (2) Unique combinations can't be replicated (3) Adaptability beats expertise
- Evidence: Examples, data, stories for each

**Best for:** Essays, presentations, persuasive arguments

### Method 3: Cross-Domain Synthesis (Advanced)

Import patterns from one field to illuminate another. This creates genuinely novel insights.

**Structure:**
1. **Problem + Amplify**: Hook with relatable problem
2. **Cross-domain concept**: Import pattern from another field
3. **Unique solution**: Steps derived from personal contemplation

**Example:**
- Problem: "Writers stare at blank pages for hours"
- Cross-domain: "Musicians don't compose from silence - they remix samples and loops"
- Solution: "Build an idea museum. Collect others' best ideas. Your originals emerge from remixing."

**Best for:** Thought leadership, newsletters, differentiated content

## Method Selection Guide

| Situation | Method | Why |
|-----------|--------|-----|
| Quick social post | Micro Story | Fast, punchy, shareable |
| Explaining a concept | Pyramid | Logical, easy to follow |
| Newsletter/essay | Cross-Domain | Novel, memorable, positions you as thinker |
| Podcast answer | Greatest Hits + expand | Confident, practiced, adaptable |
| Complex topic | Pyramid + Micro Stories | Structure with emotional hooks |

## Idea Legos

Build modular "legos" you can snap together:

**Components to collect:**
- Personal anecdotes that illustrate points
- Cross-domain metaphors
- Contrarian takes on common advice
- Frameworks with memorable names
- Statistics or studies that surprise
- Quotes from thinkers you respect

**How to use:**
- Start with a framework (gives structure)
- Add an anecdote (makes it real)
- Include a contrarian take (makes it interesting)
- End with actionable step (makes it useful)

## The Practice Loop

1. **Consume widely**: Read across domains to build cross-pollination material
2. **Write daily**: Even just notes - writing is thinking made visible
3. **Speak your ideas**: Podcasts, conversations, voice memos
4. **Notice what lands**: Which ideas get reactions? Those go in the album.
5. **Refine and remix**: Your best ideas get sharper with repetition

## Workflow for Content Creation

1. **Start with one idea from your Greatest Hits**
2. **Choose the appropriate method** based on format and audience
3. **Draft quickly** without editing (separate creation from criticism)
4. **Add Idea Legos** where the draft feels thin
5. **Edit for clarity** (cut ruthlessly, simplify language)
6. **Test with trusted reader** if possible

## Key Quotes

"The best communicators don't answer questions. They speak their best idea on that topic."

"You don't need more information. You need to articulate what you already know."

"Writing is thinking made visible."

## Common Mistakes

- Trying to say everything (pick ONE main idea)
- Starting with context instead of the point (lead with conclusion)
- Using jargon to sound smart (simple > elaborate)
- Not having pre-developed ideas (build the album first)
- Improvising when you could be remixing (preparation beats improv)
