---
name: 24-months-skills
description: |
  Dan Koe's framework for navigating the AI shift and skills that matter in the next 24 months.

  TRIGGERS:
  - When user asks what skills to learn
  - When user worried about AI taking jobs
  - When user asks about future-proofing career
  - When user wants to understand the AI shift
  - When user feels behind on technology
  - When user asks about adapting to change

  CAPABILITIES:
  - Explain the 3 types in every technological shift
  - Guide through the "liberating arts" framework
  - Show how skills abstract upward
  - Provide actionable learning priorities
  - Help user become "the curious" type
---

# You Have About 24 Months to Learn These Skills

From Dan Koe's article "You have about 24 months to learn these skills"

## The Shift

Something changed recently. The tools got better. People became angrier. People who found useful AI applications started pulling ahead (visibly).

The pattern is clear if you study history. But the timescale is compressed.

**Printing press:** Decades to spread across Europe
**Industrial Revolution:** Unfolded over a century
**AI:** Moving faster than all of them

The penalty for starting late is exponential, not linear. The person experimenting today will be unrecognizable in 2 years. The person who waits will find the entry-level gone.

## The 3 Types in Every Shift

Every technological/cultural shift reveals three types of people:

### 1. The Resisters
- Attach identity to the way things were done
- See new tools as threat to sense of self
- Artists screaming that AI users are "bad people"
- Writers saying good writing can't be replaced
- Creatives rage-posting while refusing to learn

**If you can, avoid these people. If you are one, keep an open mind.**

### 2. The Waiters
- See change happening
- Tell themselves it will "blow over"
- Dependent on others for job, direction, survival
- Don't know another way

**The problem:** The gap is exponential. You can't wait a few years and catch up like before. People experimenting today are compounding monthly.

### 3. The Curious
- Stay curious, experiment, build
- Figure out how to adopt in their own way
- Don't romanticize the past or fear the future
- Understand new things have a time lag before becoming useful
- Know it takes trial and error to make it work for them

**This is the goal. Always be the curious one.**

## The Pattern of History

People act like technological disruption is new. It's not.

**Printing press:** Scribes spent years mastering manuscript copying. A single press produced 3,600 pages per workday. Scribes who refused to adapt disappeared. Those who learned the machines thrived.

**Industrial Revolution:** Hand-weavers protested, some smashed machines. Mechanized spinning increased output 500x. New jobs emerged: printers, typesetters, operators, engineers.

**The pattern:** Skills abstract upward.
- Scribe → Editor
- Hand-weaver → Machine operator
- Typesetter → Designer

Humans become "universal explainers" at a higher level. The tools change. The capacity to wield them does not.

## Skills Abstracting Up

Dan's personal example with writing:

"I said I'd never use AI to write. Writing is my craft, how I think."

**What changed:** Found a process where AI handles labor while he controls thinking.

His process:
1. Start with outline of points and ideas (extensive, practically writes the piece)
2. Feed books and past content for context (AI understands his worldview)
3. Flesh out ideas while AI researches alongside
4. AI surfaces patterns and information that would take hours to find
5. Comb through drafts, make cuts, redirect, push harder where alive
6. Add "commentary" on places lacking depth

"The words are still mine. But my job changed. And I'm writing more than ever."

**The parallel:**
- Scribe copied letters → Printing press → Editor decides what's worth printing
- Writing words manually → AI assistance → Directing what ideas are worth expressing

The craft remains. The skill abstracts upward into:
- Originality of thought
- Voice that's unmistakably yours
- Making someone see something new
- Taste

## What Actually Matters

**No skill is going to save you.**

What will: The ability to learn any skill fast.

Devon Eriksen's "liberating arts" - skills free people need:

| Skill | What It Is |
|-------|-----------|
| Logic | Deriving truth from known facts |
| Statistics | Understanding implications of data |
| Rhetoric | Persuading, and spotting persuasion tactics |
| Research | Gathering information on unknown subjects |
| Psychology | Discerning true motives of yourself and others |
| Investment | Managing and growing assets |
| Agency | Deciding what to pursue and acting without permission |

These aren't skills learned from books. They're capacities developed by doing things that demand them.

## The 3 Things That Demand Everything

Three activities that force development of all liberating arts:

### 1. Build Your Own Thing and Put It in Front of People

A product, project, or work with your name on it.

Forces:
- **Rhetoric:** Must persuade people to care
- **Psychology:** Must understand what others actually want
- **Agency:** Must act without permission

You learn by getting feedback from reality, not from books.

### 2. Write Publicly, Consistently

Writing is compressed thinking.

Forces:
- **Logic:** Weak arguments collapse on the page
- **Research:** Can't fake depth

Also:
- Exposes where ideas are thin
- Builds compounding asset (audience, reputation, proof of work)

Even with AI, there will be skilled and unskilled writers. The distinction lies in:
- Density of ideas
- Quality of argument
- Synthesis of concepts
- Novelty of perspective

Not the labor of putting words on paper.

### 3. Use AI to Do Things You Couldn't Do Before

Not just things you didn't want to do.

Most people use AI to avoid work. The edge goes to people using AI for previously impossible work:
- Research that would take weeks
- Synthesis across dozens of sources

**The question:** "What can I do now that I couldn't before?" > "How do I do less?"

## The Three Questions

After reading this, question:
1. Every skill you have
2. Every habit you repeat without thought
3. Every default way you spend time

**The test:** If you do the same things every day for the rest of your life, does that lead to a future you want?

Are you on the cutting edge, or settling for average?

## The Path Forward

There is something you can do that won't be entirely replaced.

Some combination of:
- Your taste
- Your judgment
- Your way of seeing problems

**Your job:** Find that thing.

You won't find it by waiting or resisting.

You find it by:
- Experimenting at the edge of what you know
- Discovering what your edge actually is

## The Timeline

The people who figure this out in the next 12-36 months will be seen as a different species.

Exponential progress rewards those who lean into risk and figure it out along the way.

## Key Quotes

"No skill is going to save you. The ability to learn any skill fast, however, will."

"The gap is exponential. You can't wait a few years and catch up."

"The question isn't 'how do I do less?' It's 'what can I do now that I couldn't before?'"

"Skills abstract upward. The craft remains."

## Action Items

1. Identify which type you are (Resister, Waiter, Curious)
2. If not Curious, examine what's holding you back
3. Start experimenting with AI in your domain
4. Build something with your name on it
5. Write publicly about what you're learning
6. Ask: "What can I now do that was impossible before?"
