---
name: ai-usage
description: |
  Dan Koe's framework for using AI better than 99% of people. Prompt engineering for creators.

  TRIGGERS:
  - When user asks how to use AI effectively
  - When user gets mediocre AI outputs
  - When user wants AI to help with content creation
  - When user asks about AI for business or learning
  - When user treats AI like a slot machine (one-sentence prompts)
  - When user wants to build AI workflows

  CAPABILITIES:
  - Teach the Prompt Creator methodology
  - Guide context-gathering prompt design
  - Help build prompt libraries for recurring tasks
  - Show how to extract expert knowledge into AI instructions
  - Apply AI to content, learning, and business workflows
---

# How to Use AI Better Than 99% of People

From Dan Koe's article "How to use AI better than 99% of people"

## The Core Problem

Most people type one sentence and expect magic.

"Generate a viral YouTube script" → AI guesses based on the average of everything it's trained on → Output is, by definition, average.

**The reason AI isn't magical to you: You're making it guess.**

## The Core Solution

Think of AI as a digital employee that does exactly what you tell it.

If you don't know how to do something well, or can't guide AI to figure it out, the output won't be good.

**The key shift:** From one-sentence prompts to 500-2000 word prompts.

The shorter the prompt, the more guessing. The more guessing, the more slop.

## The Two-Step System

### Step 1: Create Detailed Instructions

You need expert-level instructions to feed AI. Four ways to get them:

**Option 1: Write it yourself (if you're expert)**
Write out your exact thought process. How do you generate ideas? Structure content? Make decisions? This becomes your instruction set.

**Option 2: Ask AI to create a guide (for well-known tasks)**
```
Give me a detailed guide on how to create the most comprehensive customer avatar in the world.
```

**Option 3: Feed expert source to AI (if you're not expert)**
Find a YouTube video, book, or article from an expert. Paste transcript/content into AI:
```
I want you to create a comprehensive guide on how to [task] using the transcript below. Be as detailed as possible. Act like you are teaching me, step by step, in a way that makes it impossible to fail.

[paste transcript]
```

**Option 4: Reverse-engineer examples (Dan's favorite)**
Find something excellent you want to emulate. Paste it into AI:
```
I love this [landing page/newsletter/script]. Break down the overall structure, what psychological tactics it uses, and why it works. Then, break down each line individually. Write this as if you are teaching me how to do it step by step.
```

Now you have detailed instructions.

### Step 2: Turn Instructions into a Context-Gathering Prompt

The Prompt Creator prompt (save this):
```
I want you to act as a professional prompt engineer. Help me create a detailed, effective prompt for an AI assistant. The prompt should be clear, specific, and designed to get high-quality outputs. Ask me clarifying questions about what I want to achieve, then craft a comprehensive prompt that includes context, instructions, format specifications, and any constraints.
```

Send this first. Then tell it:
```
I want to write a prompt that [does X] according to the guide below. Structure this prompt in 2 phases:

Phase 1) Context gathering
- Break down everything you need to know to [do X well]
- Interview me to gather all that information
- Ask one question at a time

Phase 2) Execution
- Use the context gathered to create the first draft
- Give suggestions on improvement and ask if I want changes

Here is the guide:
[paste your instructions from Step 1]
```

## Example Workflows

### The Intellectual Sparring Partner

Create a "worldview document" for thinkers you respect:
```
I want you to break down the entire worldview of [Naval Ravikant]. His core principles, how he thinks through problems, his main discoveries or insights, and all of the ideas that best illustrate his philosophy. This should be comprehensive, as if I'm diving into the entirety of his mind.
```

Do this for 5 people across domains (business, psychology, philosophy, etc.).

Then create a prompt that:
- Takes your question/problem
- Applies these worldviews to challenge and expand your thinking
- Acts as an intellectual sparring partner

### The Creative Thought Partner

Document your own thinking process:
- What questions do you ask when writing?
- What makes an idea compelling to you?
- How do you structure arguments?

Example thinking questions:
1. What's the big problem relating to this topic?
2. What's the consequential cascade if unsolved?
3. What ideal life do I want to inspire?
4. What novel concepts or personal experiences illuminate this?
5. What's an effective process to overcome the problem?
6. What quotes, studies, or anecdotes support this?

Turn this into a prompt that guides you through ideation without doing the thinking for you.

### The One-Person Business Stack

Build prompts for each function:

**Writing Content:**
- Prompt for personal brand strategy
- Prompt for content ideas (feed 10 high-performing pieces, extract patterns)
- Prompt for newsletters (break down 2-3 you like)

**Building Products:**
- Prompt for product structure and curriculum design
- Prompt that guides section-by-section creation

**Offer Creation:**
- Customer avatar prompt
- Offer blueprint prompt (based on Hormozi's methods)

**Copywriting:**
- Upload copywriting book → extract actionable guide
- Find landing page structure → break down why it works
- Combine into prompt that interviews you then writes copy

### The YouTube Workflow

Build a prompt for each step:

1. **Title Prompt**: Find 10-20 top titles in niche → break down patterns → generate options
2. **Key Points Prompt**: Guide for outlining compelling video structure
3. **Introduction Prompt**: Based on videos with great intros
4. **Script Prompt**: Gathers topic, points, intro → writes full script
5. **B-Roll Prompt**: Adds visual ideas for each section
6. **Description Prompt**: Keywords + chapters + links

## The Prompt Library Concept

Think of this as documenting your own processes with AI.

Build a library that stores your "skills" as prompts:
- Marketing processes
- Thinking processes
- Customer support processes
- Content creation processes

Benefits:
- Brings you to higher-level thinking
- Reduces cognitive load
- Makes processes tangible and refinable
- Creates leverage (prompt once, use forever)

## Key Principles

1. **AI has a skill curve.** Falling off the bike doesn't mean bikes don't work.

2. **Narrow the context.** The more specific your instructions, the less guessing.

3. **Two phases always:** Context gathering + Execution.

4. **Your job is direction.** AI handles labor. You handle vision, taste, refinement.

5. **Iterate the prompt.** First version won't be perfect. Refine based on outputs.

## The Meta-Insight

For utility tasks: Use AI all you want.

For meaning-based tasks: Be careful you're not using AI to avoid struggle and skill development.

The goal is to do things you couldn't do before, not just things you didn't want to do.

"What can I do now that I couldn't before?" > "How do I do less?"
