---
name: deep-focus
description: |
  Dan Koe's framework for achieving deep focus and flow states.

  TRIGGERS:
  - When user can't concentrate or focus
  - When user asks about deep work or productivity
  - When user struggles with distraction
  - When user wants to enter flow states
  - When user asks about motivation or discipline
  - When user feels scattered or unfocused

  CAPABILITIES:
  - Explain the psychology of focus (clarity, importance, urgency)
  - Guide through the intrinsic motivator stack
  - Apply the fill/empty/use brain cycle
  - Diagnose why focus isn't working
  - Design personalized deep work protocols
---

# How to Become So Focused It Feels Illegal

From Dan Koe's article "How to become so focused it feels illegal"

## The Focus Equation

**Focus = Clarity + Importance + Urgency**

All three must be present:

### Clarity
Know exactly what you're working on.
- Vague goals = scattered attention
- Specific tasks = concentrated energy

Bad: "Work on my business"
Good: "Write 500 words for newsletter introduction"

### Importance
The task must matter to your goals.
- If it doesn't connect to your vision, your brain won't prioritize it
- Importance creates willingness to push through difficulty

Ask: "Does completing this move me toward my ideal future?"

### Urgency
Real deadline or consequence.
- Without urgency, importance fades
- Artificial deadlines rarely work
- Best urgency: real stakes (publish date, client deadline, accountability)

## The Intrinsic Motivator Stack

Sustainable focus comes from internal drivers, stacked in order:

**Curiosity** → (leads to)
**Passion** → (leads to)
**Purpose** → (leads to)
**Autonomy** → (leads to)
**Mastery**

### Curiosity
The starting point. You have to be interested.
- Follow what genuinely intrigues you
- Don't force interest in things you "should" care about

### Passion
Sustained curiosity. When curiosity compounds into genuine enthusiasm.
- Comes from repeated engagement
- Can't be manufactured, must be discovered

### Purpose
Curiosity + passion directed toward meaningful outcome.
- Connects your work to something larger
- Answers "why does this matter?"

### Autonomy
Control over how, when, and what you work on.
- Focus dies when you feel controlled
- Create conditions where you choose the work

### Mastery
The drive to get better.
- Progress is inherently motivating
- Visible improvement feeds more focus

**The stack builds:** You can't have mastery without autonomy. Can't have autonomy without purpose. And so on.

## The Fill / Empty / Use Cycle

Your brain has three modes:

### Fill Brain (Learning)
- Consuming information
- Reading, watching, listening
- Taking in new ideas

### Empty Brain (Rest)
- Not actively thinking
- Walking, showering, sleeping
- Letting ideas percolate

### Use Brain (Creation)
- Producing output
- Writing, building, creating
- Applying what you've learned

**The mistake:** Filling constantly without emptying or using.

Information without creation = mental clutter.

**The cycle:**
1. Fill: Learn something specific
2. Empty: Walk, rest, let it settle
3. Use: Create something with it
4. Repeat

## Productivity vs Creativity Blocks

**Productivity block:** You know what to do, can't start.
- Usually: Fear of imperfection or overwhelm
- Solution: Make the first step tiny. "Just open the document."

**Creativity block:** You don't know what to do.
- Usually: Not enough input or ideas
- Solution: Fill brain more. Read, expose yourself to new ideas.

## The Focus Environment

Focus is easier when:

**Physical:**
- Phone in another room
- Clean workspace
- Right temperature
- Proper lighting

**Digital:**
- Notifications off
- Distracting apps blocked
- Single task visible (close other tabs)

**Mental:**
- Clear on the ONE thing you're doing
- Time block protected
- Consequences for not completing clear

## The Focus Stack (Dan's System)

**Morning (highest energy):**
- Most creative or demanding work
- No inputs until deep work done
- 2-4 hour focus block

**Afternoon (medium energy):**
- Administrative tasks
- Communications
- Learning and research

**Evening (lowest energy):**
- Light tasks or rest
- Planning tomorrow
- Wind down

## Getting Into Flow

Flow state requirements:
1. **Clear goals:** Know exactly what success looks like
2. **Immediate feedback:** Can you tell if you're doing well?
3. **Challenge-skill balance:** Hard enough to engage, not so hard you give up

**Flow killers:**
- Interruptions (even checking phone briefly)
- Unclear next step
- Task too easy (bored) or too hard (anxious)
- Physical discomfort (hunger, fatigue)

## Diagnosing Focus Problems

**"I can't get started"**
→ Clarity problem. Get more specific about EXACTLY what to do first.

**"I lose focus after 10 minutes"**
→ Importance problem. Reconnect to why this matters, or do different work.

**"I work but nothing gets done"**
→ Urgency problem. Create real stakes or deadlines.

**"I feel foggy and can't think"**
→ Physical problem. Sleep, exercise, food, or need to empty brain.

**"I'm not motivated"**
→ Intrinsic stack problem. Working on wrong thing. Follow curiosity.

## The Daily Focus Protocol

1. **Morning:** No phone first hour. Fill brain briefly (read), then use brain (create).

2. **Before work:** Write down THE ONE THING that matters today.

3. **Deep work block:** 2-4 hours, no interruptions, phone away.

4. **Post-deep work:** Take a walk (empty brain). Ideas will come.

5. **Afternoon:** Administrative, communications, learning.

6. **End of day:** Review what got done. Plan tomorrow's ONE THING.

## Key Quotes

"Focus = Clarity + Importance + Urgency"

"Information without creation is mental clutter."

"You can't force interest in things you 'should' care about."

"Progress is inherently motivating."

## Common Objections

**"I have to multitask for my job"**
→ Batch similar tasks. Protect even 1-2 hours of focus time.

**"I don't have time for long focus blocks"**
→ Start with 25 minutes. Anything is better than constant switching.

**"I don't know what to focus on"**
→ That's a clarity problem, not a focus problem. Solve that first.

**"I've tried everything"**
→ Have you solved the physical basics? Sleep, exercise, nutrition affect focus more than any technique.
