---
name: dead-internet
description: |
  Dan Koe's framework for standing out in the AI-saturated internet. Signal vs slop, taste, and value creation.

  TRIGGERS:
  - When user asks how to stand out online
  - When user worries content is too saturated
  - When user asks about AI-generated content competition
  - When user wants to understand what "value" means now
  - When user asks about growing on social media
  - When user feels their content is generic

  CAPABILITIES:
  - Explain the slop-to-signal spectrum
  - Guide development of taste and personal voice
  - Provide network growth strategies beyond algorithm
  - Help transition from content creator to content director
  - Build an "idea museum" for unique perspectives
---

# How to Stand Out in the Dead Internet

From Dan Koe's article "How to stand out in the dead internet"

## The Core Insight

"Value-based content is dead" is wrong.

What's actually dead: Basic educational content. The "5 tips to grow on social media" posts. Surface-level how-to threads anyone (or AI) can write.

What's NOT dead: Value. Content that changes behavior. Content you save and return to. Content you send to friends.

Value has abstracted up a layer into:
- Personal narrative
- Original thought
- Taste

## The Psychology of Value

**Value is not objective. Value is perception.**

Perception is shaped by goals. Two people read the same book and extract different insights based on what they're trying to achieve.

This means:
- You can't create "objectively valuable" content
- You can only create content valuable to someone with a specific goal
- Those someones are randomly scrolling - it takes 6-12 months for traction

**The broader the goal your content helps achieve, the more it spreads.**
**The more specific the goal, the more niche (but potentially higher-ticket) your audience.**

## Content Creator → Content Director

The labor vs direction distinction:
- James Patterson uses ghostwriters. Readers don't care - they want the story.
- Spielberg doesn't operate the camera. The film is still his.
- Value lies in vision, direction, and taste - not the typing.

AI accelerates this shift. The people who resist are those who made labor their identity.

Your reader only sees the output. If it's original, opinionated, and shaped by taste - they don't care how it was made.

## The Slop-to-Signal Spectrum

There was slop before AI. Generic threads, recycled tips, "value-based content" that said nothing original. That was human slop.

The variable that separates slop from signal: **TASTE**

Taste requires:
- Discernment
- Willingness to say "this is better than that"
- Exposure, repetition, comparison
- The ability to exclude and curate

**The Spectrum:**
- **Slop end**: Zero personal context. "Write a thread about productivity." AI guesses everything.
- **Signal end**: Your experiences, opinions, taste applied at every decision point.

The more personal context you provide, the further from slop.

## How to Develop Taste

Build an **Idea Museum**:

If you have existing content:
- Go through it, pull best lines
- Identify ideas that resonated
- Extract frameworks that landed
- This becomes your context library

If you're starting out:
- Save posts that stop you mid-scroll
- Collect ideas that make you think "I wish I wrote that"
- Build a museum of others' best work
- Over time, patterns emerge and your own ideas surface

**The people afraid of AI never developed taste. They were producing human slop and now compete with machines that produce slop faster.**

## Mission-Based vs Topic-Based

**Topic-based** (traditional):
- Pick a niche
- Become the "go-to" person
- Works but boxes you in
- Easy to replicate
- Anti-continuous learning

**Mission-based** (Dan's approach):
- Lead people toward a transformation
- Anything that moves toward that transformation is fair game
- Example: "Helping people become future-proof" allows philosophy, business, psychology, routines
- Ideas flood in because you have a filter

Mission-based is taste applied to content strategy.

## Signal: What AI Can't Manufacture

Your brain notices important ideas. When something clicks, you feel dopamine. You want to share it, save it, return to it.

That's signal. Your brain hinting at what's valuable to YOU.

AI can't manufacture this because AI doesn't:
- Get excited from a lifetime of experiences
- Have a mission that frames what to notice
- Have taste developed through exposure and curation

You have:
- A specific path you're walking
- A specific future you're building
- Specific problems you've solved

That determines what registers as signal to you.

## Network Growth Strategy

**You cannot rely on the algorithm alone.**

Everyone is playing the slot machine, praying for viral. The spikes are a bonus, not the strategy. Act like they'll never happen.

**Build tribes:**
- Humans are wired for 150 stable relationships (Dunbar's number)
- Every creator you follow is in group chats with other creators
- They share each other's posts, engage, support growth
- Tribes grow faster than individuals

**How to build your tribe:**
1. Comment on posts from people you genuinely enjoy (not as growth hack - as relationship seeding)
2. DM like you're texting a friend, not LinkedIn pitching
3. Talk about something specific they wrote
4. Share articles you think they'd like

**Leverage authority:**
- Quote other people's content with your own insights
- Write about bigger names' ideas (Naval, Huberman)
- Tag them - even if they don't repost, others recognize the name
- You're borrowing credibility while adding perspective

## The Ultimate Strategy

**Create the content you want to see in the world.**

Why it works:
- You are the niche
- People like you will benefit from what you've achieved
- People at similar levels want to join your mission
- Create for your past, present, and future self

## Key Quotes

"Value doesn't die. Basic educational content died."

"Taste is slowly cultivated through exposure, repetition, comparison, and the willingness to say This is better than That."

"Create the content you want to see in the world."

"The internet doesn't have to devolve into a sea of slop. People are hungry for signal."
