---
name: dopamine-detox
description: |
  Dan Koe's 30-day dopamine detox protocol for resetting your life.

  TRIGGERS:
  - When user feels stuck or life has become a blur
  - When user can't focus or feels scattered
  - When user is addicted to phone/social media/gaming
  - When user wants to reset their habits
  - When user feels like they're wasting time
  - When user lacks motivation or drive

  CAPABILITIES:
  - Guide through the 30-day reset protocol
  - Explain the psychology of dopamine and motivation
  - Help identify cheap dopamine sources to eliminate
  - Connect boredom to creativity and novelty
  - Design a personalized detox plan
---

# A Dopamine Detox to Reset Your Life in 30 Days

From Dan Koe's article "A dopamine detox to reset your life in 30 days"

## The Problem

Modern life has become a blur.

You scroll without remembering what you saw. Days blend together. You feel tired but can't sleep. You have goals but no energy to pursue them.

Your dopamine system is hijacked by cheap stimulation:
- Social media
- Gaming
- Porn
- Junk food
- Endless entertainment

**Dopamine isn't pleasure - it's anticipation.** It drives you toward rewards. When flooded with cheap dopamine, your brain loses interest in harder rewards (meaningful work, deep relationships, creative projects).

## The Psychology

**Boredom is the gateway to novelty.**

When you eliminate cheap dopamine, boredom forces your brain to seek reward elsewhere. That's when:
- Creative ideas emerge
- Motivation for hard things returns
- Your natural curiosity reignites

**Flow states require the right challenge-to-skill ratio.**

You can't enter flow if you're:
- Constantly interrupted by notifications
- Seeking instant gratification
- Unable to tolerate discomfort

The detox resets your baseline so challenging work becomes rewarding again.

## The 30-Day Protocol

### Phase 1: Elimination (Days 1-7)

**Remove cheap dopamine sources:**
- Social media (delete apps, use website blockers)
- Gaming
- Porn
- Junk food and sugar
- Alcohol
- News and mindless content
- Excessive Netflix/YouTube

**Keep essentials:**
- Work communications (if necessary)
- Messages with close friends/family
- Learning content (used intentionally, not for escape)

**Expect:** Extreme boredom, irritability, cravings. This is withdrawal. It passes.

### Phase 2: Replacement (Days 8-21)

**Replace with high-effort, high-reward activities:**

**Body:**
- Morning walk (without headphones sometimes)
- Gym or physical training
- Cold showers (optional but effective)
- Clean eating

**Mind:**
- Reading physical books
- Journaling
- Learning a new skill
- Deep work sessions

**Spirit:**
- Meditation or contemplation
- Time in nature
- Reflection on values and direction

**Social:**
- In-person conversations
- Deep connections over small talk

### Phase 3: Integration (Days 22-30)

**Selectively reintroduce:**

Ask for each thing: Does this add to my life or take from it?

Keep:
- Social media for intentional creation and connection
- Entertainment in controlled doses
- Foods you enjoy in moderation

Remove permanently:
- Things that triggered compulsive behavior
- Apps/sites you binged
- Habits that took more than they gave

## The Daily Structure

**Morning:**
- Wake without phone for first hour
- Walk or movement
- Journaling or contemplation
- Deep work block on meaningful project

**Afternoon:**
- Physical training
- Learning or skill development
- Necessary communications

**Evening:**
- Reflection on the day
- Reading
- Early wind-down (no screens 1-2 hours before bed)
- Quality sleep

## The Project Requirement

**You must have a project.**

The detox creates a vacuum. Without something to channel energy toward, you'll relapse.

Your project should be:
- Meaningful to you personally
- Challenging enough to engage you
- Something you can work on daily
- Ideally building toward your larger vision

Examples:
- Writing a book or blog
- Building a business
- Creating an art project
- Learning a complex skill
- Physical transformation goal

## What to Expect

**Week 1:** Hard. Cravings, boredom, mood swings. Your brain is recalibrating.

**Week 2:** Easier. Boredom decreases. Start noticing more. Ideas come.

**Week 3:** Flow states possible. Deep work feels rewarding. Natural energy returns.

**Week 4:** New baseline. Cheap dopamine feels less appealing. You see how it was draining you.

## Key Principles

1. **Cold turkey > tapering.** Partial elimination doesn't reset the baseline.

2. **Boredom is productive.** Don't fill every moment. Let your brain get bored.

3. **Environment > willpower.** Remove temptations physically. Don't rely on discipline.

4. **Replace, don't just remove.** Empty space gets filled with old habits unless you deliberately fill it.

5. **Have a why.** Connect this to your larger life vision. What are you detoxing FOR?

## Signs It's Working

- Ideas come during walks and showers
- You look forward to working on your project
- Time feels slower (in a good way)
- Sleep improves
- Genuine contentment in simple moments
- Less anxiety, more presence
- Motivation comes naturally

## After the 30 Days

This isn't about permanent monk mode. It's about resetting your baseline.

After 30 days:
- You know what cheap dopamine was costing you
- You have new habits that serve you
- You can reintroduce things consciously
- You have reference point for how good you can feel

**Maintenance protocol:**
- Regular "detox days" (weekly phone-free day)
- Morning routine without cheap dopamine
- Protect deep work blocks
- Periodic multi-day resets if you notice old patterns

## Key Quotes

"Boredom is the gateway to novelty."

"Flow states require the right challenge-to-skill ratio."

"Your dopamine system is hijacked by cheap stimulation."

## Quick-Start Checklist

- [ ] Delete social media apps from phone
- [ ] Install website blockers on computer
- [ ] Clear junk food from home
- [ ] Set up morning routine without phone
- [ ] Choose your project to focus on
- [ ] Tell one person about your commitment
- [ ] Plan your replacement activities
- [ ] Set 30-day calendar reminder for completion
