# HUMAN 3.0

Dan Koe's comprehensive framework for becoming "multidimensionally jacked" - maximizing your potential across all life domains, not just one.

## Overview

HUMAN 3.0 synthesizes patterns from Spiral Dynamics, Ken Wilber's AQAL model, ego development theory, flow psychology, and ancient philosophy into one navigable map for modern life.

Most frameworks focus on a single domain (fitness, business, spirituality). HUMAN 3.0 addresses the critical flaw of partial development by integrating Mind, Body, Spirit, and Vocation.

## When to Use

This skill activates when user:
- Feels stuck or plateaued despite effort
- Is successful in one area but failing in others
- Asks about personal development or self-actualization
- Wants a comprehensive life framework
- Struggles to balance career, health, relationships, and meaning
- Feels "off" despite external success

## Core Frameworks

### The Four Quadrants
| Quadrant | Question |
|----------|----------|
| Mind | "How do I make sense of reality?" |
| Body | "How do I embody my potential?" |
| Spirit | "How do I connect and create meaning?" |
| Vocation | "How do I create value and impact?" |

### The Three Levels
- **1.0 Conformist** - External authority, binary thinking
- **2.0 Individualist** - Internal authority, achievement-driven
- **3.0 Synthesist** - Contextual wisdom, creator economy

### The Phase System
- **Dissonance** - Old patterns stop working
- **Uncertainty** - Identity dissolving/reforming
- **Discovery** - New patterns crystallizing

### Lifestyle Archetypes
- Workaholic (Vocation overdeveloped)
- Seeker (Spirit overdeveloped)
- Optimizer (Mind overdeveloped)
- Athlete (Body overdeveloped)
- Drifter (All underdeveloped)

## Key Concepts

**Channels**: Obsessive learning/building pursuits where time disappears - the gateway to rapid development

**Anti-Vision**: Clarifying what you refuse to become before assessing where you are

**False Transformation**: Imitating higher development without genuine growth

**Cascade Dynamics**: How quadrants affect each other positively or negatively

## The 90-Day Protocol

1. Choose single quadrant (usually weakest)
2. Commit 90 days minimum
3. Build foundational practices
4. Establish feedback loops
5. Expand to other quadrants

## Source Articles

- [HUMAN 3.0 - A Map To Reach The Top 1%](https://letters.thedankoe.com/p/human-30-a-map-to-reach-the-top-1)
- [A Complete Knowledge Base Of HUMAN 3.0](https://letters.thedankoe.com/p/a-complete-knowledge-base-of-human)
- [Prompt: HUMAN 3.0 Self-Discovery & Metatype Test](https://letters.thedankoe.com/p/prompt-human-30-self-discovery-and)

## Credits

Based on the writing and thinking of [Dan Koe](https://thedankoe.com).
