---
name: x-articles
description: |
  Framework for writing high-performing Articles on X (Twitter long-form). Based on official X Creators guide.

  TRIGGERS:
  - When user wants to write an X Article
  - When user says "write an article" or "long-form post"
  - When user wants to publish on X beyond 280 characters
  - When user mentions "X article", "Twitter article", or "long-form content"

  CAPABILITIES:
  - Structure articles for maximum engagement
  - Craft compelling titles and hooks
  - Format for mobile skimmability
  - Develop authentic voice
  - Growth and promotion strategies
  - Monetization with subscriber-only articles
---

# X Articles Framework

Guide for writing impactful long-form Articles on X that grow audience and can be monetized.

## Writing a Great Article

### 1. Start with a Clear Purpose

Before writing a single sentence, answer:
- What do I want the reader to **think**, **feel**, or **do** after reading?
- Who is this actually for?

A strong purpose keeps you focused and helps words flow.

### 2. Nail the Title (and Hook)

Great titles are specific, spark curiosity, and promise value. Pair with a strong first sentence to hook the reader.

| Bad | Good |
|-----|------|
| "Tips for Better Productivity in 2026" | "Why 95% of Productivity Advice Fails" |

**Header image matters** - make it visually appealing and relevant to the topic.

### 3. Structure for Skimmability

People skim before they read, especially on mobile. Make it impossible to miss the value:

- Short paragraphs (2-4 lines max)
- Subheadings every 3-5 paragraphs
- Bullets and numbered lists > walls of text
- **Bold** the key insight in almost every section
- One idea per paragraph

### 4. Develop a Natural, Recognizable Voice

Consistency in tone helps readers feel like they know you. The moment writing becomes too "professional" it becomes boring.

Write like you're talking to a good friend, not a lecture hall. Use "you," "your," and conversational language.

| Bad | Good |
|-----|------|
| "Successful people always prioritize their tasks." | "You need to stop doing everything - focus on the 3 things that actually move the needle." |

### 5. Show, Don't Just Tell

Facts and data are great, but stories and examples make them stick. For any claim, follow it immediately with evidence:
- Stats
- Personal story
- Before/after
- Embedded X posts as living examples

### 6. Edit Ruthlessly

The first draft is for you. The second (and third) draft is for the reader.

After writing:
- Cut 20-30% of the word count
- Remove filler phrases like "very," "really," or "in order to"
- Read the whole thing out loud - awkward sentences will jump out

### 7. Add Visuals and Formatting

Images, screenshots, charts, or embedded X posts help break up text and make articles more shareable. Well-formatted articles with bold headers, spacing, and images get way more engagement.

### 8. End with a Strong Close

Don't just fade out - close with energy and give the reader a takeaway or call to action:
- Summarize the key points
- Ask a question to spark replies
- Encourage them to share or try one tip right now

---

## Growing Your Audience

### Tease Before You Publish
Post a short teaser or question a few hours before publishing to build anticipation.

### Pin New Articles to Your Profile
Especially during the first 24-72 hours to maximize discovery.

### Break Articles into Post Threads
Share key excerpts as posts that link back to the full piece.

### Reply to Early Readers
Engaging in the first wave of replies boosts visibility and signals momentum.

### Reshare Older Articles When Relevant
Evergreen content can perform multiple times if reintroduced during relevant news cycles.

---

## Monetizing with Subscriptions

Subscriber-only Articles let you earn recurring income from loyal followers.

### Clearly Communicate Subscriber Value
Tell readers what they get: deep dives, early access, exclusive opinions, behind-the-scenes, or regular series.

### Use Soft Paywalls Strategically
Offer some free Articles to attract new readers, reserve premium depth for paying subscribers.

### Create Subscriber-Only Formats
Examples: weekly memo, industry brief, portfolio updates, Q&A, or private breakdowns.

### Thank Subscribers Publicly
Occasional callouts build social proof and encourage others to join.

### Preview What's Coming Next
End Articles with a short "Next week:" to reinforce habit and retention.

---

## How to Post Subscriber-Only Articles

1. Click "Publish" after writing
2. Select "Subscribers" under "Choose your audience"
3. Click Publish again

Promote subscriber articles by posting a teaser and linking to your subscription paywall:
`https://x.com/YOURUSERNAME/creator-subscriptions/subscribe`

---

## Workflow

1. **Define purpose** - What should reader think/feel/do?
2. **Draft title + hook** - Specific, curious, value-promising
3. **Outline structure** - Subheadings every 3-5 paragraphs
4. **Write conversationally** - Friend, not lecture hall
5. **Add evidence** - Stats, stories, examples for every claim
6. **Edit ruthlessly** - Cut 20-30%, remove filler
7. **Add visuals** - Images, screenshots, embedded posts
8. **Strong close** - Takeaway or CTA
9. **Promote** - Teaser, pin, thread excerpts, engage replies
