---
name: daily-report-generator
description: |
  GitコミットログとCalendar情報から日報・週報を自動生成するSkill。
  「日報を作って」「週報を書いて」「今週何やったか教えて」「スタンドアップノート」
  などのリクエストで自動発火する。
---

# 日報/週報生成 Skill

Gitコミットログから日報・週報を自動生成します。

## クイックスタート

1. 対象期間を確認（日次 or 週次）
2. Gitコミットログを取得
3. コミットをカテゴリ分類
4. 指定フォーマットで出力

## データ収集

### Gitコミット取得

```bash
# 日次（今日のコミット）
git log --oneline --since="midnight" --author="$(git config user.name)"

# 週次（過去7日間）
git log --oneline --since="7 days ago" --author="$(git config user.name)"

# 詳細表示
git log --pretty=format:"%h %s" --since="midnight"
```

### Calendarイベント（オプション）

ユーザーが提供した場合のみ、Calendar情報を組み込む。

## コミット分類

コミットメッセージのプレフィックスで自動分類：

| カテゴリ | キーワード | 例 |
|---------|-----------|-----|
| **機能追加** | feat, add, implement | 新機能の実装 |
| **バグ修正** | fix, resolve, patch | 不具合の修正 |
| **改善** | refactor, improve, update | コード改善 |
| **ドキュメント** | doc, readme | ドキュメント更新 |
| **その他** | chore, style, test | その他の作業 |

## 出力フォーマット

### 1. デイリースタンドアップ形式

```markdown
## 日報 - [日付]

### 昨日やったこと
- [完了したタスクの箇条書き]

### 今日やること
- [予定タスク]

### 困っていること
- [ブロッカーがあれば記載、なければ「特になし」]
```

### 2. 週次サマリー形式

```markdown
## 週次レポート - [期間]

### 主な成果
- [重要な完了項目]

### 進行中
- [継続タスク]

### 来週の予定
- [次週の優先事項]

### 数値サマリー
- コミット数: [N]
- 機能追加: [N]
- バグ修正: [N]
```

### 3. Slack投稿用形式

```
*日報 - [日付]*
:white_check_mark: 完了: [要約]
:construction: 作業中: [要約]
:warning: ブロッカー: [あれば記載]
```

## ワークフロー

1. ユーザーに確認: 「日次と週次どちらですか？フォーマットの希望はありますか？」
2. Gitコマンドを実行してコミット取得
3. コミットを解析・分類
4. テンプレートを適用
5. フォーマット済みレポートを出力
6. 必要に応じてクリップボードにコピー

## 使用例

### 例1: シンプルな日報
```
ユーザー: 「今日の日報を作って」
アクション: git log実行 → 分類 → デイリースタンドアップ形式で出力
```

### 例2: Slack用週報
```
ユーザー: 「今週の作業をSlack用にまとめて」
アクション: 7日間のgit log → サマリー作成 → Slack形式で出力
```

### 例3: 詳細レポート
```
ユーザー: 「今週何をやったか詳しく教えて」
アクション: 週次log → 各コミットの説明付きで出力
```

## 成功基準

- すべてのコミットが適切にカテゴリ分類されている
- 出力が選択されたフォーマットに従っている
- 曖昧な表現がない
- コピペでそのまま使える状態

## 制限事項

- Gitリポジトリ内でのみ動作
- `git config user.name` が設定されている必要あり
- リモートリポジトリへのアクセスは不要（ローカルログのみ）
