# Podcast Script Template (Extended Format)

## Guidelines

**Target Length**: 1500-2000 words (~10-15 minutes spoken)

**Tone**: Casual professional, first person, warm but substantive. Like a trusted colleague giving you a thorough briefing over coffee.

**Key Principles**:
- Use team members' first names
- Include specific details, not generalizations
- Provide context and analysis on news items
- Smooth transitions between sections

## Structure

| Section | Words | Time |
|---------|-------|------|
| Opening | ~100 | 45 sec |
| Calendar & Schedule | ~150 | 1 min |
| Tasks & Priorities | ~150 | 1 min |
| Tickets & Service Desk | ~150 | 1 min |
| Team Activity (DETAILED) | ~400 | 3 min |
| EdTech News | ~200 | 1.5 min |
| AI News | ~200 | 1.5 min |
| K-12 Leadership News | ~150 | 1 min |
| Closing | ~100 | 45 sec |
| **Total** | **~1600** | **~12 min** |

## Template

```
Good morning. It's [WEEKDAY], [MONTH DAY spelled out].

[WEATHER] - [Conditions] today with a high of [X]. [Any notable weather coming].

Here's your comprehensive briefing for the day.

---

CALENDAR AND SCHEDULE

[You've got X events on the calendar today / Today's calendar is [light/moderate/packed]].

[For each significant event]:
- [Time]: [Event name]. [Brief context - who's there, what it's about, any prep needed].

[Note any conflicts, back-to-back situations, or key transitions needed].

---

TASKS AND PRIORITIES

Let's talk about what needs your attention.

[If overdue - be specific]:
You've got [X] overdue items. The most pressing: [Item 1 name] is now [X] days overdue - [brief context on why it matters]. Also overdue: [Item 2], [Item 3 if notable].

[Due today]:
For today specifically, [X] tasks are due. [Describe briefly or note "nothing due today" if applicable].

[Flagged]:
You've flagged [X] items for focus. [Mention any that deserve attention].

---

TICKETS AND SERVICE DESK

On Freshservice, here's where things stand.

Technology workspace: [X] open tickets. [Note any high priority or assigned to you].

Software Development workspace: [X] open tickets. [Brief note on top issues if relevant].

Pending approvals: [X] waiting for your sign-off. [List briefly if important].

---

TEAM ACTIVITY FROM [DAY]

Let's go through what the team accomplished on [last business day].

[For each team member with a detailed EOD - use first names]:

[Name] was at [location(s)]. [He/She] [accomplished X, Y, Z - be specific about tasks].
[Include any notable projects, interesting problems solved, or issues mentioned].

[Continue for 4-6 team members]

Overall, the team closed [X] tickets on [day]. The biggest categories were [Category 1] at [X] tickets and [Category 2] at [X] tickets. [Any trend observations].

---

EDTECH NEWS

A few stories worth knowing about in education technology.

First, [Article title/topic]. [2-3 sentences: what happened, why it matters for K-12, key takeaway].

Second, [Article title/topic]. [2-3 sentences synopsis].

[Third if notable]: Also worth noting, [Article topic]. [1-2 sentence synopsis].

---

AI NEWS

In the broader AI world, here's what's happening.

[Article 1 topic]. [2-3 sentences: what's the development, industry impact, how it connects to your work].

[Article 2 topic]. [2-3 sentences synopsis].

[Article 3 if notable]: [1-2 sentence mention].

---

K-12 LEADERSHIP NEWS

On the leadership and policy front:

[Article 1 topic]. [2-3 sentences: what's the policy or leadership development, impact on districts, relevance to tech leadership role].

[Article 2 if notable]: [1-2 sentence mention].

---

CLOSING

So to wrap up, your top priorities today:

First, [Priority 1 - most important meeting/task].
Second, [Priority 2].
Third, [Priority 3].

That's your briefing for [WEEKDAY], [MONTH DAY]. Have a productive day.
```

## Example (Abbreviated)

```
Good morning. It's Monday, January twenty-sixth.

Expect partly sunny skies today with a high of forty-seven. Rain's coming Tuesday night, so enjoy the dry weather while it lasts.

Here's your comprehensive briefing for the day.

CALENDAR AND SCHEDULE

You've got six events on the calendar today, including two significant ones.

At seven AM, you've got the dentist - that's a one hour appointment.

At noon, the RTM AI Panel prep call with Priya, Rachel, Marc, and Cody. Make sure you've reviewed that prep doc before the call.

Then it gets busy in the evening. At four, you've got the levy info sharing at KPMS, followed immediately by the community presentation at Evergreen Elementary at six. Back-to-back levy events, so pace yourself.

TASKS AND PRIORITIES

Let's talk about what needs your attention.

You've got eighteen overdue items. The most pressing: The ACPE session proposal is now eleven days overdue - that deadline has passed and needs immediate action. The EdTech Advocacy Day travel approval is six days overdue along with several others including the Ashley meeting about Scholarship Granting Organizations.

Nothing specifically due today, but that overdue pile needs attention.

TICKETS AND SERVICE DESK

On Freshservice, Technology workspace has three open tickets including two digital resource approvals assigned to you - Math Playground and Paw Patrol.

Software Development workspace has ten open tickets, mostly bug reports from AI Studio users.

One pending approval waiting for your sign-off.

TEAM ACTIVITY FROM FRIDAY

Let's go through what the team accomplished on Friday.

Brad was at Tech Services. He spent the day packaging Cinema 4D plugins for deployment, fixed an OAuth blocking issue for the Maxon App, and - this is interesting - used Claude Code for the first time to create an Installomator label for Godot, an open-source game engine requested for a Mac Lab at GHH. He also worked on Unity deployment troubleshooting and left early to burn some comp time.

Jodi was at DCRC. She helped an employee set up a new MacBook, supervised interns, processed invoices, and spent time helping Teresa fix a mistake in Destiny - apparently there were a lot of steps involved but she figured it all out.

David was at DCRC and then TSD. He built a new Securly block for a student, replaced a printer in ESS, and noted a trend - once people update to the newest OS, Screen Share stops working with Prometheans until the app is updated via Self Service.

[Continue for other team members...]

Overall, the team closed one hundred twenty-seven tickets on Friday. The biggest categories were Chromebook repairs at thirty-four tickets and password resets at eleven.

EDTECH NEWS

A few stories worth knowing about in education technology.

First, states are putting unprecedented attention on AI's role in schools. Several states are now requiring districts to develop AI policies, with Ohio mandating adoption by July first this year. This is moving from optional guidance to compliance requirements.

Second, EdSurge is tracking K-12 education trends for twenty twenty-six, with AI integration and digital equity remaining top priorities for technology leaders.

[Continue with AI News and Leadership News...]

CLOSING

So to wrap up, your top priorities today:

First, nail that RTM panel prep call at noon - review the prep doc beforehand.
Second, bring your A-game for the back-to-back levy presentations this evening.
Third, tackle that overdue ACPE session proposal when you get a chance.

That's your briefing for Monday, January twenty-sixth. Have a productive day.
```

## Voice Notes for ElevenLabs

- Use "Rachel" voice (calm, clear, professional)
- Numbers: Spell out one through ten, use words for larger numbers in speech context
- Dates: "January twenty-sixth" not "January 26"
- Contractions are fine: "you've got", "it's", "don't"
- Use first names for team members
- Pause indicators: Use "---" between major sections (will create natural pauses)
- Avoid: Ticket numbers, technical jargon without context, acronyms on first use
