# Presentation Masters - Best Practices

Codified wisdom from the world's best presenters and presentation designers.

## Core Universal Principles

### 1. Simplicity Above All

**Garr Reynolds (Presentation Zen)**
> "Restraint in preparation, simplicity in design, naturalness in delivery"

**Seth Godin**
- Maximum 6 words per slide
- No bullet points
- No transitions/animations

**TED Guidelines**
- Eliminate headlines and bullet points
- Image-rich, minimal text
- Rather than one complex slide, show several slides with each containing one idea

**Steve Jobs**
- Sometimes just 19 total words in entire presentations
- Single image or thought per slide

**Universal Rule**: Less is always more. Every element must earn its place.

---

### 2. Visual Over Textual

**Garr Reynolds**
> "Narration with pictures is better than narration alone"

**Richard Mayer (Multimedia Principle)**
> "People learn better from words and pictures than from words alone"

**Universal Rule**: Show, don't write. Slides support speech, they don't replace it.

**Application**:
- Use full-bleed images
- Minimal text overlays
- Let visuals carry 80% of the message

---

### 3. Audience as Hero

**Nancy Duarte**
> "The audience is the hero, the speaker is the mentor"

**Application**:
- Focus on transformation, not information
- What will the audience be able to do after?
- Their journey, not your expertise

**Universal Rule**: The presentation is about the audience's journey, not your content.

---

### 4. Story Structure Matters

**Nancy Duarte's Sparkline**
- Alternate "what is" (current reality) with "what could be" (aspiration)
- Build tension through contrast
- End with transformation

**Steve Jobs' Rule of Three**
- Every presentation in three parts
- Three key features per product
- More dramatic than two, easier to remember than six

**TED Structure**
- Hook (first 30 seconds)
- Personal connection
- Core idea with evidence
- Call to action
- Strong close (never end with Q&A)

**Universal Rule**: Structure creates meaning. Random facts don't stick; stories do.

---

### 5. One Idea Per Slide

**TED**
> "Rather than one complex slide, show several slides with each containing one idea"

**Guy Kawasaki**
- 10 slides maximum for hour presentation
- One concept per slide

**Seth Godin**
- 6 words maximum = one focused thought

**Universal Rule**: Cognitive load is real. One slide, one concept, one moment.

---

### 6. Rehearsal Is Non-Negotiable

**Steve Jobs**
- Rehearsed weeks in advance
- Every gesture choreographed
- Nothing left to chance

**TED**
> "Rehearse, rehearse, rehearse"

**Universal Rule**: Natural delivery requires unnatural preparation.

---

## Design Principles

### Typography

**Font Size Minimums**:
- **TED**: 42 points minimum
- **Guy Kawasaki**: 30 points minimum (the "30" in 10/20/30 rule)
- **Our Standard**: 30pt minimum, 36pt+ preferred

**Font Choice**:
- **TED**: Sans serif (Helvetica, Verdana) over serif for readability
- **2025 Trends**: Bold serifs and character-filled sans-serifs as design elements
- Limit to 1-2 font families maximum

**Text Limits**:
- **Seth Godin**: 6 words maximum per slide
- **TED**: 1-2 lines ideal, 6 lines absolute maximum
- No paragraphs, ever

---

### Color & Contrast

**High Contrast Essential**:
- Minimum 4.5:1 ratio (WCAG AA standard)
- Aim for 7:1+ ratio (WCAG AAA standard)
- Test in bright room conditions

**Steve Jobs Approach**:
- Large white fonts on dark gradient backgrounds
- Simple, bold color palette

**Consistency**:
- Use same color palette throughout
- Colors should reinforce brand and message

---

### Layout & Spacing

**Visual Hierarchy** (Garr Reynolds):
- Make most important information the focal point
- Use size, color, position to guide eye

**Reading Patterns**:
- Z-pattern for Western audiences (top-left → top-right → bottom-left → bottom-right)
- F-pattern for text-heavy slides (avoid these!)

**Whitespace** (Essential):
- Creates hierarchy by isolating key points
- Essential for emphasis
- Don't fear empty space

**CRAP Principles**:
- **C**ontrast: Make different elements very different
- **R**epetition: Repeat design elements for unity
- **A**lignment: Every element should align with something
- **P**roximity: Related items should be grouped

---

### Images

**Quality Requirements**:
- High-resolution only (TED requirement)
- Must own or have permission
- Avoid generic stock photos
- Images must enhance message, not decorate

**Types of Images**:
- Data visualizations (charts, graphs)
- Conceptual illustrations
- Real-world photography
- Diagrams and infographics

---

## Guy Kawasaki's 10/20/30 Rule

**Originally for VC Pitches, Applicable to All Presentations**:

**10 Slides Maximum**
- Audiences can't comprehend more than 10 concepts in one sitting
- Forces you to identify truly important points

**20 Minutes Maximum**
- Shorter is better
- Leaves time for discussion
- Respects audience attention span

**30-Point Font Minimum**
- If you need smaller fonts, you have too much content
- Forces simplicity
- Ensures readability from back of room

---

## Edward Tufte's Data Visualization Principles

### Graphical Integrity

**Lie Factor**: Visual representation must tell the truth
- Formula: (Size of effect shown in graphic) / (Size of effect in data)
- Acceptable range: 0.95 to 1.05
- Outside this range = distortion

**Rules**:
- Don't use area to show one-dimensional data
- Use consistent scales
- Representations of numbers should be proportional to numerical quantities

---

### Maximize Data-Ink Ratio

**Data-Ink Ratio** = Data-ink / Total ink used in graphic

**Eliminate**:
- Chartjunk (unnecessary decoration)
- 3D effects
- Unnecessary grid lines
- Excessive borders
- Non-data backgrounds

**Maximize**:
- Data points
- Trend lines
- Comparisons
- Actual information

---

### Small Multiples

Instead of one complex chart, use series of small charts with same axes to show:
- Changes over time
- Comparisons across categories
- Pattern recognition

---

## Mayer's 12 Principles of Multimedia Learning

### Reducing Extraneous Processing

1. **Coherence**: Remove extraneous material
2. **Signaling**: Highlight organization and essential material
3. **Redundancy**: Don't show text + say same text verbatim
4. **Spatial Contiguity**: Put related elements near each other
5. **Temporal Contiguity**: Present related elements simultaneously

### Managing Essential Processing

6. **Segmentation**: Break into logical chunks
7. **Pretraining**: Introduce key concepts early
8. **Modality**: Graphics + narration better than graphics + on-screen text

### Fostering Generative Processing

9. **Multimedia**: Use words + pictures together
10. **Personalization**: Use conversational style
11. **Voice**: Informal voice over formal
12. **Image**: Speaker image not required (focus on content)

---

## Steve Jobs Presentation Techniques

### Create Moments

**The Surprise**:
- MacBook Air pulled from envelope
- "One more thing..."
- Rehearsed spontaneity

**The Demo**:
- Live product demonstrations
- Make it real and tangible
- Show, don't just tell

**The Analogy**:
- "1,000 songs in your pocket" (not "5GB MP3 player")
- Make it relatable
- Connect to audience experience

---

### The Rule of Three

**Three Acts**:
- Setup → Conflict → Resolution
- Past → Present → Future
- Problem → Journey → Solution

**Three Features**:
- Never showed more than 3 key features
- Each feature given dedicated focus
- Memorable and digestible

---

## Common Mistakes to Avoid

### Critical Errors

1. **Reading from slides** - Slides support, don't replace you
2. **Too much text** - Paragraphs and long bullets
3. **Poor contrast** - Can't read from back of room
4. **Information overload** - Trying to fit too much
5. **Default templates** - Generic and forgettable
6. **Ending with Q&A** - Always end strong with your message

---

### Design Flaws

1. **Chart junk** - 3D effects, unnecessary decoration
2. **Inconsistent styling** - Random fonts, colors
3. **Low-res images** - Pixelated, stretched photos
4. **Excessive transitions** - Distracting animations
5. **Bullet point addiction** - Lazy content organization

---

### Content Issues

1. **Not tailoring to audience** - One size fits all approach
2. **No emotional connection** - Just facts and figures
3. **Missing story arc** - Disjointed information
4. **Too many concepts** - Violating 10-concept rule
5. **Insufficient rehearsal** - "Winging it"

---

## Presentation Type Guidelines

### Board/Executive Update

**Characteristics**:
- Data-driven
- Professional tone
- Clear recommendations
- Time-efficient

**Best Practices**:
- 8-10 slides maximum
- Heavy use of data visualizations
- Clear "What/So What/Now What" structure
- Executive summary up front

---

### Keynote/TED-Style

**Characteristics**:
- Story-driven
- Emotional connection
- Inspirational
- Transformative

**Best Practices**:
- 12-15 slides
- Minimal text (<3 words often)
- Personal stories
- Strong emotional arc
- Surprise moments

---

### Training/Educational

**Characteristics**:
- Process-focused
- Step-by-step
- Retention-optimized
- Practice-oriented

**Best Practices**:
- 15-20 slides
- Clear progression
- Mayer's principles critical
- Examples and exercises
- Summaries and reviews

---

### Pitch/Sales

**Characteristics**:
- Problem-solution focused
- Evidence-based
- ROI-driven
- Competitive positioning

**Best Practices**:
- 10 slides (Kawasaki rule)
- Clear problem statement
- Unique value proposition
- Market validation
- Call to action

---

## Quality Assessment Questions

Before presenting, ask:

**Content**:
- Can I explain the core message in one sentence?
- Is there exactly one idea per slide?
- Does each slide support the overall story?
- Is the audience positioned as the hero?

**Design**:
- Can I read all text from 10 feet away?
- Have I eliminated all non-essential elements?
- Is the visual hierarchy clear?
- Are related elements grouped together?

**Data** (if applicable):
- Is my lie factor between 0.95-1.05?
- Have I maximized data-ink ratio?
- Are all charts clearly labeled?
- Can I explain the "so what" for each visualization?

**Story**:
- Does my presentation have clear beginning/middle/end?
- Is there tension and resolution?
- Will the audience remember the key message?
- Have I included a surprise or memorable moment?

---

## Sources & Further Reading

**Books**:
- Presentation Zen by Garr Reynolds
- Resonate by Nancy Duarte
- slide:ology by Nancy Duarte
- The Visual Display of Quantitative Information by Edward Tufte
- Multimedia Learning by Richard Mayer

**Articles**:
- Guy Kawasaki: The 10/20/30 Rule of PowerPoint
- Seth Godin: Really Bad PowerPoint
- TED: How to Create Slides for Your TED Talk

**Websites**:
- presentationzen.com
- duarte.com
- ted.com/participate/organize-a-local-tedx-event/tedx-organizer-guide/speakers-program/prepare-your-speaker

---

**Remember**: These principles are not rigid rules—they're wisdom distilled from thousands of successful presentations. Adapt them to your context, but respect the underlying truths they represent.
