# Slide Pattern Library - Comprehensive Guide

This document provides detailed specifications for six proven slide patterns that form the foundation of world-class presentations. Each pattern has been validated across thousands of successful presentations by masters like Garr Reynolds, Nancy Duarte, and Steve Jobs.

---

## Pattern 1: Title Slide

### Purpose
Set the tone for the entire presentation and create immediate visual impact. The title slide is the audience's first impression and should establish both the topic and the emotional tenor of what's to come.

### Core Elements

**Text Requirements**:
- Title: 3-6 words maximum (Godin principle)
- Subtitle (optional): 5-10 words providing context
- Attribution: Speaker name, date, or organization (minimal, small font)
- Font size: Title 48-72pt, Subtitle 24-36pt, Attribution 14-18pt

**Visual Treatment**:
- **Option A - Image-Based**: Full-bleed high-quality photograph or illustration that emotionally connects to the topic
- **Option B - Typography-Based**: Bold, clean typography on solid background color (brand color preferred)
- **Option C - Minimalist**: Simple text on white/black background with subtle accent element

**Layout Specifications**:
- Title positioned in vertical center or upper third (golden ratio positioning)
- Ample whitespace around all elements (minimum 10% margins)
- If using image, ensure text has sufficient contrast (overlay, shadow, or positioning)

### Design Principles

**Contrast**:
- Text must have minimum 7:1 contrast ratio against background
- Use overlay gradient (70% opacity recommended) if text on image
- Dark text on light background OR light text on dark background - never midtones

**Alignment**:
- Center alignment for maximum impact and formality
- Left alignment for more conversational, approachable tone
- Never right-align title slides

**Color Psychology**:
- Board presentations: Navy, charcoal, or brand primary (professional, trustworthy)
- Keynotes: Bold accent colors (energetic, memorable)
- Training: Lighter, accessible colors (approachable, educational)
- Pitches: Confident colors aligned with brand (credible, distinctive)

### Examples by Presentation Type

**Board/Executive Update**:
```
Title: "Cybersecurity Update"
Subtitle: "Q4 2025 Board Meeting"
Background: Navy (#25424C) with subtle geometric pattern
Font: Sans-serif, bold, 64pt title / 28pt subtitle
Alignment: Center
```

**Keynote/TED-Style**:
```
Title: "The Future of Learning"
Subtitle: (none - let title stand alone)
Background: Full-bleed image of engaged students
Overlay: 60% black gradient from bottom
Font: Modern sans-serif, white, 72pt
Alignment: Lower third positioning
```

**Training/Educational**:
```
Title: "Excel Fundamentals"
Subtitle: "Session 1: Getting Started"
Background: Light gray (#F5F5F5)
Accent: Brand color bar on left (10% width)
Font: Friendly sans-serif, dark gray, 56pt / 24pt
Alignment: Left with padding
```

**Pitch/Sales**:
```
Title: "Revolutionizing EdTech"
Subtitle: "Series A Pitch - November 2025"
Background: Brand primary color with product screenshot (20% opacity)
Font: Brand font, white, 60pt / 22pt
Alignment: Center
```

### Common Mistakes to Avoid

1. **Too much text**: More than 10 words total dilutes impact
2. **Cluttered layout**: Logo, tagline, disclaimer, date all competing
3. **Poor image quality**: Low-resolution or generic stock photos
4. **Weak contrast**: Text hard to read against busy background
5. **Mixed messages**: Image doesn't relate to topic
6. **Default templates**: PowerPoint/Keynote standard templates scream amateur

### Variations

**Simple Title Only**:
- Just the presentation title, nothing else
- Maximum impact, extreme minimalism
- Best for confident presenters with strong topic

**Title + Provocative Question**:
- Title as question that creates curiosity
- Example: "What if AI could learn like humans?"
- Engages audience immediately

**Title + Powerful Statistic**:
- Title with supporting shocking fact
- Example: "The Education Crisis" + "73% of students unprepared"
- Creates urgency

---

## Pattern 2: One Big Idea

### Purpose
Communicate a single concept with maximum impact. This pattern is the embodiment of Seth Godin's "6 words or less" principle and creates the most memorable moments in presentations.

### Core Elements

**Text Requirements**:
- Absolute maximum: 6 words
- Ideal: 1-3 words
- Font size: 60-120pt (yes, that large)
- Font weight: Bold or heavy preferred
- No punctuation unless essential (question mark, exclamation acceptable)

**Visual Treatment**:
- **Option A - Text Only**: Massive typography fills the slide
- **Option B - Text + Single Icon**: One simple, clear icon supporting the word
- **Option C - Text + Full-Bleed Image**: Bold text over compelling photograph
- **Option D - Isolated Number**: Giant statistic with minimal context

**Layout Specifications**:
- Text occupies 40-60% of slide area
- Positioned using rule of thirds or dead center
- Whitespace is essential - minimum 30% empty space
- If using image, ensure it doesn't compete with text

### Design Principles

**Emphasis Through Size**:
- Text should be readable from 50+ feet away
- Use optical sizing - adjust for visual balance not mathematical precision
- Heavy font weights prevent text from looking weak at large sizes

**Color Strategy**:
- Monochromatic: Single color on contrasting background (safest, cleanest)
- Accent color: Key word in accent color, rest neutral (draws eye strategically)
- Brand palette: Use brand colors for consistency

**Typography Selection**:
- Sans-serif for modern, clean impact (Helvetica, Avenir, Gotham)
- Bold serif for traditional, authoritative feel (Playfair, Garamond Bold)
- Display fonts acceptable if highly readable (avoid decorative)

### Use Cases

**Key Statistics**:
```
"83%"
(That's it. Let the number sink in. Explain verbally.)
```

**Transitions**:
```
"But..."
(Signals shift in narrative)
```

**Memorable Phrases**:
```
"10x Growth"
(Bold claim that demands attention)
```

**Questions**:
```
"Why?"
(Provokes thought, creates curiosity)
```

**Moments of Impact**:
```
"Everything Changed"
(Emotional turning point)
```

### Examples by Context

**Board Update - Key Metric**:
```
Text: "$2.4M"
Subtitle (small, 18pt): "Cost savings achieved Q4"
Background: White
Text color: Brand primary
Font: Bold sans-serif, 100pt
Position: Center
```

**Keynote - Provocative Statement**:
```
Text: "Obsolete"
Background: Dark red (#8B0000)
Text color: White
Font: Heavy sans-serif, 120pt
Position: Center
Effect: One word conveys urgency of change
```

**Training - Concept Introduction**:
```
Text: "Pivot Tables"
Icon: Simple table/grid icon above text
Background: Light background
Text color: Dark gray
Font: Bold sans-serif, 80pt
Position: Center with icon
```

**Pitch - Vision Statement**:
```
Text: "Accessible"
Background: Full-bleed image of diverse students
Overlay: 40% black from edges
Text color: White
Font: Bold serif, 90pt
Position: Lower third
```

### Common Mistakes to Avoid

1. **Too many words**: Seven+ words destroys the impact
2. **Too small**: Font under 60pt defeats the purpose
3. **Complexity**: Adding unnecessary elements dilutes focus
4. **Weak fonts**: Thin or light weights disappear at distance
5. **Poor word choice**: Generic words lack punch ("Important" vs "Critical")
6. **Overuse**: Every slide can't be "one big idea" - save for key moments

### Advanced Techniques

**Progressive Revelation**:
- Start with one word
- Next slide adds second word
- Builds phrase progressively
- Creates narrative momentum

**Numerical Sequences**:
```
Slide 1: "3"
Slide 2: "Breakthroughs"
Slide 3: "That Changed Everything"
```

**Contrasting Pairs**:
```
Slide 1: "Then" (old way)
Slide 2: "Now" (new way)
Creates before/after impact
```

---

## Pattern 3: Visual + Caption

### Purpose
Combine the power of imagery with minimal explanatory text. This is the workhorse pattern for visual storytelling - the image carries 80% of the message, the caption provides critical context.

### Core Elements

**Visual Requirements**:
- High-resolution image: Minimum 1920x1080 for 16:9, ideally 2K or 4K
- Image quality: Professional photography or high-quality illustration
- Relevance: Image must directly relate to and reinforce the message
- Composition: Clear focal point, uncluttered background
- Aspect ratio: Should fill 70-90% of slide area

**Caption Specifications**:
- Text length: 5-15 words maximum (one line ideal)
- Font size: 24-36pt
- Position: Usually bottom third, sometimes top or side
- Background treatment: Solid bar, gradient, or none if contrast sufficient
- Alignment: Usually left-aligned, centered for impact

**Layout Options**:

**Option A - Full Bleed with Bottom Caption**:
```
Image: Fills entire slide
Caption: Bottom 15% of slide
Caption background: Semi-transparent bar (70-80% opacity)
Text: White or light color
Padding: 20pt all sides of caption
```

**Option B - Image with Side Caption**:
```
Image: Left 70% of slide
Caption area: Right 30%
Caption background: Solid brand color
Text: Contrasting color
Vertical alignment: Center
```

**Option C - Image with Floating Caption**:
```
Image: Full slide
Caption: Positioned over negative space in image
Background: Subtle shadow or outline for legibility
Text: Color depends on background
```

### Design Principles

**Image Selection Criteria**:
1. **Authenticity**: Prefer real photos over generic stock imagery
2. **Emotion**: Image should evoke appropriate emotional response
3. **Simplicity**: Clear subject, uncluttered composition
4. **Quality**: Crisp, well-lit, professionally captured
5. **Relevance**: Obvious connection to message (avoid metaphors audience must decode)

**Caption Writing**:
- **Descriptive**: "Students engaged in hands-on learning"
- **Interpretive**: "This is what transformation looks like"
- **Statistical**: "73% improvement in engagement scores"
- **Narrative**: "Where it all began - June 2020"
- **Provocative**: "Everything you know is wrong"

**Color Coordination**:
- Extract dominant colors from image for caption background
- Ensure caption doesn't clash with image colors
- Use complementary colors for accent and harmony

### Use Cases by Presentation Type

**Board Update - Evidence**:
```
Image: Bar chart showing growth trend
Caption: "Revenue up 34% year-over-year"
Layout: Full-bleed chart
Caption: Bottom bar, white text on dark background
Purpose: Concrete evidence of success
```

**Keynote - Emotional Moment**:
```
Image: Powerful photograph of impact (students, customers, etc.)
Caption: "This is why we do what we do"
Layout: Full-bleed image
Caption: Lower third, white text with subtle shadow
Purpose: Create emotional connection
```

**Training - Example**:
```
Image: Screenshot or diagram showing concept
Caption: "Notice how the formula references cell A1"
Layout: Image fills slide
Caption: Top banner, dark text on light background
Purpose: Clear visual instruction
```

**Pitch - Problem Illustration**:
```
Image: Photograph showing problem state
Caption: "Current classroom reality"
Layout: Full-bleed image
Caption: Bottom, white text on semi-transparent overlay
Purpose: Establish problem before solution
```

### Examples

**Example 1: Impact Story**
```
Visual: Close-up photo of student working intently on project
Caption: "Engagement increased 89% with new curriculum"
Layout: Full-bleed image
Caption Position: Bottom third
Caption Background: Black bar, 75% opacity
Text: White, 28pt, left-aligned with 30pt left padding
Effect: Human face + concrete data = compelling evidence
```

**Example 2: Before/After**
```
Slide 1:
Visual: Dated classroom with rows of desks
Caption: "Traditional learning environment"
Layout: Full-bleed
Caption: Simple bottom text, white with drop shadow

Slide 2:
Visual: Modern collaborative learning space
Caption: "Reimagined for 2025"
Layout: Same as Slide 1
Effect: Visual contrast reinforces transformation narrative
```

**Example 3: Process Step**
```
Visual: Diagram or photo showing specific step
Caption: "Step 3: Connect the data sources"
Layout: Image 80% of slide
Caption: Right sidebar, brand color background
Text: White, 24pt
Icon: Small numbered circle "3" above text
Effect: Clear, sequential instruction
```

### Common Mistakes to Avoid

1. **Generic stock photos**: Fake-looking people with forced smiles
2. **Caption too long**: Paragraph of text defeats the visual-first purpose
3. **Poor image quality**: Pixelated, stretched, or low-resolution images
4. **Competing elements**: Image and caption fight for attention
5. **Illegible text**: Caption lacks sufficient contrast with background
6. **Irrelevant imagery**: Image is decorative, not meaningful
7. **Busy backgrounds**: Too much visual noise distracts from message

### Advanced Techniques

**Ken Burns Effect** (if presenting digitally):
- Slow zoom on static image
- Creates motion and maintains interest
- Use sparingly - can be distracting if overused

**Split Image**:
```
Left 50%: Before image
Right 50%: After image
Caption: Center, spanning both - "6-month transformation"
Effect: Direct visual comparison
```

**Image Series**:
```
Three images on one slide (each 33% width)
Single caption below: "Three approaches to the same problem"
Effect: Comparison without clutter
```

**Annotated Images**:
```
Image: Screenshot or diagram
Annotations: Minimal callouts (arrows, circles, labels)
Caption: "Focus on the highlighted section"
Effect: Guides attention to specific elements
```

---

## Pattern 4: Data Visualization

### Purpose
Present quantitative information in the clearest, most truthful, and most impactful way possible. This pattern follows Edward Tufte's principles of graphical integrity and maximum data-ink ratio.

### Core Principles (Tufte)

**Graphical Integrity**:
1. **Lie Factor** = (Size of effect shown in graphic) / (Size of effect in data)
   - Acceptable range: 0.95 to 1.05
   - Outside this range = distortion
2. **Representation of numbers should be proportional to numerical quantities**
3. **Use clear, detailed labeling** - avoid ambiguity
4. **Show data variation, not design variation**

**Maximize Data-Ink Ratio**:
- **Data-ink**: Ink used to display actual data
- **Non-data-ink**: Everything else (borders, backgrounds, decorations)
- **Goal**: Maximize (data-ink / total ink)
- **Method**: Remove everything that isn't data

### Chart Type Selection

**Line Charts**:
- **Best for**: Trends over time, continuous data
- **When to use**: Showing change, trajectory, patterns
- **Data requirements**: At least 5-7 data points for meaningful trend
- **Key features**: Clear axis labels, legend if multiple lines, gridlines minimal

**Bar Charts**:
- **Best for**: Comparing discrete categories
- **When to use**: Comparing quantities across categories
- **Orientation**: Vertical (column) for time-based, horizontal for categorical
- **Key features**: Bars should touch or have minimal spacing, start axis at zero

**Scatter Plots**:
- **Best for**: Showing relationships between two variables
- **When to use**: Correlation analysis, clustering, outlier detection
- **Key features**: Clear axis scaling, trend line if appropriate, labeled outliers

**Pie Charts** (use rarely):
- **Best for**: Parts of a whole (ONLY if <5 segments)
- **When to use**: Showing simple proportions (avoid if possible)
- **Better alternative**: Bar chart is almost always clearer
- **If must use**: Start at 12 o'clock, go clockwise, label directly

**Small Multiples**:
- **Best for**: Comparing patterns across multiple categories
- **When to use**: Same data structure repeated across segments
- **Key features**: Identical scales, same chart type, grid layout
- **Example**: Sales trends for each region, same date range

### Design Specifications

**Typography for Data**:
- Axis labels: 14-18pt, sans-serif
- Data labels: 12-16pt, shown sparingly (only key values)
- Title: 24-28pt, descriptive not generic
- Source citation: 10-12pt, bottom right corner

**Color for Data**:
- **Single series**: One color, varying shade for emphasis
- **Multiple series**: Distinct colors (colorblind-safe palette)
- **Diverging data**: Blue-white-red or similar
- **Categorical**: Distinct hues with sufficient contrast
- **Avoid**: Traffic light colors (red/yellow/green) unless truly stop/caution/go

**Elements to Eliminate** (Chart Junk):
1. 3D effects - distort perception of quantities
2. Unnecessary gridlines - use sparingly, light gray
3. Bold borders around chart area - use minimal or none
4. Decorative backgrounds - solid white or very light gray only
5. Default color gradients - use flat colors
6. Excessive tick marks - show only necessary intervals
7. Redundant labels - if in legend, don't label each bar

**Elements to Emphasize**:
1. Data points/bars/lines - these are the story
2. Key values - highlight the insight
3. Trend lines - if they reveal pattern
4. Annotations - explain anomalies or key points
5. Scale - always clear what units represent

### Example Specifications

**Example 1: Revenue Growth (Line Chart)**
```
Chart Type: Line chart
Data: Quarterly revenue, 2023-2025
Layout: Chart fills 80% of slide
Title: "34% Revenue Growth Over 3 Years"
X-Axis: Quarters (Q1 2023 → Q4 2025)
Y-Axis: Revenue ($M), starting at 0
Line: Bold (3pt), brand primary color
Gridlines: Horizontal only, light gray (10% opacity), major intervals
Annotation: Arrow pointing to Q3 2025 → "New product launch"
Data labels: Start, end, and peak values only
Background: White
Font: Sans-serif throughout
```

**Example 2: Category Comparison (Bar Chart)**
```
Chart Type: Horizontal bar chart
Data: Student performance by subject (5 subjects)
Layout: Chart fills 75% of slide, centered
Title: "Math Scores Lead Academic Performance"
X-Axis: Percentage (0-100%)
Y-Axis: Subject names
Bars: All same color except highest (Math) - highlighted in brand accent
Spacing: Minimal between bars
Data labels: End of each bar showing exact percentage
Gridlines: Vertical, light gray, every 20%
Background: Light gray (#F5F5F5)
```

**Example 3: Comparison Across Segments (Small Multiples)**
```
Chart Type: 4 identical line charts in 2x2 grid
Data: Usage patterns for 4 customer segments
Layout: Each chart 45% of slide width/height
Titles: Customer segment name above each
Shared Y-axis: Usage frequency (0-100)
Shared X-axis: Months (Jan-Dec)
Lines: Same brand color in all four
Gridlines: Minimal, shared scales
Annotation: Overall title "Usage Patterns Vary By Segment"
Background: White with subtle dividing lines between charts
```

### Common Mistakes to Avoid

1. **Non-zero baseline**: Bar charts not starting at zero distort perception
2. **Dual-axis abuse**: Two Y-axes can manipulate correlation appearance
3. **Too many data series**: More than 4-5 lines becomes spaghetti chart
4. **Missing context**: No title, source, or units
5. **Misleading scales**: Logarithmic when linear expected, or truncated range
6. **Decorative over functional**: Prioritizing aesthetics over clarity
7. **3D pie charts**: The worst offender - distorts all proportions
8. **Tiny fonts**: Data labels too small to read
9. **Rainbow colors**: Using every color destroys visual hierarchy
10. **Chart junk**: Unnecessary backgrounds, borders, shadows, gradients

### Advanced Techniques

**Sparklines** (Tufte):
- Tiny line charts embedded in text or tables
- Show trend without axes or labels
- Effective for showing many trends simultaneously
- Example: "Revenue $2.4M [tiny trend line showing up/down]"

**Slopegraphs**:
- Compare two points in time
- Lines connect same category across time periods
- Slope shows change (up/down/flat)
- Cleaner than bar chart for before/after

**Dot Plots**:
- Alternative to bar charts
- Shows value as positioned dot
- Reduces ink, increases clarity
- Especially good for many categories

**Annotated Charts**:
- Add explanatory text directly on chart
- Arrow pointing to significant data point
- "Here's where policy changed"
- Makes insight explicit, not just implied

---

## Pattern 5: Timeline / Process

### Purpose
Show progression, sequence, or chronological flow. This pattern makes complex processes understandable and temporal relationships clear.

### Core Elements

**Structure Requirements**:
- 3-7 steps maximum (cognitive load limit)
- Each step labeled clearly
- Visual connection between steps (arrows, lines, numbers)
- Minimal text per step (5-10 words)
- Consistent visual treatment across all steps

**Visual Treatment Options**:

**Option A - Horizontal Linear**:
```
[Step 1] → [Step 2] → [Step 3] → [Step 4]
Left to right progression (Western reading)
Equal spacing between elements
Arrow or line connecting
```

**Option B - Vertical Linear**:
```
[Step 1]
    ↓
[Step 2]
    ↓
[Step 3]
```
Top to bottom (natural gravity/sequence)
Good for processes with sub-steps
```

**Option C - Circular/Cyclical**:
```
        [Step 1]
       ↙       ↖
  [Step 4]    [Step 2]
       ↖       ↙
        [Step 3]
```
For processes that repeat
Shows no definitive end
```

**Option D - Timeline with Dates**:
```
2020 ----•---- 2022 ----•---- 2024 ----•---- 2026
         Event       Event       Event      Future
Historical progression
Specific dates marked
```

### Design Specifications

**Step Containers**:
- Shape: Rectangles, circles, or rounded rectangles (consistent)
- Size: Large enough for text (minimum 150pt x 150pt)
- Color: Sequential (lightest to darkest) OR consistent with one highlighted
- Border: Optional, 2-4pt if used
- Spacing: 40-60pt between containers

**Connectors**:
- Arrows: Bold (4-6pt), simple style
- Lines: Straight or curved, 3-5pt thickness
- Color: Neutral gray or brand color
- Style: Avoid fancy arrowheads - simple is best

**Text Treatment**:
- Step number/label: Bold, 18-24pt
- Step description: Regular, 14-18pt
- Alignment: Centered within container
- Line spacing: 1.3-1.5x

**Icons** (optional):
- Simple, flat design icons
- Positioned above or beside step label
- Size: 40-60pt
- Color: Match step container or accent color

### Use Cases

**Project Roadmap**:
```
Q1 2025: Discovery → Q2 2025: Design → Q3 2025: Build → Q4 2025: Launch
Each quarter as step
Timeline shows progression
Current position highlighted
```

**Process Flow**:
```
1. Intake → 2. Assessment → 3. Planning → 4. Implementation → 5. Review
Clear sequential process
Numbered steps
Arrows show direction
```

**Historical Timeline**:
```
2020: Founded → 2022: Series A → 2024: Expansion → 2026: IPO (projected)
Company milestones
Mix of past and future
Visual distinction between actual and planned
```

**Instructional Steps**:
```
Step 1           Step 2           Step 3
↓                ↓                ↓
[Screenshot 1]   [Screenshot 2]   [Screenshot 3]
"Click File"     "Select Export"   "Choose PDF"
Visual + textual instruction
```

### Examples by Presentation Type

**Board Update - Quarterly Progress**:
```
Visual: Horizontal timeline
Steps: 4 quarters
Design:
- Q1-Q3: Filled circles (completed)
- Q4: Outlined circle (current)
- Each with 2-line label: "Q3 2025" / "Product Beta"
- Line connecting all
Color: Completed = brand green, Current = brand primary
Background: White
```

**Keynote - Transformation Journey**:
```
Visual: Ascending diagonal path
Steps: 3 major phases
Design:
- Large numbers (1, 2, 3) in circles
- Short phase name below each
- Arrow path between
- Increasing opacity to show progression
Text: Bold numbers (48pt), labels (24pt)
Background: Gradient light to dark
Effect: Visual metaphor of climbing/growing
```

**Training - Process Steps**:
```
Visual: Vertical flowchart
Steps: 5 sequential actions
Design:
- Rounded rectangles
- Numbered 1-5
- Down arrows between
- Each step: Icon + label + brief description
- Current step highlighted in different color
Background: Light background
Effect: Clear, easy to follow instruction
```

**Pitch - Traction Timeline**:
```
Visual: Horizontal timeline with milestones
Steps: Key achievements from founding to present
Design:
- Timeline bar at bottom
- Milestones as points above bar
- Date labels below bar
- Achievement labels above
- Exponential growth implied by increasing frequency
Color: Milestones in accent color, bar in neutral
```

### Common Mistakes to Avoid

1. **Too many steps**: More than 7 becomes overwhelming
2. **Inconsistent spacing**: Irregular gaps imply irregular timing (unless intentional)
3. **Unclear sequence**: Ambiguous flow direction
4. **Too much text**: Paragraph descriptions defeat visual flow purpose
5. **Weak connectors**: Arrows too thin or unclear
6. **Visual clutter**: Mixing too many icon styles, shapes, colors
7. **Poor hierarchy**: All steps look equally important when some are not
8. **Missing context**: Timeline without dates, process without start/end labels

### Advanced Techniques

**Branching Paths**:
```
        Step 1
          ↓
    ↙    ↓    ↘
Option A  B   C
    ↘    ↓    ↙
      Outcome
```
Shows decision points
Multiple paths to result
```

**Parallel Processes**:
```
Process A: Step 1 → Step 2 → Step 3
             ↓        ↓        ↓
Process B: Step 1 → Step 2 → Step 3
```
Two simultaneous workflows
Vertical alignment shows synchronization
```

**Swimlane Diagram**:
```
Customer:  Action → Wait → Receive
Company:   Receive → Process → Deliver
System:    Log → Notify → Archive
```
Who does what when
Horizontal lanes by actor
```

---

## Pattern 6: Transition / Section Break

### Purpose
Signal major shifts in the presentation narrative. These slides are the chapter breaks in your presentation story - they give the audience a mental pause and prepare them for a new direction.

### Core Elements

**Text Requirements**:
- Absolute minimum: 1 word
- Maximum: 5 words
- Font size: 60-100pt
- Weight: Bold to Extra Bold
- Purpose: Signal change, not inform

**Visual Treatment**:
- **Option A - Simple Text**: One word/phrase on solid background
- **Option B - Visual Metaphor**: Image representing the transition
- **Option C - Chapter Number**: "Part 2" or "03" with section name
- **Option D - Question**: Provocative question leading to next section

**Color Strategy**:
- Different from surrounding slides (signals change)
- Often higher contrast or inverted from main deck
- Brand color acceptable but not required

### Design Specifications

**Minimal Approach**:
```
Text: "But..."
Background: Solid color (inverted from previous slides)
Font: Bold sans-serif, 80pt
Position: Dead center
Effect: Creates pause, signals shift
```

**Chapter Style**:
```
Text: "Part 2" (small, 24pt, top) + "The Solution" (large, 64pt, center)
Background: Full-bleed image or gradient
Design: Number and title stacked
Effect: Clear chapter structure
```

**Metaphorical**:
```
Text: "The Turning Point"
Visual: Image of path diverging, door opening, bridge, etc.
Overlay: Text over image with sufficient contrast
Effect: Visual reinforces narrative shift
```

### Use Cases

**From Problem to Solution**:
```
Transition: "The Answer"
Color: Shift from dark (problem) to light (solution)
Font: Bold, optimistic
Position: Center
```

**Between Main Sections**:
```
Part 1 slides → Transition: "Part 2" → Part 2 slides
Visual: Different background color for transition
Text: Large number + section name
```

**Rhetorical Question**:
```
Text: "What if we could?"
Background: Thought-provoking image
Effect: Creates anticipation for next section
```

**Timeline Break**:
```
Past slides → Transition: "Today" → Future slides
Visual: Timeline element or calendar icon
Color: Distinct from both past and future
```

### Examples by Presentation Type

**Board Update - Section Break**:
```
Between: "Results" and "Recommendations"
Text: "Looking Forward"
Background: Brand primary color
Font: Brand font, white, 72pt, center
Duration: Brief pause, no narration needed
Effect: Signals shift from analysis to action
```

**Keynote - Emotional Shift**:
```
After: Series of problem slides
Transition: "But what if..."
Background: Black
Text: White, italic, 64pt, center
Visual: Slight pause in delivery
Effect: Creates dramatic tension before solution reveal
```

**Training - Module Break**:
```
Between: Module 1 and Module 2
Text: "Module 2" (top, 24pt) + "Data Analysis" (center, 56pt)
Background: Light gray with module icon
Include: Progress indicator (2 of 5)
Effect: Clear structure, shows progress
```

**Pitch - Credibility Shift**:
```
After: Product demo slides
Before: Team/traction slides
Text: "Who We Are"
Background: Team photo (blurred) with overlay
Font: Bold, confident
Effect: Transition from what to who
```

### Common Mistakes to Avoid

1. **Too much information**: Transition slide with paragraph of text
2. **Inconsistent use**: Only some sections have breaks
3. **Weak visual distinction**: Looks too similar to content slides
4. **Too frequent**: Transition after every slide dilutes impact
5. **Unnecessary decoration**: Fancy animations or effects
6. **Missing purpose**: Generic "Next" instead of meaningful signal

### Advanced Techniques

**Countdown Structure**:
```
"3 Reasons This Matters"
→ [Reason 1 slide]
→ "2 More Reasons"
→ [Reason 2 slide]
→ "Final Reason"
→ [Reason 3 slide]
```
Creates anticipation
Shows progress through list
```

**Perspective Shift**:
```
"From the outside..."
→ [External viewpoint slides]
→ "From the inside..."
→ [Internal perspective slides]
```

**Time Travel**:
```
"Five Years Ago"
→ [Historical slides]
→ "Today"
→ [Current slides]
→ "Five Years From Now"
→ [Future slides]
```

---

## Pattern Selection Matrix

| Presentation Type | Pattern 1 (Title) | Pattern 2 (Big Idea) | Pattern 3 (Visual+Caption) | Pattern 4 (Data) | Pattern 5 (Timeline) | Pattern 6 (Transition) |
|-------------------|-------------------|----------------------|----------------------------|------------------|----------------------|------------------------|
| **Board Update** | 10% | 10% | 30% | 40% | 5% | 5% |
| **Keynote** | 10% | 40% | 30% | 5% | 10% | 5% |
| **Training** | 10% | 5% | 20% | 30% | 30% | 5% |
| **Pitch** | 10% | 30% | 25% | 30% | 5% | 0% |

---

## Mixing Patterns Effectively

**Rule of Variation**:
- Never use same pattern for more than 3 consecutive slides
- Alternate between high-impact (Pattern 2) and supportive (Pattern 3, 4)
- Use transitions (Pattern 6) to reset audience attention

**Visual Rhythm**:
- Pattern 1 (Title) → Pattern 3 → Pattern 3 → Pattern 6 → Pattern 2 → Pattern 4 → Pattern 3...
- Creates flow: Introduction → Evidence → Evidence → Shift → Impact → Data → Evidence

**Energy Management**:
- High energy: Patterns 1, 2, 6
- Medium energy: Pattern 3
- Lower energy: Patterns 4, 5 (require more processing)
- Alternate to maintain engagement

---

## Accessibility Considerations

**For All Patterns**:
- Minimum font size: 30pt (preferably 36pt+)
- Contrast ratio: 4.5:1 minimum (7:1 preferred)
- Color: Never rely solely on color to convey meaning
- Alt text: Describe images for screen readers (future enhancement)
- Animations: Avoid or allow pause/control

---

This comprehensive pattern library provides the foundation for creating presentations that are simultaneously beautiful, clear, and impactful. Master these six patterns and their variations, and you'll have the tools to create world-class presentations for any context.
