---
created: {date}
year: {YEAR}
domains: [CIO, Consulting, Product, RealEstate, Financial]
status: Draft
quarterly_reviews:
  - Q1: null
  - Q2: null
  - Q3: null
  - Q4: null
---

# {YEAR} Annual Strategic Review

> **Mission Integration:** This review aligns with TELOS definition and Personal Constitution principles: advancing equity through innovation, achieving mastery + legacy + freedom.

## Year-in-Review Summary

### Cross-Domain Patterns

**Recurring Themes Across Domains:**
- {pattern_1}
- {pattern_2}
- {pattern_3}

**Strengths Consistently Leveraged:**
- Input: {how_information_gathering_supported_success}
- Analytical: {how_evidence_based_thinking_drove_outcomes}
- Learner: {how_continuous_learning_created_mastery}

**Blind Spots Identified:**
- {blind_spot_1}
- {blind_spot_2}

### Key Lessons for {NEXT_YEAR}

1. **{lesson_1_title}:** {lesson_1_description}
2. **{lesson_2_title}:** {lesson_2_description}
3. **{lesson_3_title}:** {lesson_3_description}

---

## Domain: CIO Role

### {PREV_YEAR} Review

**Top 3 Priorities:**
1. **{priority_1}** - *Outcome:* {what_actually_happened_1}
2. **{priority_2}** - *Outcome:* {what_actually_happened_2}
3. **{priority_3}** - *Outcome:* {what_actually_happened_3}

**What Worked Exceptionally Well:**
- **{success_1}:** {evidence_and_metrics}
- **{success_2}:** {evidence_and_metrics}
- **Root Causes:** {why_this_succeeded}

**What Underperformed:**
- **{gap_1}:** {what_fell_short}
- **{gap_2}:** {what_fell_short}
- **Root Causes:** {systemic_barriers_or_failures}

**Surprises (Positive & Negative):**
- ➕ {positive_surprise}
- ➖ {negative_surprise}

---

### {YEAR} Strategic Direction

**Vision of Success:**

{specific_measurable_stakeholder_focused_outcome_for_year_end}

**Primary Stakeholders & Impact:**

| Stakeholder Group | What Changes for Them if We Succeed |
|-------------------|-----------------------------------|
| {stakeholder_1} | {specific_change_experienced} |
| {stakeholder_2} | {specific_change_experienced} |
| {stakeholder_3} | {specific_change_experienced} |

**Alignment with Core Mission:**

{how_cio_success_contributes_to_telos_technology_communications_safety_sections}

{connection_to_constitution_values_equity_excellence_empathy_learning_innovation_integrity}

**Major Initiatives (2-3):**

1. **{initiative_1}:** {brief_description_and_expected_outcome}
2. **{initiative_2}:** {brief_description_and_expected_outcome}
3. **{initiative_3}:** {brief_description_and_expected_outcome}

**What We Will NOT Do:**

- ❌ {strategic_exclusion_1} - *Reason:* {why_not}
- ❌ {strategic_exclusion_2} - *Reason:* {why_not}
- ❌ {strategic_exclusion_3} - *Reason:* {why_not}

**Biggest Barrier to Success:**

{primary_obstacle}

**What Needs to Be True:** {conditions_for_success}

**Resources/Support Needed:**

- {resource_1}: {why_needed}
- {resource_2}: {why_needed}
- {cross_department_dependency}: {what_required}

---

### {YEAR} Priority Goals

#### Goal 1: {outcome_statement_not_activity}

**Success Indicators:**

| Indicator | Current (Baseline) | Target (EOY {YEAR}) | Measurement Method |
|-----------|-------------------|---------------------|-------------------|
| {indicator_1} | {baseline_value} | {target_value} | {how_measured} |
| {indicator_2} | {baseline_value} | {target_value} | {how_measured} |
| {indicator_3} | {baseline_value} | {target_value} | {how_measured} |

**Key Actions:**

| Action/Project | Owner | Dependencies | Timeline |
|----------------|-------|--------------|----------|
| {action_1} | {person_name} | {teams_systems_resources} | {Q1_Q2_Q3_Q4} |
| {action_2} | {person_name} | {teams_systems_resources} | {Q1_Q2_Q3_Q4} |
| {action_3} | {person_name} | {teams_systems_resources} | {Q1_Q2_Q3_Q4} |

**Quarterly Milestones:**

- **Q1 (Mar 31):** {what_should_be_true}
- **Q2 (Jun 30):** {what_should_be_true}
- **Q3 (Sep 30):** {what_should_be_true}
- **Q4 (Dec 31):** {what_should_be_true}

**System/Habit Support (James Clear):**

{process_or_system_that_makes_this_goal_sustainable}

---

#### Goal 2: {outcome_statement}

[Repeat structure from Goal 1]

---

#### Goal 3: {outcome_statement}

[Repeat structure from Goal 1]

---

## Domain: Consulting/Speaking

[Repeat full domain structure: Review, Strategic Direction, Priority Goals]

---

## Domain: Product Development

[Repeat full domain structure: Review, Strategic Direction, Priority Goals]

---

## Domain: Real Estate Investing

[Repeat full domain structure: Review, Strategic Direction, Priority Goals]

---

## Domain: Financial Planning & Investing

[Repeat full domain structure: Review, Strategic Direction, Priority Goals]

**Ideal Lifestyle Costing (Tim Ferriss):**

| Ideal Lifestyle Element | Monthly Cost | Annual Cost |
|------------------------|--------------|-------------|
| {element_1} | ${cost} | ${annual} |
| {element_2} | ${cost} | ${annual} |
| **Total** | **${total_monthly}** | **${total_annual}** |

**Path to Ideal Lifestyle:**

{how_year_goals_move_toward_this_costed_vision}

---

## Cross-Domain Integration

### Portfolio Story for {YEAR}

**The Narrative:**

{synthesized_story_across_all_5_domains_what_is_the_overarching_theme_or_direction}

**Connection to 6-Year Vision:**

{how_this_year_advances_toward_retirement_transition_international_speaking_entrepreneurial_income}

---

### Trade-Offs & Prioritization

| Domain | Priority Level | Energy Allocation | Rationale |
|--------|----------------|-------------------|-----------|
| {CIO_Role} | {Primary/Secondary/Maintenance} | {percentage_or_description} | {why_this_level} |
| {Consulting_Speaking} | {Primary/Secondary/Maintenance} | {percentage_or_description} | {why_this_level} |
| {Product_Development} | {Primary/Secondary/Maintenance} | {percentage_or_description} | {why_this_level} |
| {Real_Estate} | {Primary/Secondary/Maintenance} | {percentage_or_description} | {why_this_level} |
| {Financial_Planning} | {Primary/Secondary/Maintenance} | {percentage_or_description} | {why_this_level} |

**Over-Commitment Risk:**

{where_youre_stretched_thin_and_need_to_make_trade_offs}

**Maintenance Mode Domain:**

{which_domain_if_any_gets_minimal_attention_this_year_and_why}

---

### Personal Board of Directors

| Name | Domain Expertise | What They Help With | Last Consulted | Next Consultation |
|------|-----------------|---------------------|----------------|-------------------|
| {advisor_1} | {domain} | {role_connector_futurist_accountability_sme} | {date} | {planned_date} |
| {advisor_2} | {domain} | {role} | {date} | {planned_date} |
| {advisor_3} | {domain} | {role} | {date} | {planned_date} |
| {advisor_4} | {domain} | {role} | {date} | {planned_date} |

**Gaps in Advisory Board:**

- Missing: {role_or_expertise_needed}
- Potential advisor: {person_to_recruit}

---

### Alignment Assessment

#### Strengths Leverage Analysis

**Input (Information Gathering):**
- Goals that leverage: {which_goals_create_opportunities_for_collecting_analyzing_archiving_information}
- Application: {how_input_strength_supports_success}

**Significance (Meaningful Impact):**
- Goals that leverage: {which_goals_create_visible_recognized_important_contributions}
- Application: {how_significance_strength_drives_motivation}

**Analytical (Evidence-Based Thinking):**
- Goals that leverage: {which_goals_require_data_proof_logical_reasoning}
- Application: {how_analytical_strength_ensures_rigor}

**Achiever (High Productivity):**
- Goals that leverage: {which_goals_benefit_from_relentless_work_ethic}
- Risk: {where_achiever_plus_type_3_could_lead_to_burnout}

**Learner (Continuous Growth):**
- Goals that leverage: {which_goals_create_mastery_opportunities}
- Application: {how_learner_strength_sustains_engagement}

#### Growth Edges & Risks

**Relationship Building (0% Blue - Blind Spot):**
- Goals requiring relationship focus: {which_goals_need_connection_collaboration_interpersonal_skills}
- Mitigation strategy: {how_youll_handle_this_gap_who_can_help}

**Type 3 Stress Pattern (Push Harder):**
- High-risk scenarios: {when_you_might_default_to_overwork_instead_of_strategic_pause}
- PAUSE triggers: {specific_signals_to_stop_and_assess_before_pushing_harder}
  - Trigger 1: {observable_signal}
  - Trigger 2: {observable_signal}
  - Response: {what_to_do_instead_of_pushing}

**Green-Orange Directness:**
- Potential friction points: {where_direct_communication_style_might_create_tension}
- Sensitivity checkpoint: {how_to_balance_candor_with_empathy}

---

### Overall Success Definition

**Mastery (Competence & Excellence):**

{how_year_goals_advance_expert_level_competence_in_key_domains}

**Legacy (Lasting Contribution):**

{how_year_goals_create_something_that_outlives_you_transforms_education_or_field}

**Freedom (Financial Independence):**

{how_year_goals_move_toward_entrepreneurial_income_retirement_security}

**Integration Check:**

{do_goals_balance_all_three_or_over_index_on_one_what_needs_adjustment}

---

## Potential Misalignments (If Any)

⚠️ **Flagged Concerns:**

- {goal_or_initiative_with_weak_connection_to_strategic_direction_or_mission}
- *Discussion needed:* {what_to_clarify_or_adjust}

---

## Next Steps

### Immediate Actions

- [ ] Review this document and finalize status (change to "Final" when approved)
- [ ] Share relevant sections with Personal Board of Directors advisors
- [ ] Schedule quarterly reviews in calendar:
  - Q1: March 31, {YEAR}
  - Q2: June 30, {YEAR}
  - Q3: September 30, {YEAR}
  - Q4: December 31, {YEAR}
- [ ] Create OmniFocus projects for all Priority Goals
- [ ] Schedule mid-year strategic adjustment session (July {YEAR})

### Quarterly Review Reminders

**Purpose:** Track progress, make adjustments, maintain alignment

**Format:** 15-20 min check-in per domain
- Progress status (on track / at risk / off track)
- Evidence vs. milestones
- What's working / what's stalled
- Adjustments for next quarter

**Links to Quarterly Reviews:**
- [[{YEAR}-Q1-Review|Q1 Review (Mar 31)]]
- [[{YEAR}-Q2-Review|Q2 Review (Jun 30)]]
- [[{YEAR}-Q3-Review|Q3 Review (Sep 30)]]
- [[{YEAR}-Q4-Review|Q4 Review (Dec 31)]]

---

## Appendix: Framework References

**James Clear (Systems > Goals):**
"You don't rise to the level of your goals, you fall to the level of your systems."

**Personal Board of Directors Roles:**
- **Connector:** Network access, introductions, reputation building
- **Accountability Partner:** Keeps commitments, challenges excuses
- **Futurist:** Trends, emerging opportunities, strategic foresight
- **Subject Matter Expert:** Deep domain expertise, technical guidance

**Life Map Domains (Alex Lieberman):**
- Career, Relationships, Health, Meaning, Finances, Fun

**Enneagram Type 3w4 (The Professional):**
- Core desire: Meaningful achievement through competence
- Growth: Integration to Type 6 (analytical, prepared)
- Stress: Type 3 → Type 9 (push harder, work more)

---

*Generated by Geoffrey Strategic Planning Manager v1.0.0*
*Last updated: {date}*
