---
name: clear-writing
description: Makes your writing clearer, stronger, and more professional. Use this skill when the user says "write clearly", "clear writing", "improve writing" or for ANY prose humans will read—documentation, commit messages, error messages, explanations, reports, or UI text.
---

# Writing Clearly and Concisely

## Overview

William Strunk Jr.'s _The Elements of Style_ (1918) teaches you to write clearly and cut ruthlessly.

## When to Use This Skill

Use this skill whenever you write prose for humans:

- Documentation, README files, technical explanations
- Commit messages, pull request descriptions
- Error messages, UI copy, help text, comments
- Reports, summaries, or any explanation
- Editing to improve clarity

**If you're writing sentences for a human to read, use this skill.**

## All Rules

### Elementary Rules of Usage (Grammar/Punctuation)

1. Form possessive singular by adding 's
2. Use comma after each term in series except last
3. Enclose parenthetic expressions between commas
4. Comma before conjunction introducing co-ordinate clause
5. Don't join independent clauses by comma
6. Don't break sentences in two
7. Participial phrase at beginning refers to grammatical subject

### Elementary Principles of Composition

8. One paragraph per topic
9. Begin paragraph with topic sentence
10. **Use active voice**
11. **Put statements in positive form**
12. **Use definite, specific, concrete language**
13. **Omit needless words**
14. Avoid succession of loose sentences
15. Express co-ordinate ideas in similar form
16. **Keep related words together**
17. Keep to one tense in summaries
18. **Place emphatic words at end of sentence**

### Custom rules

- Preserve every idea and fact unless clarity demands a change
- Keep paragraphs short (no more than three brief sentences)
- Vary sentence length to avoid monotony
- Replace jargon and complex words with plain, direct language; use contractions
- Remove clichés, filler adverbs, and stock metaphors (e.g., "navigate," "journey," "roadmap")
- Avoid bullet points unless essential for scan-ability
- Never add a summary or recap at the end—finish on a crisp, final line
- Do not use em dashes; use commas, periods, or rewrite as needed
- Add dry humor or an idiom if it fits, but never sound like an infomercial
- After rewriting, review and fix any sentence that still feels machine-made

