---
name: assignation-refere-communication-associe-selim-brihi
description: Rédaction d'assignations en référé devant le tribunal de commerce ou des activités économiques pour le droit de communication d'un associé. Utiliser ce skill quand l'utilisateur demande de rédiger, préparer ou créer une assignation en référé fondée sur l'article L. 238-1 du code de commerce pour obtenir la communication forcée de documents sociaux (comptes annuels, rapports de gestion, PV d'assemblées, etc.) lorsqu'un dirigeant refuse ou fait obstruction à la communication de ces documents à un associé.
metadata:
  author: Sélim Brihi
  license: AGPL-3.0
  version: 2026.01.23
---

# Assignation en Référé - Communication de Documents Sociaux (Article L. 238-1)

Ce skill guide la rédaction d'assignations en référé devant le président du tribunal de commerce ou des activités économiques lorsqu'un associé demande l'injonction de communication de documents sociaux sur le fondement de l'article L. 238-1 du code de commerce.

**Fondement unique** : Article L. 238-1 du code de commerce (ne pas utiliser l'article 145 du CPC).

## Conditions de l'action (article L. 238-1)

Pour que l'action soit recevable, 4 conditions doivent être réunies :

1. **Qualité d'associé** : Le demandeur est associé de la société (avec pourcentage de détention)
2. **Documents relevant du droit de communication** : Documents sociaux des 3 derniers exercices (rapport de gestion, inventaire, comptes annuels, texte des résolutions, rapports soumis aux AG, PV des AG)
3. **Demande visant personnellement le dirigeant** : La demande doit viser le gérant/président en sa qualité
4. **Obstruction caractérisée** : Refus ou communications parcellaires documentés

## Workflow de rédaction

### Phase 1 : Collecte des informations
Collecter toutes les informations nécessaires auprès de l'utilisateur. Consulter [workflow-informations.md](references/workflow-informations.md) pour :
- Les 12 questions types à poser
- Les informations à collecter sur les parties, la société, le litige, le contexte et la procédure
- Les pièces disponibles à inventorier

### Phase 2 : Rédaction de l'assignation
Rédiger l'assignation en suivant la structure en 5 parties. Consulter [structure-assignation.md](references/structure-assignation.md) pour le template complet :
1. En-tête
2. Avertissements obligatoires (article 861-2 CPC)
3. Corps : PLAISE AU PRESIDENT (Faits + Discussion)
4. Dispositif : PAR CES MOTIFS
5. Bordereau de pièces

### Phase 3 : Vérification et finalisation
Consulter [workflow-informations.md](references/workflow-informations.md) pour :
- Les points clés de rédaction (style, ton, chronologie)
- L'adaptation selon la forme sociale (SARL, SA, SAS, SNC)
- Les erreurs à éviter

### Phase 4 : Création du document
Créer le document final en format .docx et le présenter à l'utilisateur.

## Éléments essentiels à ne pas oublier

### Documents types à demander (SARL)
- Le rapport de gestion
- L'inventaire
- Les comptes annuels
- Le texte des résolutions proposées
- Les rapports soumis aux assemblées générales
- Les procès-verbaux des assemblées générales

### Paramètres d'astreinte habituels
- Montant : 1.000 à 2.000 euros par jour
- Durée : 60 jours
- Point de départ : "7 jours après la signification"

### Frais irrépétibles (article 700 CPC)
- Montant habituel : 5.000 euros

### Pièces indispensables
- Extrait Kbis de la société
- Statuts de la société
- Correspondances (RAR, emails) documentant les demandes
- Convocations aux AG avec documents incomplets
- Tout document prouvant l'obstruction

## Articles selon la forme sociale

| Forme | Article applicable |
|-------|-------------------|
| SARL | L. 223-26 |
| SA | L. 225-115 et suivants |
| SAS | L. 227-9 et L. 228-69 |
| SNC | L. 221-7 |

## Références détaillées

- **Structure de l'assignation** : Voir [structure-assignation.md](references/structure-assignation.md) pour le template complet des 5 parties (en-tête, avertissements, corps avec faits et discussion juridique, dispositif avec astreinte, bordereau de pièces)

- **Workflow et informations** : Voir [workflow-informations.md](references/workflow-informations.md) pour le workflow de rédaction en 9 étapes, les informations à collecter, les 12 questions types à poser, les points clés de rédaction, l'adaptation selon la forme sociale, les éléments contextuels renforceurs, et les erreurs à éviter
