# 🇩🇪 Germany — DSK Blacklist (Art. 35(4))

**Authority:** Datenschutzkonferenz (DSK) — Conference of Independent Federal and Länder Data Protection Supervisory Authorities.
**Document:** "Liste der Verarbeitungstätigkeiten, für die eine DSFA durchzuführen ist" (List of processing activities for which a DPIA is to be carried out).
**Official source:** datenschutzkonferenz-online.de (English version: 20181017_ah_DPIA_list_1_1__Germany_EN.pdf)
**Scope:** Private sector (unified list). Public sector lists may be issued separately by individual Länder DPAs (e.g., BfDI, LfDI Baden-Württemberg).
**EDPB consistency:** Submitted under Art. 35(4)/Art. 64(1)(a); subject to EDPB Opinion.
**Character:** Highly specific, technically detailed. Strong emphasis on employee data, professional secrecy, biometrics, and AI.

---

## Blacklist Entries

### 1. Large-scale processing of data subject to professional secrecy
Processing of data covered by Berufsgeheimnis (professional secrecy, §203 StGB): law firms, tax advisors, auditors, medical professionals, insolvency administrators, debt counseling services, pastoral care.

**Why it matters:** Unique to Germany. Creates a bridge between GDPR and the criminal liability regime under §203 StGB. A breach of professionally privileged data carries both GDPR sanctions and potential criminal prosecution. Private insolvency registers and debt counseling services are explicitly included.

**EDPB criteria:** 4 (sensitive/highly personal) + 5 (large scale).

### 2. Large-scale processing of data generated by smart devices for profiling
Wearables, smart home systems, IoT sensors, fitness trackers, voice assistants — when used for behavioral profiling or evaluation purposes.

**EDPB criteria:** 1 (scoring) + 3 (monitoring) + 5 (large scale) + 8 (innovative tech).

### 3. Large-scale processing of location/movement data for profiling or evaluation
Fleet management, GPS tracking of employees or customers, customer movement analysis in retail, geofencing.

**EDPB criteria:** 1 (scoring) + 3 (monitoring) + 4 (highly personal — location) + 5 (large scale).

### 4. Large-scale processing of telecommunication data
Metadata, traffic data, location data from telecommunications. Relevant for telecom providers, platforms analyzing communication patterns, and employers monitoring business phones.

**EDPB criteria:** 3 (monitoring) + 4 (highly personal) + 5 (large scale).

### 5. Employee monitoring via Data Loss Prevention (DLP) systems
Systems scanning emails, file transfers, USB usage, print jobs, or screen activity to detect data leakage. Explicitly named on the DSK list.

**EDPB criteria:** 3 (monitoring) + 7 (vulnerable — employees).

### 6. Fleet management / GPS tracking of employees
Vehicle tracking, route logging, driving behavior analysis, idle time monitoring. Explicitly named.

**EDPB criteria:** 3 (monitoring) + 4 (location data) + 7 (vulnerable — employees).

### 7. Biometric data for unique identification
Access control via fingerprint scanners, iris recognition, hand geometry. Also commercial uses: "pay by finger" in canteens, biometric authentication for services.

**Why it matters:** Reflects a strong cultural and legal aversion to biometric surveillance in Germany. The DSK covers both security (access control) and commercial (payment) uses.

**EDPB criteria:** 4 (Art. 9 sensitive) + 8 (innovative tech).

### 8. Genetic data processing
Medical applications: early disease detection, pharmacogenomics, clinical trials. Consumer applications: ancestry databases, direct-to-consumer genetic testing (e.g., 23andMe-type services).

**EDPB criteria:** 4 (Art. 9 sensitive) + 8 (innovative tech).

### 9. AI-based evaluation of personality or mood
Call center voice analysis, sentiment AI, emotion recognition from facial expressions or behavioral signals, personality assessment algorithms. Explicitly named.

**Why it matters:** Germany is one of the few Member States to explicitly call out AI-driven emotion/personality assessment on its blacklist. Directly relevant for HR tech, customer service optimization, and recruitment AI.

**EDPB criteria:** 1 (scoring) + 8 (innovative tech).

### 10. Comprehensive profiling based on third-party data
Credit scoring using external data sources (credit agencies, social media scraping), tenant screening, AML profiling incorporating purchased or scraped third-party data.

**EDPB criteria:** 1 (scoring) + 6 (matching datasets) + 9 (blocking rights).

### 11. Anonymization of special category data where re-identification risk exists
Processing that purports to anonymize Art. 9 data (health, genetic, biometric) but where re-identification remains technically feasible. Recognizes that "anonymized" health/genetic datasets may not meet the anonymization threshold.

**EDPB criteria:** 4 (sensitive) + 8 (innovative tech).

### 12. Whistleblowing systems
Internal reporting channels processing data relating to criminal offenses, professional misconduct, or compliance violations. Overlaps with EU Whistleblower Directive (2019/1937) implementation requirements.

**EDPB criteria:** 4 (Art. 10 criminal data) + 7 (vulnerable — employees/reporters).

---

## Key German-Specific Considerations

**§203 StGB — Professional Secrecy:**
Germany's criminal code imposes criminal liability for unauthorized disclosure of professionally privileged information (lawyers, doctors, tax advisors, auditors, social workers, etc.). This intersects with GDPR in two ways:
- A personal data breach involving §203-protected data triggers both GDPR notification obligations AND potential criminal exposure.
- Data processors (Auftragsverarbeiter) handling §203-protected data must comply with §203 StGB requirements in addition to Art. 28 GDPR.
- Since 2017 (§203(3) StGB reform), outsourcing to IT service providers is permitted but subject to strict contractual safeguards.

**Betriebsrat (Works Council) involvement:**
In Germany, employee monitoring measures typically require co-determination by the Works Council under §87(1) No. 6 BetrVG (works constitution act). The DPIA should document Works Council consultation and agreement.

**Länder-specific supplementary lists:**
Individual Länder DPAs may issue supplementary blacklists for public sector processing in their jurisdiction. The DSK list covers the private sector; controllers in the public sector should additionally check their Länder DPA's list.
