# 🇮🇪 Ireland — DPC Blacklist (Art. 35(4))

**Authority:** Data Protection Commission (DPC).
**Document:** "List of Types of Data Processing Operations which require a DPIA."
**Official source:** EDPB file: ie_dpc_data-protection-impact-assessment.pdf; DPC website.
**EDPB consistency:** Approved for cross-border situations. See also A&L Goodbody analysis (algoodbody.com).
**Character:** Strategically critical as the DPC is Lead Supervisory Authority for Meta, Google, Microsoft, Apple, TikTok, LinkedIn, and other major tech companies with EU headquarters in Ireland. List reflects digital platform economy processing patterns.

---

## Blacklist Entries

### 1. Large-scale processing of personal data for a new/different purpose
Data collected for one purpose, repurposed on a large scale for a different purpose not originally envisaged.

**Why it matters:** Directly targets data aggregation business models and ecosystem platforms combining data across services (e.g., combining social media activity, email, cloud storage, advertising data). This is the DPC's most distinctive blacklist entry.

**EDPB criteria:** 5 (large scale) + 6 (matching datasets).

### 2. Profiling vulnerable persons, including children, to target marketing or services
Behavioral profiling of children or other vulnerable data subjects for targeted advertising, content personalization, engagement optimization, or product recommendations.

**Why it matters:** Reflects the DPC's "Fundamentals for a Child-Oriented Approach to Data Processing" guidance. Covers targeted advertising directed at minors, engagement algorithms personalized for children, and edtech profiling.

**EDPB criteria:** 1 (scoring) + 7 (vulnerable — children).

### 3. Profiling or algorithmic determination of access to services
Algorithmic gatekeeping: content moderation algorithms banning users, credit scoring determining loan eligibility, insurance risk algorithms, platform trust-and-safety decisions affecting account status.

**EDPB criteria:** 1 (scoring) + 2 (automated decisions) + 9 (blocking rights).

### 4. Large-scale processing of children's data for non-service purposes
Data collected from children used for purposes beyond direct service provision: monetization, advertising, analytics, profiling, third-party sharing.

**EDPB criteria:** 5 (large scale) + 7 (vulnerable — children).

### 5. Tracking of individuals' location or behavior
Cross-site tracking, device fingerprinting, location-based advertising, WiFi/Bluetooth tracking, online behavioral profiling.

**EDPB criteria:** 3 (monitoring) + 4 (highly personal).

### 6. Biometric data for unique identification in services
Biometric login (Face ID, fingerprint), voice authentication, biometric payment in the context of providing services to users.

**EDPB criteria:** 4 (Art. 9 sensitive) + 8 (innovative tech).

### 7. Large-scale CCTV or drone surveillance
Aligns with Art. 35(3)(c). Large-scale video surveillance of public or semi-public areas.

**EDPB criteria:** 3 (monitoring) + 5 (large scale).

### 8. Systematic merging or matching of datasets from different sources
Data broker activities, marketing data enrichment, advertising data matching, combining CRM with purchased third-party data.

**EDPB criteria:** 6 (matching datasets).

### 9. Invisible processing
Processing where data subjects are not informed and would not reasonably expect it. WiFi tracking, Bluetooth beacons, ultrasonic cross-device tracking, ambient data collection.

**EDPB criteria:** 3 (monitoring). Transparency failure amplifies risk.

---

## Strategic Context

The DPC's list is particularly important for any organization whose processing is subject to the DPC's jurisdiction through the one-stop-shop mechanism (Art. 56 GDPR). This includes:

- Any company with its main EU establishment in Ireland
- Multi-national tech companies routing EU data protection compliance through Irish entities
- Any processor or controller whose Lead SA is the DPC

The DPC's enforcement approach to DPIAs has been tested in major decisions involving Instagram (children's data), WhatsApp (transparency), and Facebook (profiling for advertising). Controllers subject to DPC oversight should treat this blacklist as a minimum baseline.
