# 🇳🇱 Netherlands — AP Blacklist (Art. 35(4))

**Authority:** Autoriteit Persoonsgegevens (AP).
**Document:** "Besluit lijst verwerkingen persoonsgegevens waarvoor een gegevensbeschermingseffectbeoordeling (DPIA) verplicht is."
**Publication:** Staatscourant 2019, nr. 64418 (27 November 2019). Legal reference: BWBR0042812.
**Official source:** autoriteitpersoonsgegevens.nl/documenten/lijst-verplichte-dpia; wetten.overheid.nl/BWBR0042812.
**EDPB consistency:** EDPB Opinion 16/2018 under Art. 64(1)(a).
**Character:** Broad and detailed (17 entries). Strong emphasis on covert investigation, blacklists, employee monitoring, IoT, and behavioral influencing. Many entries require "large-scale" and/or "systematic monitoring" as qualifying conditions.

---

## Blacklist Entries

### 1. Covert investigation (heimelijk onderzoek)
Large-scale processing and/or systematic monitoring where data is collected without informing the data subject. Private detective agencies, fraud investigation, online enforcement (e.g., copyright), covert employer surveillance for theft/fraud.

**EDPB criteria:** 3 (monitoring) + 7 (vulnerable, if employees).

### 2. Blacklists (zwarte lijsten)
Processing of criminal conviction data, unlawful/nuisance behavior data, or poor payment behavior data that is shared with third parties. Insurance blacklists, hospitality industry warning lists, retail exclusion lists, telecom provider lists, employment agency lists.

**Why it matters:** The Netherlands explicitly targets the practice of inter-organizational blacklisting — a significant concern given the density of shared warning systems in Dutch financial and commercial sectors.

**EDPB criteria:** 4 (criminal/sensitive data) + 6 (matching datasets) + 9 (blocking rights).

### 3. Fraud prevention (fraudebestrijding)
Large-scale processing of special category data and/or systematic monitoring for fraud prevention. Social services fraud screening, insurance fraud departments.

**EDPB criteria:** 1 (scoring) + 4 (sensitive data) + 5 (large scale).

### 4. Credit scoring (creditscores)
Large-scale processing and/or systematic monitoring producing estimates of creditworthiness, expressed as credit scores.

**EDPB criteria:** 1 (scoring) + 2 (automated decisions) + 5 (large scale).

### 5. Financial situation (financiële situatie)
Large-scale processing and/or systematic monitoring of financial data revealing income, assets, or spending patterns. Bank statements, account balances, payment records, mobile/PIN payment data.

**EDPB criteria:** 4 (highly personal) + 5 (large scale).

### 6. Genetic data (genetische persoonsgegevens)
Large-scale processing and/or systematic monitoring of genetic data. DNA analysis, bio-databases, genetic profiling.

**EDPB criteria:** 4 (Art. 9 sensitive) + 5 (large scale).

### 7. Health data (gezondheidsgegevens)
Large-scale processing of health data by healthcare institutions, occupational health services (arbodiensten), reintegration companies, special educational institutions, insurers, research institutes. Includes electronic exchange of health data.

**Note:** Individual practitioners treating individual patients are typically exempt (not "large scale").

**EDPB criteria:** 4 (Art. 9 sensitive) + 5 (large scale).

### 8. Collaborative partnerships (samenwerkingsverbanden)
Sharing of personal data in partnerships where municipalities or authorities exchange special/sensitive data with other public or private parties. Data on health, addiction, poverty, debts, unemployment, social problems, criminal matters, youth care. Examples: neighborhood teams, safety houses (veiligheidshuizen), information hubs.

**Why it matters:** Unique to the Netherlands. Reflects the Dutch tradition of multi-agency collaboration (wijkteams, veiligheidshuizen) where sensitive data from health, social services, police, and municipal agencies is combined. These partnerships create significant profiling and discrimination risks.

**EDPB criteria:** 4 (sensitive data) + 6 (matching datasets) + 7 (vulnerable).

### 9. Camera surveillance (cameratoezicht)
Large-scale and/or systematic monitoring of publicly accessible areas with cameras, webcams, or drones.

**EDPB criteria:** 3 (monitoring) + 5 (large scale).

### 10. Flexible camera surveillance (flexibel cameratoezicht)
Large-scale and/or systematic use of body-worn cameras, helmet cameras (fire/ambulance personnel), dashcams by emergency services.

**Why it matters:** The Netherlands is one of few Member States to explicitly distinguish body-worn and vehicle-mounted cameras from fixed CCTV, recognizing their distinct risk profile (mobility, closer proximity, less predictability for data subjects).

**EDPB criteria:** 3 (monitoring) + 8 (innovative tech).

### 11. Employee monitoring (controle werknemers)
Large-scale and/or systematic monitoring of employee activities. Email and internet monitoring, network traffic logging, email scanning, GPS in company vehicles, camera surveillance for workplace theft/fraud.

**EDPB criteria:** 3 (monitoring) + 7 (vulnerable — employees).

### 12. Location data (locatiegegevens)
Large-scale and/or systematic monitoring of location data of natural persons. Car scanning, navigation systems, smartphones with GPS, public transport passenger location data, vehicle tracking.

**EDPB criteria:** 3 (monitoring) + 4 (highly personal — location) + 5 (large scale).

### 13. Communication data (communicatiegegevens)
Large-scale and/or systematic monitoring of communications data including metadata, unless strictly necessary for network/service integrity and security.

**EDPB criteria:** 3 (monitoring) + 4 (highly personal) + 5 (large scale).

### 14. Internet of Things (IoT)
Large-scale and/or systematic monitoring of data from internet-connected devices: smart TVs, smart home appliances, connected toys, smart city applications, smart energy meters, medical devices, wearables.

**EDPB criteria:** 3 (monitoring) + 4 (highly personal) + 8 (innovative tech).

### 15. Profiling (profilering)
Systematic and comprehensive evaluation of personal aspects based on automated processing (profiling). Assessments of professional performance, student performance, economic situation, health, preferences, reliability, behavior.

**EDPB criteria:** 1 (scoring) + 2 (automated decisions).

### 16. Observation and influencing of behavior (observatie en beïnvloeding van gedrag)
Large-scale processing involving systematic observation or influencing of behavior through automated processing, including data collected for online behavioral advertising.

**Why it matters:** Explicitly targets adtech and behavioral targeting — one of the few national blacklists to directly name online behavioral advertising as a DPIA trigger.

**EDPB criteria:** 1 (scoring) + 3 (monitoring) + 8 (innovative tech).

### 17. Biometric data (biometrische gegevens)
Large-scale and/or systematic processing of biometric data for identifying natural persons. Fingerprint recognition, facial recognition, iris scanning, voice recognition.

**Note:** Under Dutch implementation of GDPR (UAVG), biometric processing for unique identification is in principle prohibited. Processing is permitted only when strictly necessary for authentication or security purposes.

**EDPB criteria:** 4 (Art. 9 sensitive) + 5 (large scale).

---

## Key Dutch Considerations

**Samenwerkingsverbanden (collaborative partnerships):** The Dutch multi-agency collaboration model (wijkteams, veiligheidshuizen) is a distinctive feature. When advising on processing in the Netherlands, specifically ask whether data is shared between public and/or private parties in partnership structures — this is a common pattern that triggers a DPIA.

**Behavioral advertising:** Entry 16 explicitly names online behavioral advertising as a DPIA trigger. This is relevant for adtech companies, publishers using targeted advertising, and platforms processing behavioral data for ad personalization.

**Covert investigation:** Entry 1 covers not only employer investigations but also private detective agencies and online enforcement (e.g., copyright trolling). The key trigger is collecting data without the data subject's knowledge.

**The AP list is explicitly non-exhaustive:** Controllers must still assess whether their processing requires a DPIA even if not listed.
