# 🇵🇱 Poland — UODO Blacklist (Art. 35(4))

**Authority:** Prezes Urzędu Ochrony Danych Osobowych (UODO) — President of the Personal Data Protection Office.
**Scope:** 12 categories. Notable for strict cross-referencing of criteria — emphasizes that combined factors amplify risk.
**EDPB consistency:** Subject to EDPB Opinion under Art. 64(1)(a).
**Character:** Structured, criteria-focused. Strong coverage of employee monitoring, whistleblowing, children's data, and smart metering.

---

## Blacklist Entries

### 1. Evaluation/scoring including profiling with legal or significant effects
Automated evaluation systems, particularly for creditworthiness, insurance, employment suitability. Covers systems producing decisions that affect legal status or similarly significant interests.

**EDPB criteria:** 1 (scoring) + 2 (automated decisions).

### 2. Systematic monitoring of working time and employee activities
Email surveillance, internet browsing monitoring, physical entry/exit logging (when combined with performance evaluation), keycard tracking correlated with productivity metrics.

**Why it matters:** Similar to Germany's DSK list but explicitly includes physical access logging when it feeds into performance evaluation — the combination transforms neutral security logging into systematic employee surveillance.

**EDPB criteria:** 3 (monitoring) + 7 (vulnerable — employees).

### 3. Profiling based on data obtained from external sources
Data enrichment from third-party sources for profiling. Purchasing data from data brokers, scraping public profiles, combining marketing databases.

**EDPB criteria:** 1 (scoring) + 6 (matching datasets).

### 4. Biometric data for unique identification beyond employment law requirements
Biometric identification systems that go beyond what is legally mandated. If national law requires biometric verification for specific purposes, that specific use may not trigger this entry — but any broader biometric use does.

**EDPB criteria:** 4 (Art. 9 sensitive) + 8 (innovative tech).

### 5. Genetic data except narrow clinical use with explicit consent
Genetic data processing for any purpose beyond direct clinical care with the patient's explicit consent. Research, insurance, employment, consumer genomics, forensics.

**EDPB criteria:** 4 (Art. 9 sensitive).

### 6. Smart metering / IoT profiling of household behavior
Smart meters (electricity, gas, water) profiling household consumption patterns. Covers both utility-provided meters and consumer IoT devices tracking domestic activity.

**Why it matters:** Recognizes the privacy intrusion inherent in granular household consumption profiling — usage patterns can reveal occupancy, daily routines, number of occupants, and lifestyle habits.

**EDPB criteria:** 3 (monitoring) + 4 (highly personal) + 8 (innovative tech).

### 7. Whistleblowing systems
Internal reporting channels processing data relating to criminal convictions, offences, or professional misconduct. Covers both mandatory (EU Whistleblower Directive) and voluntary whistleblowing systems.

**Why it matters:** Poland explicitly flags whistleblowing — the risk profile includes potential reputational damage from false reports, processing of Art. 10 criminal data, and the vulnerability of both reporters and accused persons.

**EDPB criteria:** 4 (Art. 10 criminal data) + 7 (vulnerable).

### 8. Large-scale processing of children's data for marketing, profiling, or automated decisions
Edtech platforms, children's apps, social media directed at minors, targeted advertising to children, gamified data collection from minors.

**EDPB criteria:** 1 (scoring) + 5 (large scale) + 7 (vulnerable — children).

### 9. Systematic monitoring of publicly accessible areas on a large scale
Video/audio surveillance of public spaces. Aligns with Art. 35(3)(c).

**EDPB criteria:** 3 (monitoring) + 5 (large scale).

### 10. Large-scale processing of special category data for purposes other than individual healthcare
Health research databases, HR systems processing disability data, religious organization membership databases, political party membership processing.

**EDPB criteria:** 4 (Art. 9 sensitive) + 5 (large scale).

### 11. Processing preventing data subjects from exercising rights or using services
Algorithmic exclusion from services, automated credit refusals, platform bans based on profiling, insurance denial from automated assessment.

**EDPB criteria:** 2 (automated decisions) + 9 (blocking rights).

### 12. Cross-referencing or combining personal data from multiple controllers
Data sharing platforms, cooperative databases, industry data pools, joint marketing databases, multi-controller analytics.

**EDPB criteria:** 6 (matching datasets).
