# Official Sources and References

Authoritative documents underpinning this skill. Use for citations in DPIA reports and when users need to verify guidance against primary sources.

---

## Core Legal Framework

- **Article 35 GDPR** — EUR-Lex, legislation.gov.uk, gdpr-info.eu/art-35-gdpr/
- **Recitals 84, 89–96 GDPR** — Rationale for DPIA, high-risk factors, connection to DPbD/DPbDf, prior consultation
- **Article 36 GDPR** — Prior consultation where DPIA indicates high residual risk
- **Articles 24, 25, 32 GDPR** — Accountability, DPbD/DPbDf, security (DPIA demonstrates compliance)
- **Article 83(4)(a) GDPR** — Fines for Art. 35 infringement: up to €10M or 2% global turnover

## Central EDPB/WP29 Guidance

- **WP 248 rev.01** — "Guidelines on DPIA and determining whether processing is 'likely to result in a high risk'" (4 April 2017, revised 4 October 2017). EC Newsroom doc_id=47711. The central EU-level DPIA guidance establishing the 9 criteria, two-criteria rule, and Annex 2 (criteria for acceptable DPIA).
- **EDPB Endorsement 1/2018** — Confirms WP29 documents remain valid as EDPB Guidelines.

## EDPB Opinions on National Lists (Art. 64(1)(a))

22 Opinions on Art. 35(4) blacklists from national SAs:
- Opinion 7/2018 (Greece), Opinion 18/2018 (Portugal), Opinion 20/2018 (Sweden), Opinion 24/2018 (Denmark), Opinion 2/2019 (Norway), Opinion 3/2018 (Bulgaria), Opinion 6/2019 (Slovakia), and others.
- **Opinion 7/2020** — On CNIL Art. 35(5) whitelist (the most detailed EDPB analysis of DPIA exemptions).

Key principles from the Opinions:
- National lists further specify Art. 35(1); they are **not exhaustive**
- Lists must acknowledge WP 248 rev.01
- EDPB identified "core" processing types that should appear on all blacklists for consistency

EDPB Register of Decisions (consistency mechanism) indexes all Opinions and national lists: edpb.europa.eu/our-work-tools/consistency-findings/register-decisions

## EDPB Subject-Specific Guidance

- **EDPB Opinion 28/2024** (December 2024) — AI models and GDPR. Dual-phase DPIA (training + deployment), anonymization challenge, legitimate interest for scraping.
- **EDPB Guidelines 1/2024** — Legitimate interest (Art. 6(1)(f)). Relevant for LIA integration in DPIA, especially data scraping for AI training.
- **EDPB Guidelines 3/2019** — Video surveillance. Biometric threshold (CCTV vs. FRT), Art. 9 implications.
- **EDPB Guidelines 1/2020** — Connected vehicles. Privacy by design, edge computing recommendation, data categories in vehicles.
- **EDPB 2025 Guidelines on Pseudonymisation** — Pseudonymization as risk reducer, technical requirements for effectiveness.
- **EDPB 2023 Coordinated Enforcement Action Report** — Cloud computing in public sector, Schrems II transfer risks in DPIAs.

## EDPS Material (EU Institutions — Reg. 2018/1725)

- **EDPS Decision on DPIA list** — Processing operations subject to DPIA for EU institutions (Art. 39 of Reg. 2018/1725). Annex 1 contains criteria aligned with WP 248.
- **EDPS DPIA template** — Annex 6 of the Accountability Toolkit. Useful as a model structure.
- Source: edps.europa.eu/data-protection-impact-assessment-dpia_en

## European Commission

- **"When is a DPIA required?"** — Plain-language guidance. commission.europa.eu/law/law-topic/data-protection/rules-business-and-organisations/obligations/when-data-protection-impact-assessment-dpia-required_en

## National SA Lists — Official Sources

### Blacklists (Art. 35(4))
| Jurisdiction | Authority | Official Source |
|-------------|-----------|-----------------|
| 🇩🇪 Germany | DSK | datenschutzkonferenz-online.de — 20181017_ah_DPIA_list_1_1__Germany_EN.pdf |
| 🇫🇷 France | CNIL | cnil.fr/fr/guidelines-dpia; Journal Officiel publication; EDPB file: list_of_processing_operations_for_which_dpia_is_required_fr.pdf |
| 🇮🇪 Ireland | DPC | EDPB file: ie_dpc_data-protection-impact-assessment.pdf |
| 🇧🇪 Belgium | APD/GBA | EDPB file: be_list_of_the_types_of_processing_operations_for_which_a_dpia_shall_be_required.pdf |
| 🇵🇱 Poland | UODO | UODO website |
| 🇳🇱 Netherlands | AP | "DPIA-lijst" — autoriteitpersoonsgegevens.nl |
| 🇮🇹 Italy | Garante | Delibera n. 467, 11 October 2018 |
| 🇪🇸 Spain | AEPD | aepd.es/documento/listas-dpia-es-35-4.pdf (ES), listas-dpia-en-35-4.pdf (EN) |
| 🇫🇮 Finland | Tietosuojavaltuutettu | tietosuoja.fi/en/list-of-processing-operations-which-require-dpia |
| 🇭🇺 Hungary | NAIH | naih.hu/data-protection/gdpr-35-4-mandatory-dpia-list |
| 🇬🇷 Greece | HDPA | dpa.gr — article_35_dpia_list_en.pdf |
| 🇱🇹 Lithuania | VDAI | EDPB Register of Decisions |
| 🇬🇧 UK (comparative) | ICO | ico.org.uk — DPIA guidance (UK GDPR, based on WP 248) |

### Whitelists (Art. 35(5))
| Jurisdiction | Authority | Key Reference |
|-------------|-----------|---------------|
| 🇫🇷 France | CNIL | EDPB Opinion 7/2020 |
| 🇨🇿 Czech Republic | UOOU | EDPB Opinion 11/2019 |
| 🇪🇸 Spain | AEPD | EDPB Opinion 12/2019 |
| 🇦🇹 Austria | DSB | DPIA-EO (Datenschutz-Folgenabschätzung-Ausnahmenverordnung) |

**Coverage note:** At least 22 EEA SAs have adopted Art. 35(4) blacklists including Austria, Belgium, Bulgaria, Czech Republic, Estonia, Finland, France, Germany, Greece, Hungary, Ireland, Italy, Latvia, Lithuania, Malta, Netherlands, Poland, Portugal, Romania, Slovakia, Sweden, UK (pre-Brexit), plus Norway (EEA). For jurisdictions without a dedicated file in this skill, check the national SA website or the EDPB Register of Decisions.

## CNIL PIA Methodology Toolkit

- **PIA 1 — Methodology:** cnil.fr/sites/cnil/files/atoms/files/cnil-pia-1-en-methodology.pdf
- **PIA 2 — Knowledge Bases:** Templates and risk/measure libraries
- **PIA 3 — Case Studies:** Worked examples
- **PIA Software Tool:** Open-source, github.com/LINCnil/pia

## EU AI Act Interplay

- **EU AI Act** (Regulation 2024/1689) — Fundamental Rights Impact Assessment (FRIA) for high-risk AI systems
- **EDPB/EDPS Joint Opinion** — DPIA and FRIA are distinct but complementary; integration recommended to avoid duplication
- DPIA covers data protection; FRIA covers broader rights (non-discrimination, environment, democracy)
