# Additional EU Jurisdictions — Quick Reference

## Table of Contents
1. [Austria](#austria)
2. [Italy](#italy)
3. [Spain](#spain)
4. [Netherlands](#netherlands)
5. [Belgium](#belgium)
6. [Ireland](#ireland)
7. [UK (post-Brexit)](#uk-post-brexit)

For each jurisdiction: key national specifics only. Combine with EU_COMMON.md for full picture.

---

## Austria

| Aspect | Detail |
|--------|--------|
| **National Law** | DSG (Datenschutzgesetz) |
| **SA** | Datenschutzbehörde (DSB), Barichgasse 40-42, 1030 Wien |
| **Language** | German ("Datenschutzerklärung") |
| **Children's Age** | 14 years (§ 4(4) DSG) |
| **DPO Threshold** | GDPR Art. 37 — no additional national threshold |
| **Cookie Law** | § 165 TKG 2021 (Telekommunikationsgesetz) |
| **Retention (tax)** | 7 years (§ 132 BAO) |
| **Specifics** | Criminal conviction data: only by official authority or supervised by official authority. Media privilege in § 9 DSG. |

## Italy

| Aspect | Detail |
|--------|--------|
| **National Law** | D.lgs. 196/2003 (Codice Privacy) as amended by D.lgs. 101/2018 |
| **SA** | Garante per la protezione dei dati personali |
| **Language** | Italian ("Informativa sulla privacy" or "Informativa sul trattamento dei dati personali") |
| **Children's Age** | 14 years (Art. 2-quinquies) |
| **Cookie Law** | Garante's Cookie Guidelines (June 2021, updated 2022); "Linee guida cookie e altri strumenti di tracciamento" |
| **Retention (tax)** | 10 years for accounting (Art. 2220 Codice Civile) |
| **Specifics** | Art. 2-ter: public interest processing requires specific legal basis. Art. 2-sexies: special categories processing requires substantial public interest. Marketing: opt-in for email (D.lgs. 196/2003 Art. 130), soft opt-in for existing customers. |

## Spain

| Aspect | Detail |
|--------|--------|
| **National Law** | LOPDGDD (Ley Orgánica 3/2018) |
| **SA** | AEPD (Agencia Española de Protección de Datos) + regional: APDCAT (Catalonia), AVPD (Basque Country), CTPDA (Andalusia) |
| **Language** | Spanish ("Política de privacidad"). Regional languages may be required (Catalan, Basque, Galician) |
| **Children's Age** | 14 years (Art. 7 LOPDGDD) |
| **Cookie Law** | LSSI (Ley 34/2002) Art. 22; AEPD cookie guide |
| **Retention (tax)** | 4 years tax (Ley General Tributaria Art. 66), 6 years accounting (Código de Comercio Art. 30) |
| **Specifics** | Art. 12 LOPDGDD: "Right to digital disconnection" for employees. Art. 89: right of rectification on the internet. Art. 93-94: digital rights including right to be forgotten in search engines, digital education. Whistleblower channel data: specific regime under Ley 2/2023. |

## Netherlands

| Aspect | Detail |
|--------|--------|
| **National Law** | UAVG (Uitvoeringswet AVG) |
| **SA** | Autoriteit Persoonsgegevens (AP) |
| **Language** | Dutch ("Privacyverklaring"). English acceptable for international services. |
| **Children's Age** | 16 years (default GDPR) |
| **Cookie Law** | Telecommunicatiewet Art. 11.7a |
| **Specifics** | BSN (Burgerservicenummer) processing heavily restricted (Art. 46 UAVG). AP aggressive enforcement on cookies (significant fines). Consent must be freely given — no cookie walls (AP guidance). |

## Belgium

| Aspect | Detail |
|--------|--------|
| **National Law** | Loi du 30 juillet 2018 (Wet van 30 juli 2018) |
| **SA** | Autorité de protection des données (APD) / Gegevensbeschermingsautoriteit (GBA) |
| **Language** | French AND/OR Dutch AND/OR German depending on target audience region |
| **Children's Age** | 13 years (Art. 7) |
| **Specifics** | Litigation Chamber has been active with sanctions. Direct marketing: Code of Economic Law provisions apply alongside GDPR. |

## Ireland

| Aspect | Detail |
|--------|--------|
| **National Law** | Data Protection Act 2018 |
| **SA** | Data Protection Commission (DPC) — Lead SA for many US tech multinationals |
| **Language** | English (Irish optional) |
| **Children's Age** | 16 years (Sec. 31 DPA 2018) |
| **Specifics** | DPC's Fundamentals for a Child-Oriented Approach to Data Processing. Major enforcement actions against Meta, TikTok, etc. as Lead SA. ePrivacy: SI 336/2011 implements cookie consent. |

## UK (post-Brexit)

| Aspect | Detail |
|--------|--------|
| **National Law** | UK GDPR + Data Protection Act 2018 |
| **SA** | ICO (Information Commissioner's Office) |
| **Language** | English |
| **Children's Age** | 13 years (DPA 2018 Sec. 9) |
| **Transfer from EU** | EU adequacy decision for UK (June 2021, extended — check current status) |
| **Transfer from UK** | UK adequacy regulations; UK IDTA (International Data Transfer Agreement) replaces SCCs |
| **Cookie Law** | PECR (Privacy and Electronic Communications Regulations 2003) |
| **Specifics** | Age Appropriate Design Code (Children's Code) — mandatory for online services likely accessed by children. ICO "legitimate interest" guidance is influential. UK divergence from EU GDPR is ongoing — always verify current state. Post-DPDI Bill / Data Protection and Digital Information Act — check implementation status. |

---

> **NOTE**: This file covers the most commonly needed jurisdictions. For other EU/EEA Member States, apply GDPR defaults from EU_COMMON.md and research specific national supplementary laws.
