---
name: legal-simulation-patrick-munro
description: "Framework for demonstrating AI capabilities in legal contexts. Provides detailed personas across tenant law, business contracts, startup disputes, employment claims, and consumer protection with progressive complexity scenarios. Use when: (1) Demonstrating AI-powered legal triage or intake systems, (2) Showcasing responsible AI-assisted client interactions, (3) Training staff on appropriate AI use in legal contexts, (4) Creating realistic scenarios for legal tech presentations, (5) Developing educational materials about AI in legal services, or (6) Testing AI-powered legal information systems in controlled environments."
metadata:
  author: Patrick Munro
  license: AGPL-3.0
  version: 2026.01.12
---

# Legal Persona Simulator

## Overview
Realistic simulation framework for demonstrating how AI can assist with legal information needs while respecting professional boundaries and data protection principles. Provides detailed personas across multiple legal contexts (tenant law, business law, startups, employment, consumer protection) with progressive complexity scenarios for showcasing AI-assisted legal triage, information gathering, and appropriate escalation to qualified attorneys.

## CRITICAL LEGAL DISCLAIMER
**THIS SKILL IS FOR DEMONSTRATION AND EDUCATIONAL PURPOSES ONLY. IT DOES NOT PROVIDE LEGAL ADVICE.**

**IMPORTANT - READ CAREFULLY:**
- This skill simulates interactions to demonstrate AI capabilities in legal contexts
- Outputs are fictional scenarios for demonstration, training, or educational purposes only
- This skill does NOT create attorney-client relationships
- This skill does NOT provide legal advice, opinions, or recommendations on actual legal matters
- This skill does NOT substitute for consultation with qualified, licensed attorneys
- Legal rights, obligations, and remedies vary significantly by jurisdiction
- Only licensed attorneys can provide legal advice for specific situations
- Reliance on simulated scenarios for actual legal decisions may result in serious harm

**Users must:**
- Consult qualified, licensed attorneys for all actual legal matters
- Never use simulated content as legal advice for real situations  
- Understand that AI cannot replace professional legal judgment
- Recognize that laws vary by jurisdiction and change over time
- Seek appropriate legal representation before taking any legal action
- Verify all legal information independently with qualified counsel

**Neither the skill creator nor Claude/Anthropic:**
- Provides legal advice or creates attorney-client relationships
- Makes any representation about legal rights or obligations
- Assumes any liability for reliance on simulated scenarios
- Endorses any specific legal positions or strategies

**Data Protection Notice**: While this skill demonstrates GDPR-compliant interaction patterns, users collecting actual personal data must implement proper data protection measures under applicable law and consult with qualified privacy/data protection counsel.

## When to Use This Skill
Use this skill when you need to:
- Demonstrate AI capabilities in legal information contexts (presentations, training, proof-of-concepts)
- Showcase responsible AI-assisted legal triage and intake processes
- Illustrate GDPR-compliant client interaction patterns for legal services
- Create realistic scenarios for legal technology demonstrations
- Train staff on appropriate AI use in legal contexts
- Develop educational materials about AI in legal services
- Test AI-powered legal information systems in controlled environments

**NOT for**: Actual legal consultations, providing legal advice, or replacing qualified legal professionals

## Core Capabilities

### 1. Five Detailed Personas with Legal Contexts

#### Persona 1: Residential Tenant (Entry-Level Complexity)
**Background**
- Name: Sarah Weber
- Age: 28
- Occupation: Marketing coordinator
- Location: Urban apartment, 2-year lease
- Situation: Landlord refusing to return security deposit after move-out despite clean inspection

**Legal Context**
- Residential tenancy law (jurisdiction-dependent)
- Security deposit regulations
- Landlord-tenant dispute resolution
- Small claims court procedures

**Complexity Level**: Low
- Clear legal framework with consumer protections
- Standardized dispute resolution processes
- Often resolved without litigation
- Strong tenant protection laws in many jurisdictions

**Demonstration Scenarios**
1. Information gathering on security deposit rights
2. Template demand letter preparation
3. Small claims court process explanation
4. Timeline and procedural guidance
5. Evidence collection recommendations

**AI Value Demonstration**: Rapid information access, document template generation, procedure explanation, appropriate attorney referral

#### Persona 2: Small Business Owner (Medium Complexity)
**Background**
- Name: Marcus Chen
- Age: 35
- Business: Independent café/bakery
- Employees: 5
- Situation: Supplier breach of contract (late deliveries causing inventory shortages and lost revenue)

**Legal Context**
- Commercial contract law
- Breach of contract remedies
- Business damages calculation
- Supplier relationship management

**Complexity Level**: Medium
- Commercial law frameworks apply
- Negotiation often preferred over litigation
- Damages calculation requires business analysis
- Relationship preservation considerations

**Demonstration Scenarios**
1. Contract review and breach analysis
2. Damages calculation frameworks
3. Negotiation strategy development
4. Breach notification letter drafting
5. Alternative dispute resolution options

**AI Value Demonstration**: Contract analysis, damages estimation, negotiation guidance, escalation path mapping

#### Persona 3: Startup Founder (High Complexity)
**Background**
- Name: Lisa Kowalski
- Age: 31
- Company: SaaS startup (15 employees, Series A funding)
- Situation: Co-founder equity dispute and potential IP ownership conflict

**Legal Context**
- Corporate governance
- Shareholder agreements
- Intellectual property ownership
- Equity and vesting disputes
- Fiduciary duties

**Complexity Level**: High
- Complex corporate and IP law intersection
- Significant financial stakes
- Multiple legal specializations required
- Investor and board considerations

**Demonstration Scenarios**
1. Corporate governance structure review
2. Equity vesting and acceleration analysis
3. IP assignment agreement evaluation
4. Negotiation frameworks for founder disputes
5. Mediation vs. litigation analysis

**AI Value Demonstration**: Multi-jurisdictional analysis, stakeholder impact assessment, resolution option comparison, specialist attorney matching

#### Persona 4: HR Manager (Medium-High Complexity)
**Background**
- Name: Thomas Bauer
- Age: 42
- Company: Mid-sized manufacturing company (250 employees)
- Situation: Employee claiming wrongful termination and discrimination

**Legal Context**
- Employment law
- Discrimination and harassment law
- Wrongful termination claims
- Litigation risk assessment
- Settlement negotiations

**Complexity Level**: Medium-High
- Heavily regulated area with significant penalties
- Evidence gathering and documentation critical
- Reputational risk alongside legal risk
- Insurance and settlement considerations

**Demonstration Scenarios**
1. Employment law compliance review
2. Termination documentation analysis
3. Discrimination claim risk assessment
4. Settlement framework development
5. Litigation cost-benefit analysis

**AI Value Demonstration**: Compliance gap analysis, risk scoring, documentation review, settlement range estimation, employment law specialist referral

#### Persona 5: Consumer with Defective Product (Entry-Medium Complexity)
**Background**
- Name: David Martinez
- Age: 38
- Purchase: Defective appliance (€1,200 smart refrigerator)
- Situation: Manufacturer refusing warranty repair, retailer denying responsibility

**Legal Context**
- Consumer protection law
- Product warranty and guarantee rights
- Manufacturer vs. retailer liability
- Regulatory complaint processes

**Complexity Level**: Entry-Medium
- Strong consumer protection frameworks in many jurisdictions
- Clear statutory rights in EU (2-year guarantee)
- Regulatory authorities available for complaints
- Usually resolved through administrative channels

**Demonstration Scenarios**
1. Consumer rights information (legal guarantee vs. commercial warranty)
2. Liability allocation (manufacturer vs. retailer)
3. Regulatory complaint procedures
4. Escalation strategies
5. Evidence preservation guidance

**AI Value Demonstration**: Consumer rights explanation, multi-party liability analysis, regulatory pathway guidance, evidence collection

**Enhanced Feature**: Persona variation generator - creates modified versions of each persona with different complicating factors (cross-border elements, time limitations, concurrent legal issues, varying jurisdictional frameworks).

### 2. GDPR-Compliant Interaction Pattern

Demonstrates responsible data handling in legal contexts:

**Initial Intake (Minimal Data Collection)**
- Collect only information necessary to understand legal issue
- Explain purpose of data collection clearly
- Avoid collecting sensitive data (race, health, political opinions) unless absolutely essential
- Use anonymization where possible (e.g., "Client A" instead of names in examples)

**Data Minimization Demonstration**
- AI asks only relevant questions, skipping unnecessary personal details
- Redaction of identifying information in document analysis
- Compartmentalization of sensitive information
- Time-limited data retention simulation

**Transparency and Consent**
- Clear explanation of how information will be used
- Explicit consent for data processing
- Rights explanation (access, correction, deletion, portability)
- Easy withdrawal mechanisms

**Security and Confidentiality**
- Discussion of encryption and secure transmission
- Access controls for sensitive information
- Breach notification procedures
- Professional confidentiality obligations

**Enhanced Feature**: GDPR compliance checklist generator - creates data protection impact assessment frameworks for legal service AI implementations, identifying risks and mitigation measures.

### 3. Progressive Complexity Scenarios

Each persona includes 3-5 scenarios that increase in complexity:

**Level 1: Information Provision**
- AI provides factual legal information
- Explains general legal principles and procedures
- Identifies potentially applicable laws and regulations
- Clarifies terminology and concepts
- *No legal advice provided, purely informational*

**Level 2: Document Analysis**
- AI reviews contracts, leases, or other legal documents
- Identifies key provisions and potential issues
- Flags concerning clauses or omissions
- Suggests questions to ask attorney
- *Analysis only, not legal advice on what to do*

**Level 3: Options Exploration**
- AI presents multiple legal pathways (negotiation, mediation, litigation)
- Explains pros/cons of each approach
- Identifies typical timelines and costs
- Discusses risk factors for each option
- *Decision-making remains with user and their attorney*

**Level 4: Strategy Frameworks**
- AI helps organize evidence and documentation
- Develops negotiation position frameworks
- Creates timeline and procedural roadmaps
- Generates discussion points for attorney consultation
- *Frameworks only, implementation requires attorney*

**Level 5: Attorney Matching and Referral**
- AI identifies type of legal specialist needed
- Explains what to look for in attorney selection
- Suggests questions to ask during initial consultation
- Discusses fee structures and engagement models
- *Clear transition to human professional required*

**Enhanced Feature**: Complexity escalation triggers - automatic detection of when AI simulation should escalate to attorney referral based on factors like monetary value, legal complexity, time sensitivity, or jurisdictional uncertainty.

### 4. Demonstration Use Case Templates

**Presentation/Demo Format**
"Let me show you how AI can assist someone facing [legal issue]. I'll demonstrate the interaction pattern, information gathering, and appropriate boundaries..."

**Training Format**
"This scenario illustrates best practices for AI-assisted legal triage. Notice how the AI [specific behavior]. This demonstrates [key principle]..."

**Educational Format**
"Legal AI systems must balance accessibility with professional boundaries. This example shows how to [demonstrate concept] while ensuring [compliance/ethical requirement]..."

**Proof-of-Concept Format**
"Our AI system handles this [persona scenario] by [capability demonstration]. The value proposition includes [time savings/cost reduction/accessibility improvement] while maintaining [quality/compliance/ethics]..."

**Enhanced Feature**: Presentation builder - automatically generates slide decks, demonstration scripts, and talking points for showcasing AI legal assistance capabilities to different audiences (legal professionals, business stakeholders, technology teams, regulatory authorities).

### 5. Appropriate Escalation Frameworks

Demonstrates when and how to transition from AI assistance to human professionals:

**Automatic Escalation Triggers**
- High monetary value (e.g., >€10,000 at stake)
- Criminal law matters
- Complex litigation strategy
- Time-sensitive filing deadlines
- Jurisdictional uncertainty
- Conflicting legal authority
- Novel legal questions
- Ethical dilemmas

**Warning Sign Detection**
- Statute of limitations concerns
- Evidence spoliation risks
- Adverse party represented by counsel
- Regulatory investigation
- Multiple legal domains intersecting
- Client unable to articulate facts clearly
- Emotional distress affecting judgment

**Attorney Referral Best Practices**
- Identify practice area specialization needed
- Explain initial consultation process
- Discuss fee structures and engagement letters
- Prepare documentation for attorney review
- Set realistic expectations for legal process
- Emphasize importance of timely action

**Enhanced Feature**: Attorney matching criteria generator - creates detailed specialist profiles for different legal issues, including practice area, experience level, jurisdictional licensing, language capabilities, and industry knowledge requirements.

### 6. Multi-Jurisdictional Awareness

Demonstrates handling of jurisdictional complexity:

**Jurisdiction Identification**
- Ask location/jurisdiction early in interaction
- Explain why jurisdiction matters
- Flag cross-border or multi-jurisdictional issues
- Identify applicable legal systems (common law vs. civil law)

**Jurisdictional Limitations**
- Clearly state when AI cannot provide jurisdiction-specific information
- Recommend local attorney consultation for jurisdiction-specific questions
- Avoid overgeneralizing from one jurisdiction to another
- Flag when US/UK law principles don't apply to EU/other jurisdictions

**EU-Specific Considerations**
- Consumer protection directives (2-year guarantee, unfair contract terms)
- Employment law frameworks (works councils, termination protections)
- Data protection (GDPR) compliance requirements
- Alternative dispute resolution (ODR platform for consumer disputes)

**Enhanced Feature**: Jurisdictional conflict identifier - detects when legal issue involves multiple jurisdictions and explains choice of law and forum selection considerations.

### 7. Ethical Boundary Demonstration

Shows how AI maintains ethical boundaries in legal contexts:

**Unauthorized Practice of Law (UPL) Avoidance**
- Never characterizes AI output as "legal advice"
- Always recommends attorney consultation for decisions
- Avoids predicting case outcomes
- Doesn't interpret statutes or case law for specific situations
- Frames all output as general information only

**Confidentiality Considerations**
- Discusses attorney-client privilege and its limitations
- Explains why AI interactions may not be privileged
- Recommends secure communication channels
- Warns about disclosure risks in online interactions

**Conflict of Interest Awareness**
- Explains why AI cannot represent both parties in dispute
- Identifies potential conflicts in multi-party situations
- Recommends separate representation where appropriate

**Competence and Diligence**
- AI clearly states its limitations and uncertainty
- Recommends verification of all information with attorney
- Flags when issues exceed AI's capabilities
- Emphasizes importance of current, jurisdiction-specific legal research

**Enhanced Feature**: Ethical boundary checker - analyzes AI responses to ensure they don't cross into legal advice, maintain appropriate disclaimers, and clearly distinguish information from recommendations.

## Best Practices for Demonstrations

1. **Set Context Clearly**: Always explain that scenarios are simulations for demonstration purposes only

2. **Emphasize Boundaries**: Repeatedly clarify the distinction between legal information and legal advice

3. **Show the Transition**: Demonstrate smooth handoff from AI to human attorney at appropriate points

4. **Highlight Value Add**: Focus on time savings, accessibility, cost reduction, and process improvement

5. **Address Concerns**: Proactively discuss limitations, risks, and mitigation strategies

6. **Use Realistic Details**: Scenarios should be plausible and relatable while avoiding actual client information

7. **Vary Complexity**: Demonstrate AI capabilities across simple to complex scenarios

8. **Show Data Protection**: Explicitly model GDPR-compliant information handling

9. **Explain the "Why"**: Articulate reasoning behind AI responses and escalation decisions

10. **Invite Questions**: Encourage audience engagement and address concerns transparently

**Enhanced Feature**: Demonstration quality assessment rubric - evaluates whether simulated interactions appropriately balance accessibility with professional boundaries, maintain ethical guardrails, and demonstrate clear value proposition.

## Limitations and Disclaimers

**This skill does NOT:**
- Provide legal advice for actual legal situations
- Create attorney-client relationships or professional obligations
- Replace consultation with qualified, licensed attorneys
- Account for jurisdiction-specific laws, regulations, or procedures
- Interpret statutes, case law, or regulations for specific cases
- Predict legal outcomes or litigation results
- Fulfill any legal compliance obligations
- Constitute authorized practice of law in any jurisdiction

**Users must:**
- Use simulations for demonstration and educational purposes only
- Never rely on simulated scenarios for actual legal decisions
- Consult qualified attorneys for all real legal matters
- Verify all legal information with licensed professionals
- Understand that laws vary by jurisdiction and change frequently
- Recognize that AI cannot exercise legal judgment
- Obtain appropriate legal representation before taking legal action
- Implement proper data protection measures for actual client data

**Professional Responsibility**: Legal professionals using this skill for demonstrations must comply with their applicable rules of professional conduct regarding advertising, client communications, unauthorized practice of law, and technology competence requirements.

**Data Protection**: While this skill models GDPR-compliant patterns, actual implementation of legal AI systems requires comprehensive data protection impact assessments, security measures, and compliance with applicable privacy laws. Consult qualified data protection officers and privacy counsel.

**Regulatory Variation**: Legal service delivery regulations vary significantly by jurisdiction. Some jurisdictions prohibit or heavily regulate non-lawyer involvement in legal services. Always verify compliance with applicable regulations before implementing AI-assisted legal services.

## Example Use Cases

1. **Law Firm Innovation Team**: Demonstrating AI-powered client intake and triage system to partners
2. **Legal Tech Startup**: Showcasing product capabilities to potential investors or customers
3. **Corporate Legal Department**: Training non-lawyer staff on appropriate AI use for legal questions
4. **Legal Education**: Teaching law students about AI in legal practice and professional boundaries
5. **Access to Justice Initiative**: Demonstrating how AI can improve legal information accessibility
6. **Regulatory Presentation**: Showing compliance-focused AI implementation to bar association or regulatory authority

## Scenario Customization Guide

To adapt personas for specific demonstration needs:

**Industry Customization**
- Modify business contexts (tech, manufacturing, retail, etc.)
- Adjust legal issues to industry-specific concerns
- Include industry-specific regulations where relevant

**Jurisdictional Customization**
- Specify applicable jurisdiction clearly
- Reference jurisdiction-specific laws and procedures
- Flag cross-border elements if demonstrating international capability

**Complexity Customization**
- Add complicating factors for more sophisticated audiences
- Simplify scenarios for general public demonstrations
- Layer multiple legal issues for comprehensive demos

**Audience Customization**
- Legal professionals: Emphasize technical accuracy and boundary management
- Business stakeholders: Focus on efficiency and cost savings
- Technology teams: Highlight integration and system capabilities
- Regulators: Demonstrate compliance and consumer protection

---

**FINAL REMINDER**: This skill creates fictional scenarios for demonstration purposes only. It does NOT provide legal advice, create attorney-client relationships, or substitute for qualified legal counsel. All legal matters require consultation with licensed attorneys. Neither the skill creator nor Claude/Anthropic assumes any liability for reliance on simulated scenarios for actual legal decisions.

**For Actual Legal Matters**: Consult qualified, licensed attorneys in your jurisdiction. Do not use simulated scenarios as the basis for legal action or decisions. Legal rights and obligations vary significantly by jurisdiction and individual circumstances.
