# Duration & Scope (Term, Survival, Territory)

This reference focuses on time, scope, and trigger mechanics. Keep analysis jurisdiction-agnostic: describe business impact and propose balanced language.

## Contents
- Term vs. survival
- Territory / cross-border considerations
- Scope of affiliates and corporate changes
- Retroactive coverage
- Trade secrets (practical handling)

## 1) Term vs. survival

### Definitions
- **Term:** how long the agreement governs disclosures (the “relationship window”).
- **Survival period:** how long confidentiality obligations continue after the Term ends.

### What to check
- When does the Term start? (Effective date vs. first disclosure.)
- Does the NDA cover disclosures made before signature?
- Is there a clear survival period?

### Recipient red flags
- Survival is perpetual for all information.
- Survival is unclear or tied to “until information becomes public” with no carve-outs.

### Balanced approach
- Fixed survival for ordinary confidential info.
- Longer survival for narrowly defined trade secrets.

**Suggested language**
```
This Agreement begins on the Effective Date and continues for [12–24] months (the “Term”). Confidentiality obligations survive for [2–5] years after expiration or termination, except for Trade Secrets (if any), which remain protected for so long as they remain trade secrets.
```

## 2) Territory / cross-border considerations

Commercial NDAs often include:
- A governing law / venue clause (legal).
- Practical cross-border sharing concerns (operational).

### What to check (operational)
- Will Confidential Information be accessed from multiple countries?
- Are cloud systems distributed globally?
- Does NDA require storage “only in [country]”?

### Recipient red flags
- Data residency commitments you cannot meet.

**Suggested approach**
- Avoid strict residency promises unless you have a dedicated compliant environment.
- Instead, commit to reasonable safeguards and access controls.

> **Personal data callout:** NDAs are not a substitute for data protection terms when personal data is involved. Treat separately.

## 3) Scope of affiliates and corporate changes

### What to check
- Are affiliates allowed to receive disclosures? (If needed.)
- Does “affiliate” include future acquisitions?
- Assignment clause: can obligations transfer on merger or asset sale?

### Recipient red flags
- Prohibits assignment even in change of control, risking breach in acquisition.

**Suggested language**
```
Either party may assign this Agreement in connection with a merger, acquisition, or sale of substantially all assets, provided the assignee assumes the obligations herein.
```

## 4) Retroactive coverage

### What to check
- Does NDA cover info disclosed before signing?

**Common fix**
```
This Agreement also applies to Confidential Information disclosed within [30–90] days prior to the Effective Date.
```

## 5) Trade secrets (jurisdiction-agnostic handling)

### Why it matters
Trade secret concepts exist in many legal systems but definitions vary. Avoid making legal determinations; instead:
- Ask whether information is actually treated as secret.
- Ask what measures exist to keep it secret.

**Practical checklist**
- [ ] Is the information limited-access internally?
- [ ] Is it labeled/handled as confidential?
- [ ] Is it stored with access controls?

> **M&A / Due diligence:** “trade secret” labels may be used broadly. Focus on feasibility of compliance and proportionality.
