# Party Obligations (Recipient vs Discloser)

This module helps you map obligations to the correct party and spot hidden risk shifts.

## Contents
- Recipient obligations
- Discloser obligations
- Mutual NDAs (out of scope)
- Operational feasibility checklist
- Non-solicit / no-contact / standstill
- Publicity and announcements

## 1) Recipient obligations (most common)

### Core obligations
- Non-disclosure: don’t disclose except as permitted.
- Use restriction: only use for the stated Purpose.
- Standard of care: protect using reasonable care (or same-as-own standard).
- Control of Representatives: limit internal/external sharing to need-to-know.

### Representative handling
**What to check**
- Are “Representatives” defined (employees, contractors, affiliates, advisors)?
- Are affiliates included? Sometimes you need them for evaluation.
- Is Recipient strictly liable for any representative breach?

**Recipient red flags**
- Unlimited liability for representatives even when not under Recipient’s control.
- Representatives include “any person” but with no “need-to-know” limitation.

**Balanced redline**
```
Recipient may disclose Confidential Information to its Representatives who have a need to know for the Purpose and are bound by confidentiality obligations at least as protective as this Agreement. Recipient is responsible for its Representatives’ compliance to the extent it has control over such Representatives.
```

## 2) Discloser obligations (often missing)

Even in unilateral NDAs, Discloser may have obligations:
- Ensure they have the right to disclose (no third-party restrictions).
- Mark or identify confidential information (depending on definition).
- Provide information “as-is” (common) — check disclaimers.

**Recipient watch-outs**
- Discloser disclaims all responsibility for accuracy while Recipient relies on it.
- NDA includes broad non-reliance language that is inconsistent with deal process.

> **M&A / Due diligence:** non-reliance clauses may be acceptable early, but confirm alignment with later transaction documents.

## 3) Mutual NDAs (two-way flow) — out of scope

This skill is designed for **one-way (unilateral)** NDAs. If the NDA is mutual, stop and escalate or use a separate mutual-NDA review playbook.

## 4) Operational feasibility checklist (Recipient)

- [ ] Can we comply with notice requirements (e.g., breach notice, compelled disclosure notice)?
- [ ] Can we restrict access in practice (shared tools, email, ticketing systems)?
- [ ] Can we return/destroy as drafted (backups, retention policies, legal holds)?
- [ ] Do we need the ability to disclose to auditors, regulators, or insurers?

## 5) Non-solicit / no-contact / standstill (hidden in NDAs)

These provisions are not purely “confidentiality” and can be high impact.

### What to check
- Any restriction on contacting Discloser’s employees/customers/suppliers.
- Standstill provisions (common in investor contexts).

### Recipient position
- Separate them into their own agreement or narrow heavily.

> **Investor / VC variation:** standstill and no-solicit may be intentionally requested; treat as business decision and escalate.

## 6) Publicity and announcements

### What to check
- Does NDA prohibit referencing the relationship?
- Does it allow required disclosures (e.g., to investors, auditors) under confidentiality?

**Balanced redline**
```
Neither party will issue public statements about the discussions without the other party’s prior written consent, except as required by law or to professional advisors under confidentiality.
```
