# Remedies & Liability (Risk Allocation)

This module focuses on the commercial downside if something goes wrong.

## Contents
- Equitable relief / injunctive relief
- Attorneys’ fees / fee shifting
- Damages categories
- Liability caps
- Indemnities
- Non-reliance / disclaimer of warranties
- Liquidated damages / penalties
- Dispute resolution

## 1) Equitable relief / injunctive relief

### What to check
- Does NDA state that breach causes irreparable harm and entitles Discloser to injunctive relief?
- Is it one-way or mutual?
- Does it waive bond requirements or create automatic entitlement?

### Recipient red flags
- Automatic injunctive relief + fee shifting + broad confidentiality definition.

### Balanced redline
```
The parties acknowledge that unauthorized disclosure may cause harm for which monetary damages may be inadequate and that equitable relief may be appropriate, subject to applicable law and equitable principles.
```

## 2) Attorneys’ fees / fee shifting

### What to check
- One-way fees (“Recipient pays Discloser’s fees”).
- Trigger is too broad (“any dispute” vs “prevailing party”).

### Recipient position
- Prefer each party bears its own fees.
- If unavoidable, use “prevailing party” and limit scope.

**Suggested language**
```
Each party will bear its own attorneys’ fees and costs, except as a court of competent jurisdiction may award under applicable law.
```

## 3) Damages categories (direct / indirect)

### What to check
- Exclusion of consequential, incidental, special damages.
- Whether lost profits are excluded.

### Recipient red flags
- Unlimited consequential damages for any breach.

### Balanced approach
- Exclude indirect categories while preserving direct damages.

**Suggested language**
```
Neither party will be liable for any indirect, incidental, consequential, special, or punitive damages arising out of this Agreement.
```

## 4) Liability caps

### What to check
- Is there a cap? If yes, what is it tied to (fees paid, fixed amount)?
- Does the NDA carve out confidentiality breaches from the cap (common discloser ask)?

### Recipient position
- Avoid unlimited exposure.
- If Discloser insists on carve-out, narrow it (e.g., intentional breach only).

**Suggested language**
```
Each party’s aggregate liability arising out of this Agreement will not exceed [X]. This limitation does not apply to a party’s willful misconduct or intentional breach.
```

## 5) Indemnities

### What to check
- Any obligation for Recipient to indemnify Discloser for breach.
- Third-party claim indemnities.

### Recipient red flags
- Broad indemnity for “any losses” resulting from breach.

### Typical negotiation stance
- Remove indemnity; rely on direct damages.
- If must keep: narrow to third-party claims caused by Recipient’s willful misconduct.

## 6) Non-reliance / disclaimer of warranties

### What to check
- Discloser disclaims accuracy/completeness.
- Recipient agrees it will not rely on information.

### Practical guidance
- In early-stage discussions this may be acceptable.
- If Recipient must rely (e.g., diligence), ensure alignment with later transaction documents.

> **M&A / Due diligence:** NDA non-reliance clauses often sit alongside separate reliance/representation terms later.

## 7) Liquidated damages / penalties

### What to check
- Fixed penalties for breach.

### Recipient red flags
- Penalties disconnected from harm.

### Suggested approach
- Prefer actual damages + equitable relief rather than preset penalties.

## 8) Dispute resolution (arbitration, venue)

Even jurisdiction-agnostic playbooks should flag business impact:
- Travel / language burdens.
- Confidentiality of proceedings.
- Interim relief availability.

**Checklist**
- [ ] Is the forum practical?
- [ ] Are interim measures allowed?
- [ ] Are proceedings confidential?
