# Standard Exceptions (Carve-outs) to Confidentiality

Most workable NDAs include clear exceptions. Missing or unworkable exceptions are a common negotiation driver.

## Contents
- The five standard carve-outs
- Suggested clause
- Burden of proof
- Compelled disclosure carve-out
- Residuals are not an exception
- Personal data and regulatory disclosures

## 1) The five standard carve-outs

| Exception | Meaning | Common drafting pitfall |
|---|---|---|
| Public domain | Already public through no fault of Recipient | Defines “public” too narrowly |
| Prior knowledge | Recipient already knew before disclosure | Requires unrealistic proof |
| Third-party right | Recipient receives from a third party without restriction | Assumes third party had rights |
| Independent development | Recipient developed without using Discloser’s info | No evidence standard |
| Compelled disclosure | Required by law/regulator/court | Notice deadlines too strict |

## 2) Suggested clause (balanced)

```
Confidential Information does not include information that Recipient can demonstrate: (a) is or becomes publicly available through no breach of this Agreement; (b) was lawfully known to Recipient prior to disclosure; (c) is lawfully received from a third party without breach of any obligation of confidentiality; or (d) is independently developed by Recipient without use of or reference to Confidential Information.
```

## 3) Burden of proof

### What to check
- Who must “prove” an exception?

### Balanced approach
- “Recipient can demonstrate” is typical.
- Avoid “contemporaneous written records only” unless necessary.

**Recipient-friendly tweak**
```
Recipient may demonstrate an exception using reasonable evidence, which may include (where appropriate) documentation, system records, or credible testimony.
```

## 4) Compelled disclosure carve-out

**Suggested language**
```
If Recipient is required by law, regulation, or court order to disclose Confidential Information, Recipient may disclose only the portion legally required and will (to the extent legally permitted) provide prompt notice to Discloser and reasonably cooperate in seeking protective treatment.
```

## 5) Residuals are not an “exception”

Residuals clauses often function like an exception by permitting use of retained information. Treat them as separate (see KEY_CLAUSES.md).

## 6) Personal data and regulatory disclosures

If personal data is involved, parties sometimes try to treat privacy compliance as an “exception” to confidentiality.

### Practical guidance
- Confidentiality and privacy can coexist.
- Ensure NDA does not prevent mandatory notices or compliance.

> **Employment / contractor variation:** carve-outs may be narrowed in employment contexts; ensure practicality and compliance with workplace obligations.
