# Voice Characteristics & Selection Guide

## Voice Profiles

### bm_george (DEFAULT)
- **Accent:** British male, RP (Received Pronunciation)
- **Tone:** Distinguished, authoritative, warm
- **Best for:** Narration, explanations, formal content, reading essays
- **Speed sweet spot:** 0.9-1.0 (natural cadence)
- **Character:** Think BBC Radio 4 presenter

### af_heart
- **Accent:** American female, neutral/warm
- **Tone:** Friendly, approachable, conversational
- **Best for:** Casual content, greetings, conversational text, encouragement
- **Speed sweet spot:** 1.0-1.1
- **Character:** Think podcast host, inviting and clear

### am_adam
- **Accent:** American male, deep
- **Tone:** Steady, grounded, serious
- **Best for:** Technical content, warnings, important announcements
- **Speed sweet spot:** 0.9-1.0 (deeper voices benefit from slower pace)
- **Character:** Think documentary narrator

### bf_emma
- **Accent:** British female, elegant
- **Tone:** Refined, articulate, poised
- **Best for:** Poetry, literary content, polished presentations
- **Speed sweet spot:** 0.9-1.0
- **Character:** Think audiobook narrator for literary fiction

## Selection Decision Guide

| Content Type | Recommended Voice | Speed |
|-------------|-------------------|-------|
| Technical explanation | `bm_george` or `am_adam` | 0.9 |
| Casual message | `af_heart` | 1.0 |
| Poetry / literary | `bf_emma` | 0.85 |
| Alert / warning | `am_adam` | 0.9 |
| Long-form narration | `bm_george` | 1.0 |
| Upbeat / motivational | `af_heart` | 1.1 |

## Speed Guidelines

| Speed | Effect | Use When |
|-------|--------|----------|
| 0.8 | Slow, dramatic | Poetry, emphasis, solemn content |
| 0.9 | Measured | Dense technical content, deep voices |
| 1.0 | Natural | Default for most content |
| 1.1 | Brisk | Light conversational content |
| 1.2 | Fast | Skimming, quick updates |
| 1.3+ | Very fast | Not recommended (clarity drops) |

## Text Preparation Tips

- Break long text into logical paragraphs for natural pauses
- Avoid special characters and markdown syntax (stripped but can cause odd pauses)
- Spell out abbreviations if pronunciation matters ("API" -> "A P I")
- Use punctuation to control pacing: commas for short pauses, periods for longer ones
- Parenthetical content often sounds awkward -- rewrite as separate sentences
