# Concept Forge

**Transform nebulous ideas into sharp, testable frameworks through dialectical interrogation.**

## Overview

Concept Forge takes vague intuitions and half-formed ideas through a systematic development process using multi-archetype interrogation. It challenges rather than affirms, revealing structure through pressure and building through dialectic.

## Key Features

- Eight-stage concept development (Intuition through Communication)
- Multiple interrogation modes: Socratic, multi-archetype, adversarial
- Concept differentiation from existing frameworks
- Falsifiability testing and operationalization
- Communication artifact generation

## Usage

Trigger with phrases like:
- "Explore this idea"
- "Think through X"
- "Challenge my thinking"
- "Help me develop this concept"

## Installation

### Claude Code
```bash
cp -r /path/to/AISkills/ConceptForge/concept-forge ~/.claude/skills/
```

### Claude Web Chat
Upload the `.skill` file from `dist/` to claude.ai > Settings > Capabilities.

## Files

```
concept-forge/
├── SKILL.md        # Core skill definition
├── README.md       # This file
└── references/     # Development stages, interrogation archetypes
```

## Part of [AISkills](https://github.com/leegonzales/AISkills)
