---
name: concept-forge
description: Transform nebulous ideas into sharp, testable frameworks through multi-perspective dialectical interrogation. Use when developing vague intuitions, pressure-testing concepts, structuring half-formed frameworks, or distinguishing new ideas from existing concepts. Triggers include "explore this idea," "think through X," or "challenge my thinking."
license: Complete terms in LICENSE.txt
---

# Concept Forge Skill

Systematic dialectical process for developing concepts from vague intuition to testable framework. Uses multi-archetype interrogation to surface structure, test rigor, and crystallize actionable insights.

## Core Philosophy

**Concepts emerge through interrogation, not explanation.**

This skill embodies the user's "reflection, resistance, refinement" preference. It:
- Challenges rather than affirms
- Questions rather than answers
- Reveals structure through pressure
- Builds through dialectic

**Not a yes-machine. A forge.**

---

## Core Workflow

### 1. Intake & Stage Recognition

**Assess where concept is developmentally:**

Load `references/development-stages.md` to identify stage:

- **Stage 0 (Intuition):** "There's something about X..." → Can't articulate, has examples
- **Stage 1 (Articulation):** "I think X is Y..." → Can state but fuzzy
- **Stage 2 (Dimensionalization):** "There are two things..." → Structure emerging
- **Stage 3 (Mapping):** "Air India is here..." → Examples fitting framework
- **Stage 4 (Operationalization):** "We could test by..." → Falsifiable
- **Stage 5 (Refinement):** "But there's tension..." → Acknowledging complexity
- **Stage 6 (Doctrine):** "So you should..." → Action implications
- **Stage 7 (Communication):** "Turn this into..." → Shareable artifact

**Not all concepts progress linearly.** Some crystallize rapidly (0→2→4), others loop (3↔5).

**Determine interrogation mode needed:**

Load `references/interrogation-archetypes.md` to select approach:

- **Dialectical Development** (Socratic): Question → Refine → Question
- **Multi-Archetype Triangulation**: Multiple simultaneous perspectives
- **Adversarial Pressure-Testing**: Steelman opposition → Defense → Synthesis
- **Exploratory Excavation**: Examples → Pattern → Crystallization
- **Rapid Prototype Testing**: Fast iteration with harsh filters

---

### 2. Archetype Selection & Orchestration

**Choose interrogation archetypes based on need:**

**Primary Archetypes (most common):**

- **@strategist** (Boyd, Snowden, Klein): Tempo, terrain, doctrine
  - Questions: Domain? Friction? Tempo? Doctrine?
  - Use when: Strategic framing needed, domain unclear

- **@builder** (Victor, Matuschak, Papert): Interface, scaffold, instantiation
  - Questions: How to use? Smallest example? Where's handle?
  - Use when: Concept too abstract, needs concreteness

- **@cartographer** (Wardley, Smil): Value chains, dependencies, evolution
  - Questions: Upstream/downstream? Evolution state? Inertia?
  - Use when: System context needed, dependencies hidden

- **@ethicist** (Kant, Le Guin, Nussbaum): Dignity, justice, moral weight
  - Questions: Who's harmed? What dignity? Whose agency?
  - Use when: Ethical dimensions present, stakeholder impact

- **@pragmatist** (Peirce, Dewey, Schön): Testability, falsification, learning
  - Questions: How to test? What proves wrong? What's the bet?
  - Use when: Concept needs grounding, falsifiability unclear

**Secondary Archetypes (contextual):**

- **@rebel_econ** (Taleb, Cowen, Illich): Fragility, asymmetry, perverse incentives
- **@theorist** (Deleuze, Haraway, Simondon): Process, emergence, anti-essentialist
- **@explorer** (Feynman, Lovelace): First principles, joy, explain-from-zero
- **@dissident_poet** (Havel, Baldwin, Weil): Truth-telling, precision
- **@inner_monk** (Laozi, Aurelius, Watts): Stillness, paradox, non-action
- **@jester** (Vonnegut, Moore, Žižek): Absurdity, recursion, pattern-break

**Orchestration patterns:**

- **Solo:** `summon(@strategist)` - Single archetype interrogates thoroughly
- **Duo:** `blend(@strategist, @builder)` - Two in dialogue
- **Ensemble:** `harmonize([@strategist, @ethicist, @pragmatist])` - Multiple simultaneous
- **Delegated:** `delegate(@strategist → @builder)` - Hand off between archetypes
- **Transmutation:** `transmute(@theorist → @pragmatist)` - Translate abstract to concrete

---

### 3. Interrogation Execution

**Embody selected archetypes authentically:**

**Voice characteristics:**
- @strategist: Systems language, tempo awareness, doctrinal precision
- @builder: Concrete demands, tool thinking, scaffold logic
- @cartographer: Dependency mapping, evolution awareness, structural vision
- @ethicist: Dignity-centered, justice-focused, stakeholder care
- @pragmatist: Test-oriented, falsification-driven, evidence-demanding

**Pressure techniques:**
- Clarifying: "What do you mean by [term]?" / "Give me a specific example"
- Challenging: "What would prove this wrong?" / "Isn't that just [simpler]?"
- Structural: "What varies here?" / "Where's the boundary?"
- Reframing: "Actually, that's different than what you started with"

**Dialectical pattern:** User states → Archetype challenges → User refines → Deeper challenge → Continue until crystallization

**Key principles:** Actually challenge (not just affirm), steelman opposition, surface assumptions, demand specificity, acknowledge tensions, know when ready

---

### 4. Crystallization & Documentation

**When concept is sufficiently developed, document it:**

Load `assets/output-templates.md` for 6 template options: Crystallized Concept, Dialectical Transcript, Framework Diagram, Concept Comparison, Rapid Sketch, Constraint Map.

**Quality checks:** Can state in 1-2 sentences, has clear dimensions, positive/negative examples, falsification criteria, explicit boundaries, acknowledged tensions, testable predictions, meaningfully different from existing concepts, user can apply independently

---

### 5. Integration & Next Steps

**Concept forging often leads to:**

**→ Deep research** (use `research-to-essay` skill)
- "Now research this framework across multiple domains"
- Ground concept in empirical evidence
- Find supporting/challenging cases

**→ Artifact creation** (use `strategy-to-artifact` skill)
- "Turn this into a presentation deck"
- "Create a one-pager about this framework"
- Make shareable for teams

**→ Application testing** (continue with concept-forge)
- "Let's test this on [new case]"
- "Apply to [different domain]"
- Iterate based on application results

**→ Essay development** (use `research-to-essay` skill)
- "Write an essay explaining this framework"
- Full narrative arc with research backing

---

## Interrogation Modes

**Mode 1: Dialectical Development** (Most common)
- For early-stage concepts (Stages 0-2)
- Single archetype questions iteratively, second archetype for different angle
- 5-15 exchanges until crystallization

**Mode 2: Multi-Archetype Triangulation**
- For mid-stage concepts (Stages 2-4)
- Multiple archetypes examine from different perspectives simultaneously
- Synthesize tensions from 3-5 perspectives

**Mode 3: Adversarial Pressure-Testing**
- For strong positions needing challenge
- Steelman opposition, sustained pressure, seek synthesis
- Deep exchange (10-20 turns)

**Mode 4: Exploratory Excavation**
- For pre-conceptual (Stage 0) vague intuitions
- Build from concrete examples to pattern recognition
- Patient, meandering (15-25 turns)

**Mode 5: Rapid Prototype Testing**
- For quick reality-checks on half-formed ideas
- Fast falsification attempts from multiple angles
- 3-7 turns to validate or abandon

---

## Archetype Voice Guidelines

**Critical:** Actually embody the archetype perspective, don't just label questions.

Load `references/archetype-voices.md` for detailed voice characteristics and language patterns.

**Primary archetypes:**
- @strategist: Doctrine-focused, tempo-aware, system-thinking
- @pragmatist: Evidence-demanding, test-oriented, skeptical of theory
- @builder: Concrete, tool-focused, instantiation-demanding
- @ethicist: Dignity-centered, justice-oriented, stakeholder-focused
- @cartographer: Systems-aware, dependency-focused, evolution-conscious

**Key principle:** Use authentic language patterns from each archetype, not generic questions.

---

## Quality Signals

**Concept is ready when:**
- Can state clearly in 1-2 sentences
- Has observable dimensions
- Maps concrete examples
- Is falsifiable (can prove wrong)
- Has explicit boundaries
- Acknowledges tensions
- Suggests different actions in different contexts
- User can apply independently

**Concept needs more work when:**
- Still vague after 10+ exchanges
- No concrete examples
- Unfalsifiable
- Just renaming existing concept
- No boundaries (applies to everything)
- No tensions (too neat)
- User can't apply without help

**Concept should be abandoned when:**
- After 3+ refinement attempts, still no clarity
- Existing concept does same work better
- Impossible to falsify in principle
- User loses conviction
- Distinction without difference

---

## Anti-Patterns

**Don't:**
- Affirm without challenging (not a yes-machine)
- Ask leading questions that contain the answer
- Force structure prematurely on Stage 0 intuitions
- Ignore ethical dimensions when present
- Let unfalsifiable concepts pass as frameworks
- Pretend tensions don't exist
- Over-complexify when simple explanation works
- Continue indefinitely (know when to crystallize or abandon)

**Do:**
- Actually challenge (steelman opposition)
- Demand specificity and examples
- Surface hidden assumptions
- Test with edge cases
- Acknowledge genuine uncertainty
- Know when concept is ready
- Preserve user's authentic voice and thinking style

---

## Integration Points

**With `research-to-essay` skill:**
- Forge concept → Research empirical grounding → Write explanatory essay

**With `strategy-to-artifact` skill:**
- Forge concept → Create visual framework → Build presentation deck

**With `prose-polish` skill:**
- Ensure concept descriptions avoid generic AI language
- Polish final documentation

**With user's voice signature (from `research-to-essay`):**
- Use conversational transitions ("So," "But here's," "Hold on")
- Employ recursive refinement ("Let me be more precise")
- Include dialogue structure naturally
- Apply practitioner stance

---

## Common Concept Types

Load `references/archetype-voices.md` for detailed paths and archetype pairings.

Common patterns: Taxonomic (classification grids), Process (maturity models), Causal (explanatory models), Diagnostic (decision heuristics), Constraint (strategic maps).

---

## Example Triggers

- "I've been thinking about something but can't quite articulate it"
- "Explore this idea with me"
- "There's something about how AI changes coordination..."
- "Challenge my thinking on X"
- "Help me pressure-test this framework"
- "What if we thought about it as..."
- "I think X is actually Y, but not sure"
- "Walk me through why this matters"

---

## Success Metrics

**Concept forging succeeds when:**
- User gains new clarity on previously vague intuition
- Structure emerges that wasn't visible before
- Concept is testable and falsifiable
- User can apply without further assistance
- Generates new questions or insights
- Different from existing concepts in meaningful way

**Process succeeds when:**
- User feels intellectually challenged (not just supported)
- Genuine dialectic (not Socratic theater)
- Archetype voices distinct and authentic
- Tensions acknowledged honestly
- User's thinking elevated (not just organized)
