# Concept Forge Output Templates

Standard formats for crystallized concepts at different stages.

## Template 1: Crystallized Concept Document

Use for: Mature concepts ready for application

```markdown
# [CONCEPT NAME]

**One-sentence statement:** [Core idea in 1-2 sentences]

---

## The Intuition

[How this concept emerged—the initial observation or puzzle]

[2-3 sentences setting context]

---

## Core Structure

### Dimensions

**[Dimension 1 Name]:** [Clear definition]
- Low end: [Description]
- High end: [Description]

**[Dimension 2 Name]:** [Clear definition]
- Low end: [Description]
- High end: [Description]

**[Optional: Dimension 3]**

### Resulting Zones/States

[If 2D grid:]

|                | Low [Dim1]     | High [Dim1]    |
|----------------|----------------|----------------|
| **High [Dim2]**| [Zone A characteristics] | [Zone B characteristics] |
| **Low [Dim2]** | [Zone C characteristics] | [Zone D characteristics] |

[Or if categorical/sequential:]

1. **[State/Type A]:** [Characteristics]
2. **[State/Type B]:** [Characteristics]
3. **[State/Type C]:** [Characteristics]

---

## Examples

### Positive Examples (Concept Applies)

**Example 1: [Name]**
- Context: [Brief setup]
- Position: [Where in framework]
- Outcome: [What happened]
- Why it fits: [Explanation]

**Example 2: [Name]**
- [Same structure]

**Example 3: [Name]**
- [Same structure]

### Negative Examples (Concept Doesn't Apply)

**Counterexample 1: [Name]**
- Why it doesn't fit: [Explanation]
- What it actually is: [Alternative framing]

---

## Boundaries

**This concept applies when:**
- [Condition 1]
- [Condition 2]
- [Condition 3]

**This concept does NOT apply when:**
- [Condition 1]
- [Condition 2]
- [Condition 3]

---

## Falsification Criteria

**This concept would be proven wrong if:**
1. [Testable condition]
2. [Testable condition]
3. [Testable condition]

**How to test:**
- [Minimal experiment or observation]
- [Expected result if concept is valid]
- [Expected result if concept is invalid]

---

## Tensions & Tradeoffs

**Unresolved tensions:**
- [Tension 1]: [Description]
- [Tension 2]: [Description]

**Inherent tradeoffs:**
- [Tradeoff 1]: [Explanation]
- [Tradeoff 2]: [Explanation]

**Alternative views:**
- [Alternative framework]: [How it differs, what it emphasizes]

---

## Doctrine (What To Do)

### When in [Zone/State A]:
→ [Recommended action]
→ [What to avoid]

### When in [Zone/State B]:
→ [Recommended action]
→ [What to avoid]

### Movement Strategies:
**To move from A → B:**
- [Required infrastructure or action]
- [Typical timeline]
- [Success indicators]

---

## Open Questions

[What remains unclear or untested about this concept]

1. [Question 1]
2. [Question 2]
3. [Question 3]

---

## Related Concepts

- **[Related Concept 1]:** [Relationship - similar, subset, prerequisite, etc.]
- **[Related Concept 2]:** [Relationship]

---

**Created:** [Date]  
**Version:** [Number if iterating]  
**Status:** [Draft / Testing / Validated]
```

---

## Template 2: Dialectical Transcript

Use for: Showing concept development process

```markdown
# Forging: [CONCEPT NAME]

**Initial intuition:** [Starting question or observation]

---

## Dialectical Development

### Round 1: Articulation

**Initial statement:**
[User's first attempt to articulate]

**@strategist:**
[Clarifying question]

**Response:**
[User refinement]

**@pragmatist:**
[Testing challenge]

**Response:**
[User adjustment]

---

### Round 2: Dimensionalization

**@cartographer:**
[Question about structure]

**Response:**
[User identifies dimensions]

**@theorist:**
[Challenge to categories]

**Response:**
[User defends or refines]

---

### Round 3: Mapping

**@pragmatist:**
[Demand for examples]

**Response:**
[User provides cases]

**@rebel_econ:**
[Points out edge case or fragility]

**Response:**
[User adjusts boundaries]

---

### Round 4: Refinement

**@ethicist:**
[Surfaces moral dimension]

**Response:**
[User acknowledges tension]

**@monk:**
[Points out paradox]

**Response:**
[User integrates or accepts paradox]

---

## Synthesis

**Final crystallization:**
[Refined concept statement]

**Key insights from process:**
1. [Insight gained through interrogation]
2. [Insight gained through interrogation]
3. [Insight gained through interrogation]

**Turning points:**
- [Moment when concept shifted significantly]
- [Critical question that unlocked clarity]

---

**Archetypes consulted:** [@list of archetypes]  
**Development time:** [Duration if tracked]  
**Outcome:** [Crystallized / Still forming / Abandoned]
```

---

## Template 3: Framework Diagram with Notes

Use for: Visual-first concepts

```markdown
# [CONCEPT NAME] Framework

## Visual

```
[ASCII diagram or description of visual]

Example for 2x2 grid:

        High Context
             ↑
    [Red Zone] │ [Yellow Zone]
    Zone A     │ Zone B
    ───────────┼──────────────→ High Complexity
    [Green]    │ [Yellow Zone]
    Zone C     │ Zone D
             ↓
        Low Context
```

## Legend

**Axes:**
- **[Dimension 1]:** [Definition with endpoints]
- **[Dimension 2]:** [Definition with endpoints]

**Zones:**
- **[Zone A]:** [Characteristics, success rate, typical patterns]
- **[Zone B]:** [Characteristics, success rate, typical patterns]
- **[Zone C]:** [Characteristics, success rate, typical patterns]
- **[Zone D]:** [Characteristics, success rate, typical patterns]

**Examples plotted:**
• [Example 1] is in Zone A
• [Example 2] is in Zone D
• [Example 3] is in Zone B

## Movement

**To move from Zone C → Zone A:**
1. [Infrastructure or action required]
2. [Typical approach]

**To move from Zone D → Zone B:**
1. [Infrastructure or action required]
2. [Typical approach]

## Application

**How to use this framework:**
1. [Step 1 - Assessment]
2. [Step 2 - Positioning]
3. [Step 3 - Strategy selection]

**Common mistakes:**
- [Misapplication pattern 1]
- [Misapplication pattern 2]
```

---

## Template 4: Concept Comparison

Use for: Distinguishing new concept from existing ones

```markdown
# [NEW CONCEPT] vs. [EXISTING CONCEPT(S)]

## The Confusion

[Why these concepts are often conflated]

[What people typically misunderstand]

---

## Key Differences

| Aspect | [New Concept] | [Existing Concept 1] | [Existing Concept 2] |
|--------|---------------|----------------------|----------------------|
| **Focus** | [What it emphasizes] | [What it emphasizes] | [What it emphasizes] |
| **Dimensions** | [Key factors] | [Key factors] | [Key factors] |
| **Application** | [When to use] | [When to use] | [When to use] |
| **Limitations** | [What it doesn't explain] | [What it doesn't explain] | [What it doesn't explain] |

---

## When to Use Each

**Use [New Concept] when:**
- [Condition 1]
- [Condition 2]
- [Condition 3]

**Use [Existing Concept 1] when:**
- [Condition 1]
- [Condition 2]

**Use [Existing Concept 2] when:**
- [Condition 1]
- [Condition 2]

---

## Example Showing Difference

**Scenario:** [Concrete situation]

**[New Concept] analysis:**
[How new concept frames this]
[What it reveals]
[What action it suggests]

**[Existing Concept 1] analysis:**
[How existing concept frames this]
[What it reveals]
[What action it suggests]

**Key distinction:**
[What the new concept captures that existing concepts miss]

---

## Integration

[How concepts relate - complementary, competing, nested, etc.]

[When to use multiple frameworks together]
```

---

## Template 5: Rapid Concept Sketch

Use for: Quick capture during early-stage exploration

```markdown
# [WORKING TITLE]

**Core intuition:** [One sentence]

**What varies:** [2-3 factors]

**Examples:**
- ✓ [Fits]: [Case]
- ✓ [Fits]: [Case]
- ✗ [Doesn't fit]: [Case]

**Next questions:**
- [ ] [What needs clarification]
- [ ] [What needs testing]
- [ ] [What edge case to explore]

**Status:** [Intuition / Forming / Testing / Crystallized / Abandoned]

**Date:** [Today]
```

---

## Template 6: Constraint Map

Use for: Strategic constraint concepts

```markdown
# [CONSTRAINT CONCEPT]

## The Strategic Challenge

[What goal or outcome is being constrained]

---

## Constraints Identified

### 1. [Constraint Name]

**Nature:** [What type of constraint - resource, coordination, knowledge, etc.]

**Current state:** [How this limits action now]

**Interaction effects:** [How this compounds with other constraints]

**Potential interventions:** [How to address or work around]

---

### 2. [Constraint Name]

[Same structure]

---

### 3. [Constraint Name]

[Same structure]

---

[Continue for all major constraints]

---

## Constraint Interactions

**Reinforcing loops:**
- [Constraint A] → [Constraint B] → [Constraint C] → [Back to A]
- [Description of vicious cycle]

**Loosening strategies:**
- [Which constraint to address first]
- [Why this unlocks others]
- [Expected cascade effects]

---

## Priority Doctrine

**Most critical constraint:** [Name]  
**Why:** [Explanation - bottleneck, foundational, highest leverage]

**Sequence:**
1. Address [Constraint X] first
2. Then [Constraint Y]
3. Then [Constraint Z]

**Do NOT attempt:**
- [Action that tries to work around constraints ineffectively]
- [Common approach that ignores constraint interactions]

---

## Success Metrics

**How to know constraints are loosening:**
- [Observable indicator 1]
- [Observable indicator 2]
- [Observable indicator 3]

---

**Context:** [Organization or domain]  
**Timeframe:** [When analyzed]  
**Status:** [Current / Historical / Projected]
```

---

## Usage Guidelines

### Choosing Template

**Use Template 1 (Crystallized Concept):**
- Concept is mature and testable
- Ready for external sharing
- Needs comprehensive documentation

**Use Template 2 (Dialectical Transcript):**
- Want to show thinking process
- Concept is pedagogically interesting
- Journey matters as much as destination

**Use Template 3 (Framework Diagram):**
- Visual is primary
- Concept is spatial/relational
- Need quick reference

**Use Template 4 (Concept Comparison):**
- Distinguishing from existing concepts
- Addressing confusion
- Positioning in landscape

**Use Template 5 (Rapid Sketch):**
- Early stage capture
- Working notes
- Quick iteration

**Use Template 6 (Constraint Map):**
- Strategic planning context
- Multiple interacting factors
- Priority decisions needed

---

## Format Variations

**Markdown:** Default format, convertible  
**DOCX:** Use docx skill for formal documentation  
**Slide deck:** Use strategy-to-artifact skill for presentations  
**One-pager:** Use strategy-to-artifact for executive summaries  
**Diagram:** Export visual separately for embedding
