# Dad Joke Scoring Guide

Detailed criteria for each dimension with scoring examples.

---

## Dimension 1: Pun Quality (0-10)

**What We're Measuring:** Quality and clarity of wordplay

### Score Ranges

**9-10: Exceptional Pun**
- Multiple meanings perfectly exploited
- Sophisticated yet accessible wordplay
- Unexpected but clear connection
- Example: "I used to hate facial hair, but then it grew on me" (grew = literal growth + figurative acceptance)

**7-8: Strong Pun**
- Clear double meaning
- Good wordplay connection
- Recognizable pun structure
- Example: "I wouldn't buy anything with velcro. It's a total rip-off" (rip-off = velcro action + scam)

**5-6: Moderate Pun**
- Pun exists but requires thought
- Wordplay present but not obvious
- Connection works but isn't strong
- Example: "Parallel lines have so much in common" (metaphorical use of geometric concept)

**3-4: Weak Pun**
- Minimal wordplay
- Obscure or forced connection
- Requires explanation
- Example: Puns based on very rare words or specialized knowledge

**0-2: No Real Pun**
- No wordplay detected
- Literal statements
- Humor not based on language
- Example: "I walked to the store and bought milk"

### Pun Types That Score Well

1. **Homophones:** Words that sound alike (two/too, mugged/mug)
2. **Double Meanings:** Single word with multiple interpretations (make up, put down)
3. **Idiom Literalization:** Taking expressions literally (outstanding in field)
4. **Misdirection:** Setup implies one meaning, punchline reveals another

---

## Dimension 2: Groan Factor (0-10)

**What We're Measuring:** Predictability and groan-inducement (HIGHER IS BETTER)

### Score Ranges

**9-10: Maximum Groan**
- Punchline completely predictable yet unavoidable
- "Of course!" reaction
- Setup makes pun obvious
- Creates actual groan response
- Example: "Why did the bicycle fall over? It was two-tired" (setup telegraphs the pun perfectly)

**7-8: Solid Groan**
- Punchline fairly predictable
- Good setup leading to pun
- Induces smiling groan
- Example: "What do you call a fake noodle? An impasta"

**5-6: Mild Groan**
- Some predictability
- Reaction more smile than groan
- Pun works but doesn't hit hard
- Example: Less obvious puns that require a moment

**3-4: Too Clever**
- Punchline not predictable enough
- More "hmm" than groan
- Requires too much thought
- Example: Puns requiring specialized knowledge

**0-2: No Groan**
- Falls flat
- No reaction
- Confusing rather than groany
- Example: Over-explained jokes that lose impact

### What Creates Groan

- **Obvious Setup:** Question format that telegraphs the answer
- **Simple Punchline:** Short, direct, economical
- **Classic Structure:** Tried-and-true dad joke format
- **Inevitable Pun:** You see it coming but can't stop the groan

---

## Dimension 3: Wholesomeness (0-10)

**What We're Measuring:** Family-friendliness and positive tone

### Score Ranges

**9-10: Perfectly Wholesome**
- Completely family-friendly
- Positive, warm tone
- Innocent subject matter
- Safe for all ages
- Topics: Animals, food, school, occupations, everyday objects
- Example: "Why did the scarecrow win an award? He was outstanding in his field"

**7-8: Generally Wholesome**
- Family-friendly with minor caveats
- Mostly positive tone
- Safe for most contexts
- No offensive content
- Example: Mild spousal teasing that's affectionate

**5-6: Slightly Edgy**
- Contains themes that reduce wholesomeness
- Mild negative language
- Not ideal for all audiences
- Red flags: "hate," "stupid," "ugly"
- Example: "I told my wife she was drawing her eyebrows too high. She looked surprised"

**3-4: Problematic Content**
- Adult themes (alcohol, relationships)
- Negative tone
- Mean-spirited humor
- Not suitable for children
- Example: "I'm on a whiskey diet. I've lost three days already"

**0-2: Inappropriate**
- Explicit content
- Mean or cruel humor
- Definitely not family-friendly
- Violates dad joke spirit

### Wholesome Themes

**Highest Scores:**
- Food and cooking
- Animals and pets
- School and education
- Occupations and work
- Nature and weather
- Books and reading
- Sports and games
- Tools and objects

**Reduce Scores:**
- Alcohol or drugs
- Negative emotions (hate, anger)
- Critical humor about people
- Adult relationships
- Body issues

---

## Dimension 4: Structure (0-10)

**What We're Measuring:** Setup/punchline quality and timing

### Score Ranges

**9-10: Perfect Structure**
- Clean setup establishing context
- Economical punchline (no wasted words)
- Excellent timing and rhythm
- Effective misdirection
- Ideal: 2 sentences (setup + punchline)
- Example: "I used to hate facial hair. But then it grew on me."

**7-8: Good Structure**
- Clear setup and punchline
- Minor timing issues
- Slightly wordy but works
- Standard Q&A format
- Example: "Why don't scientists trust atoms? Because they make up everything!"

**5-6: Adequate Structure**
- Structure present but clunky
- Punchline could be tighter
- Setup too long or too short
- Rhythm feels off
- Example: Three+ sentence jokes that could be condensed

**3-4: Poor Structure**
- Over-explained punchline
- Setup doesn't lead effectively
- Too many sentences
- Lost focus
- Example: "You can tune a guitar but you can't tuna fish... unless you go to the store and buy one"

**0-2: No Structure**
- No clear setup/punchline
- Rambling or confused
- Missing key elements
- Example: Jokes that feel like stories

### Structural Elements

**Setup:**
- Establishes context quickly
- Creates expectation
- Leads naturally to punchline
- Not too long (1-2 sentences max)

**Punchline:**
- Delivers the pun clearly
- SHORT (1 sentence ideal)
- No explanation needed
- Exploits misdirection from setup

**Common Formats:**
1. **Two Statement:** "I used to X. But then Y."
2. **Question/Answer:** "Why did X? Because Y."
3. **What Do You Call:** "What do you call X? Y!"
4. **Statement/Reveal:** "I'm doing X. [Punchline reveals pun]"

---

## Overall Score Calculation

**Formula:**
```
Overall = (Pun Quality  2.5) + (Groan Factor  3) +
          (Wholesomeness  3) + (Structure  1.5)
```

**Maximum Score:** 100 points

**Weighting Rationale:**
- **Groan Factor (3x):** Central to dad joke identity
- **Wholesomeness (3x):** Defines the "dad" in dad joke
- **Pun Quality (2.5x):** Essential but not sole factor
- **Structure (1.5x):** Supporting element for delivery

### Score Interpretation

**85-100: Peak Dad Joke**
- All dimensions strong
- Exemplifies dad joke characteristics
- Frame-worthy
- Example: "I used to hate facial hair, but then it grew on me" (98/100)

**70-84: Solid Dad Joke**
- Minor weaknesses in one dimension
- Still works well as dad joke
- Room for polish
- Example: "I wouldn't buy anything with velcro. It's a total rip-off" (72/100)

**50-69: Dad Joke Adjacent**
- Missing key characteristics
- Potential but needs work
- Violates one+ dimensions significantly
- Example: "Parallel lines have so much in common. It's a shame they'll never meet" (64/100)

**Below 50: Not a Dad Joke**
- Fundamental issues
- Wrong type of humor
- Inappropriate content
- Example: "I'm on a whiskey diet. I've lost three days already" (42/100)

---

## Common Improvement Patterns

**If Pun Quality is Low:**
- Find clearer double meaning
- Use more accessible wordplay
- Simplify the pun connection

**If Groan Factor is Low:**
- Make punchline more predictable
- Strengthen setup to telegraph pun
- Use simpler, more obvious wordplay

**If Wholesomeness is Low:**
- Remove edgy content
- Choose positive themes
- Eliminate mean-spirited elements

**If Structure is Low:**
- Cut unnecessary words
- Tighten punchline to 1 sentence
- Ensure clear setup/punchline division
- Remove explanations

---

**Created:** 2025-11-16
**Purpose:** Detailed scoring criteria reference
**Use:** Apply these criteria when analyzing jokes
