# Fabric Pattern Catalog

Complete reference of all available fabric patterns, organized by category.

> **Freshness:** Run `fabric -U` to update patterns. Run `fabric -l` to list installed patterns.

---

## Analysis Patterns

| Pattern | Purpose |
|---------|---------|
| `agility_story` | Generates user stories and acceptance criteria in JSON format |
| `ai` | Deep interpretations and concise answers in markdown bullets |
| `analyze_answers` | Evaluates quiz responses against learning objectives |
| `analyze_candidates` | Compares political candidates on key issues |
| `analyze_cfp_submission` | Reviews conference speaking proposals for quality |
| `analyze_claims` | Rates truth claims with evidence and counter-arguments |
| `analyze_comments` | Categorizes internet sentiment and feedback |
| `analyze_debate` | Rates debate quality and analyzes arguments |
| `analyze_email_headers` | Security analysis of SPF, DKIM, DMARC, ARC results |
| `analyze_incident` | Extracts cybersecurity breach details systematically |
| `analyze_interviewer_techniques` | Identifies interviewer qualities and uniqueness |
| `analyze_logs` | Identifies patterns and anomalies in server logs |
| `analyze_malware` | Extracts indicators and detection strategies from malware |
| `analyze_military_strategy` | Deep analysis of historical battles and tactics |
| `analyze_mistakes` | Maps past thinking errors to current beliefs |
| `analyze_paper` | Evaluates research papers for rigor and quality |
| `analyze_patent` | Analyzes patent novelty, problem, and advantages |
| `analyze_personality` | Psychological analysis based on behavior and language |
| `analyze_presentation` | Critiques presentation content and speaker goals |
| `analyze_product_feedback` | Organizes user feedback into themes |
| `analyze_proposition` | Examines ballot propositions for impact and arguments |
| `analyze_prose` | Evaluates writing quality and style |
| `analyze_prose_json` | Evaluates writing quality and style (JSON output) |
| `analyze_prose_pinker` | Writing evaluation using Steven Pinker's style principles |
| `analyze_sales_call` | Rates sales performance across multiple dimensions |
| `analyze_spiritual_text` | Compares texts with King James Bible |
| `analyze_tech_impact` | Evaluates technology's societal and ethical implications |
| `analyze_threat_report` | Extracts cybersecurity insights |
| `analyze_threat_report_trends` | Extracts cybersecurity trends over time |

## Creation Patterns

| Pattern | Purpose |
|---------|---------|
| `answer_interview_question` | Generates tailored technical interview responses |
| `ask_secure_by_design_questions` | Generates security-focused design questions |
| `ask_uncle_duke` | Coordinates AI agents for software solutions |
| `capture_thinkers_work` | Summarizes philosophers and their teachings |
| `check_agreement` | Identifies important contract stipulations and issues |
| `clean_text` | Fixes formatting, punctuation, and paragraph structure |
| `coding_master` | Explains coding concepts to beginners with examples |
| `compare_and_contrast` | Creates markdown comparison tables |
| `create_5_sentence_summary` | Multi-depth summary (5 sentences down to 1 word) |
| `create_academic_paper` | Generates LaTeX-formatted academic papers |
| `create_ai_jobs_analysis` | Analyzes automation impact on job categories |
| `create_aphorisms` | Generates brief, witty statements |
| `create_art_prompt` | Creates detailed visual descriptions for AI art |
| `create_better_frame` | Analyzes interpretive frames and positive perspectives |
| `create_coding_project` | Creates wireframes and starter code |
| `create_command` | Determines penetration testing tool parameters |
| `create_cyber_summary` | 25-word cybersecurity summaries with categorized bullets |
| `create_design_document` | Generates comprehensive design documentation |
| `create_diy` | Creates structured tutorial patterns with steps |
| `create_formal_email` | Drafts professional emails with proper structure |
| `create_git_diff_commit` | Generates git commands and conventional commit messages |
| `create_graph_from_input` | Generates CSV progress data for security programs |
| `create_hormozi_offer` | Business offers based on "$100M Offers" principles |
| `create_idea_compass` | Organizes ideas by definition, evidence, sources |
| `create_investigation_visualization` | Creates detailed Graphviz diagrams |
| `create_keynote` | Develops TED-style presentations with speaker notes |
| `create_logo` | Generates minimalist logo prompts for AI |
| `create_markmap_visualization` | Transforms ideas into MarkMap diagrams |
| `create_mermaid_visualization` | Creates detailed Mermaid syntax visualizations |
| `create_mermaid_visualization_for_github` | GitHub-compatible Mermaid diagrams |
| `create_micro_summary` | 20-word summaries with main points |
| `create_network_threat_landscape` | Comprehensive security threat reports |
| `create_npc` | Generates detailed D&D 5E NPCs with stats |
| `create_pattern` | Extracts and structures LLM prompts |
| `create_quiz` | Creates review questions for learning objectives |
| `create_reading_plan` | Reading plans across three difficulty levels |
| `create_recursive_outline` | Breaks projects into hierarchical components |
| `create_report_finding` | Structures detailed security findings |
| `create_rpg_summary` | Summarizes RPG sessions with key events |
| `create_security_update` | Compiles newsletter security updates |
| `create_show_intro` | Creates podcast episode introductions |
| `create_sigma_rules` | Converts TTPs into Sigma detection rules |
| `create_story_explanation` | Summarizes complex content as stories |
| `create_stride_threat_model` | Creates STRIDE-based threat models |
| `create_summary` | 20-word summaries with main points and takeaways |
| `create_tags` | Identifies 5+ tags for mind mapping |
| `create_threat_model` | General threat modeling |
| `create_threat_scenarios` | Identifies likely attack methods with narratives |
| `create_ttrc_graph` | Tracks remediation metrics (visual) |
| `create_ttrc_narrative` | Tracks remediation metrics (narrative) |
| `create_upgrade_pack` | Extracts world model and task updates |
| `create_user_story` | Writes technical user stories for complex software |
| `create_video_chapters` | Extracts topics and timestamps from transcripts |
| `create_visualization` | Transforms concepts into ASCII art |
| `explain_code` | Explains code, tool output, and configurations |
| `explain_docs` | Restructures tool documentation clearly |
| `explain_math` | Clarifies mathematical concepts engagingly |
| `explain_project` | Summarizes project documentation concisely |
| `explain_terms` | Produces glossaries with definitions and analogies |

## Extraction Patterns

| Pattern | Purpose |
|---------|---------|
| `extract_algorithm_update_recommendations` | Practical algorithm updates |
| `extract_article_wisdom` | Categorizes content into organized sections |
| `extract_book_ideas` | Extracts 50-100 surprising book ideas |
| `extract_book_recommendations` | Extracts 50-100 practical recommendations |
| `extract_business_ideas` | Identifies top business opportunities |
| `extract_controversial_ideas` | Lists controversial statements with quotes |
| `extract_core_message` | Distills main message into one sentence |
| `extract_ctf_writeup` | Generates cyber security engagement writeups |
| `extract_extraordinary_claims` | Lists disputed or false statements |
| `extract_ideas` | Key ideas as 15-word bullets |
| `extract_insights` | Powerful ideas in 16-word format |
| `extract_insights_dm` | Insights and content summaries (Daniel Miessler style) |
| `extract_instructions` | Organizes instructional video steps |
| `extract_jokes` | Isolates jokes with punchlines separated |
| `extract_latest_video` | Outputs latest YouTube URL from RSS feeds |
| `extract_main_idea` | Distills main idea and recommendation |
| `extract_most_redeeming_thing` | Finds most positive aspect |
| `extract_patterns` | Analyzes recurring and insightful patterns |
| `extract_poc` | Extracts proof-of-concept URLs and validation |
| `extract_predictions` | Predictions with date, confidence, verification |
| `extract_primary_problem` | Identifies core issues |
| `extract_primary_solution` | Identifies core solutions |
| `extract_product_features` | Product features in bullet format |
| `extract_questions` | Collects all interview questions |
| `extract_recipe` | Recipes with ingredients and steps |
| `extract_recommendations` | Practical recommendations as bullets |
| `extract_references` | Lists art, books, and source references |
| `extract_skills` | Classifies job skills as hard or soft |
| `extract_song_meaning` | Evidence-based song interpretation |
| `extract_sponsors` | Lists official and potential sponsors |
| `extract_videoid` | Extracts video IDs from URLs |
| `extract_wisdom` | Surprising life and technology insights |
| `extract_wisdom_agents` | Emphasizes human flourishing and AI topics |
| `extract_wisdom_dm` | Comprehensive valuable insights (Daniel Miessler style) |
| `extract_wisdom_nometa` | Insights without metadata |

## Summarization Patterns

| Pattern | Purpose |
|---------|---------|
| `summarize` | 20-word summary with points and takeaways |
| `summarize_debate` | Identifies disagreements and analyzes argument strength |
| `summarize_git_changes` | Highlights 7-day project updates |
| `summarize_git_diff` | Organizes git changes with commit messages |
| `summarize_lecture` | Extracts topics, definitions, and timestamps |
| `summarize_legislation` | Analyzes political proposals with balanced perspectives |
| `summarize_meeting` | Structures meeting transcripts comprehensively |
| `summarize_micro` | 20-word summary with 3 points |
| `summarize_newsletter` | Extracts meaningful newsletter content |
| `summarize_paper` | Academic papers in human-readable markdown |
| `summarize_prompt` | Describes prompt function and expected output |
| `summarize_pull-requests` | Lists top PRs with descriptions |
| `summarize_rpg_session` | Extracts events, stats, character changes |

## Writing Patterns

| Pattern | Purpose |
|---------|---------|
| `write_essay` | Composes essays in specified author's style |
| `write_hackerone_report` | Generates concise bug bounty reports |
| `write_latex` | Creates syntactically correct LaTeX documents |
| `write_micro_essay` | Writes brief, illuminating essays |
| `write_nuclei_template_rule` | YAML vulnerability detection templates |
| `write_pull-request` | Drafts detailed PR descriptions with reasoning |
| `write_semgrep_rule` | Creates functional Semgrep detection rules |

## Improvement Patterns

| Pattern | Purpose |
|---------|---------|
| `improve_academic_writing` | Refines text into academic language |
| `improve_prompt` | Enhances LLM prompts with expert strategies |
| `improve_report_finding` | Enhances penetration test findings |
| `improve_writing` | Refines grammar, style, and clarity |
| `humanize` | Rewrites AI text conversationally |

## Thinking & Reasoning Patterns

| Pattern | Purpose |
|---------|---------|
| `dialog_with_socrates` | Deep Socratic dialogues |
| `find_logical_fallacies` | Classifies argument fallacies |
| `find_hidden_message` | Extracts political messages and analysis |
| `identify_dsrp_distinctions` | Systems thinking: Distinctions |
| `identify_dsrp_perspectives` | Systems thinking: Perspectives |
| `identify_dsrp_relationships` | Systems thinking: Relationships |
| `identify_dsrp_systems` | Systems thinking: Systems |
| `solve_with_cot` | Chain-of-thought problem solving |

## Security Patterns

| Pattern | Purpose |
|---------|---------|
| `analyze_email_headers` | Email header security analysis |
| `analyze_incident` | Cybersecurity breach analysis |
| `analyze_logs` | Log pattern and anomaly detection |
| `analyze_malware` | Malware indicator extraction |
| `analyze_threat_report` | Threat intel extraction |
| `analyze_threat_report_trends` | Threat trend analysis |
| `ask_secure_by_design_questions` | Security design questions |
| `create_command` | Pentest tool parameter generation |
| `create_network_threat_landscape` | Network threat reports |
| `create_report_finding` | Security finding documentation |
| `create_sigma_rules` | Sigma detection rules |
| `create_stride_threat_model` | STRIDE threat models |
| `create_threat_model` | General threat models |
| `create_threat_scenarios` | Attack scenario narratives |
| `extract_ctf_writeup` | CTF writeup generation |
| `extract_poc` | Proof-of-concept extraction |
| `recommend_pipeline_upgrades` | Vulnerability pipeline optimization |
| `write_hackerone_report` | Bug bounty reports |
| `write_nuclei_template_rule` | Nuclei templates |
| `write_semgrep_rule` | Semgrep rules |

## Utility Patterns

| Pattern | Purpose |
|---------|---------|
| `clean_text` | Fix formatting and punctuation |
| `convert_to_markdown` | Transform content to markdown |
| `export_data_as_csv` | Extract data as CSV |
| `fix_typos` | Proofread and correct text |
| `label_and_rate` | Tag content and assign quality tiers |
| `md_callout` | Generate markdown callouts |
| `rate_ai_response` | Grade AI quality against benchmarks |
| `rate_ai_result` | Assess AI/ML work across dimensions |
| `rate_content` | Tag and rate content with scores |
| `review_design` | Analyzes architecture for clarity and security |
| `suggest_pattern` | Recommends appropriate fabric patterns |
| `to_flashcards` | Convert text into Anki flashcards |
| `transcribe_minutes` | Extract actionables from transcripts |
| `translate` | Translate content to specified languages |

## YouTube & Media Patterns

| Pattern | Purpose |
|---------|---------|
| `create_video_chapters` | Timestamp + topic extraction |
| `extract_latest_video` | Get latest video URL from RSS |
| `extract_videoid` | Extract video IDs from URLs |
| `get_youtube_rss` | Get YouTube RSS feed URLs |
| `youtube_summary` | Timestamped video summaries |

## Personal Development (TELOS) Patterns

| Pattern | Purpose |
|---------|---------|
| `t_analyze_challenge_handling` | Evaluates challenge responses |
| `t_check_dunning_kruger` | Self-perception vs competence assessment |
| `t_check_metrics` | TELOS context improvement assessment |
| `t_create_opening_sentences` | Identity and goals description |
| `t_describe_life_outlook` | Life perspective summary |
| `t_find_blindspots` | Thinking vulnerability identification |
| `t_find_negative_thinking` | Negative pattern identification |
| `t_find_neglected_goals` | Abandoned project detection |
| `t_give_encouragement` | Progress evaluation and recommendations |
| `t_red_team_thinking` | Thinking critique and improvements |
| `t_threat_model_plans` | Life plan threat models |
