# Changelog

All notable changes to the Inevitability Engine skill will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2025-11-22

### Added
- Initial release of the Inevitability Engine skill
- Six-phase research protocol:
  - Phase 1: Capability Frontier Mapping
  - Phase 2: Opportunity Discovery (Segment-Problem Analysis)
  - Phase 3: Business Model Generation
  - Phase 4: Market Validation & Refinement
  - Phase 5: Inevitability Scoring
  - Phase 6: Synthesis & Output
- Comprehensive reference documentation:
  - `capability-mapping.md` - Detailed Phase 1 protocol
  - `opportunity-discovery.md` - Detailed Phase 2 protocol
  - `business-model-generation.md` - Detailed Phase 3 protocol
  - `validation-refinement.md` - Detailed Phase 4 protocol
  - `inevitability-framework.md` - Scoring system and formulas
  - `research-protocols.md` - Complete query library for all phases
  - `output-templates.md` - Structured deliverable formats
- Inevitability scoring framework with formula: `((E + T + M) / 3) - (F / 2)`
- 10 synthetic worker primitives (archetypes)
- Time-horizon capability unlock matrix (3mo, 6mo, 12mo, 18mo, 24mo)
- Complete research query patterns for capability tracking, pain point mining, competitive analysis
- Output templates for executive summaries, opportunity matrices, deep dives, research appendices
- Interactive workflow allowing users to run full process or jump to specific phases
- Integration guidelines with other skills (process-mapper, research-to-essay, strategy-to-artifact)

### Framework Components
- Wardley evolution mapping for AI capabilities
- Segment-problem matrix for systematic opportunity enumeration
- First principles decomposition for automation feasibility
- Economic leverage calculations
- TAM/SAM/SOM market sizing framework
- Competitive differentiation analysis
- Build-vs-buy decision matrix
- Risk assessment templates
- Sensitivity analysis methodology

### Documentation
- Comprehensive README with quick start guide
- Example use cases (legal services, contract review, B2B SaaS)
- Success criteria definitions
- Quality check checklists for each phase
- Anti-patterns and common mistakes
- Tips for effective research and analysis

### Meta-Instructions
- Prioritize AI-native infrastructure over bolt-on solutions
- Focus on 10-100x cost reductions
- Target workflow replacement over enhancement
- Prefer high-margin software businesses (>70% gross margin)
- Exclude crypto/web3, consumer social, hardware-dependent models

## [Unreleased]

### Planned Features
- Case study library of analyzed opportunities
- Integration with MCP servers for automated data gathering
- Template library for specific industries (legal, finance, healthcare)
- Automated inevitability score calculator tool
- Competitive landscape visualization tools
- Time-series tracking for capability evolution

### Potential Enhancements
- Integration with Claude Agent SDK for automated research workflows
- Custom fine-tuned models for domain-specific opportunity analysis
- Real-time capability tracking dashboard
- Collaboration features for team-based research
- Export to various formats (PDF, Notion, Confluence, Google Docs)

---

## Version Numbering

- **Major version** (X.0.0): Significant changes to framework or methodology
- **Minor version** (0.X.0): New phases, reference docs, or major features
- **Patch version** (0.0.X): Bug fixes, clarifications, template improvements

---

## Feedback & Contributions

This skill is part of the AISkills collection. Feedback and contributions are welcome through the main repository.
