# The Inevitability Engine

**Systematic research protocol for discovering novel AI-native software businesses in the synthetic workforce era.**

## Overview

The Inevitability Engine is a comprehensive framework for identifying business opportunities that become inevitable due to AI capability improvements. It maps capability trajectories, analyzes segment-problem spaces, generates business models, and calculates inevitability scores across 3-24 month time horizons.

## Core Thesis

We're witnessing the **first-ever inversion of the tool adaptation curve**. Historically, humans adapted to tools faster than tools evolved. Now, tools (LLMs) evolve faster than humans can adapt. This creates a **capability overhang** that unlocks previously impossible business models.

### Three Forcing Functions

1. **Context window explosion**: 4K → 128K → 2M tokens in 24 months
2. **Inference cost collapse**: ~90% reduction per year
3. **Tool-use reliability**: Function calling accuracy from 60% → 95%+ in 18 months

**Result**: The "synthetic worker" becomes infrastructure. Companies will hire, fire, eval, and SLA these entities. The opportunity lies in the tooling, governance, coordination, and domain specialization of this new workforce layer.

## Quick Start

### Prerequisites

- Access to web search capabilities (WebSearch, WebFetch)
- 40-50 hours for full research protocol
- Understanding of target segments and industries

### Basic Usage

Invoke the skill:
```
Use the inevitability-engine skill
```

Then choose your path:
- **Full discovery** → Execute all 6 phases systematically
- **Specific phase** → Jump to capability mapping, opportunity discovery, etc.
- **Targeted research** → Focus on specific segment or opportunity

## The Six-Phase Framework

### Phase 1: Capability Frontier Mapping (2-3 hours)
Map current and projected AI capabilities across time horizons. Identify constraint removals and capability unlocks.

**Output**: Capability timeline showing what becomes automatable at 3mo, 6mo, 12mo, 18mo, 24mo horizons.

### Phase 2: Opportunity Discovery (8-10 hours)
Build segment × problem matrix. Mine pain points from 15+ segments. Identify high-value automation targets.

**Output**: 50-100+ validated pain points with economic impact and automation potential.

### Phase 3: Business Model Generation (6-8 hours)
Define synthetic worker primitives. Cross with segments to generate business concepts. Map to time horizons.

**Output**: 25-50 business models with SLAs, eval frameworks, and unit economics.

### Phase 4: Market Validation (10-12 hours)
Validate demand, size markets, analyze competition, identify differentiation vectors.

**Output**: TAM/SAM/SOM, competitive analysis, pricing validation, strategic positioning.

### Phase 5: Inevitability Scoring (2-3 hours)
Quantify inevitability using the formula: `((E + T + M) / 3) - (F / 2)`
- E = Economic Pressure (cost reduction)
- T = Technical Feasibility (% automatable)
- M = Market Readiness (budget + behavior)
- F = Adoption Friction (barriers)

**Output**: Ranked opportunities with inevitability scores, timing estimates, sensitivity analysis.

### Phase 6: Synthesis & Output (8-10 hours)
Create comprehensive deliverable with executive summary, opportunity matrix, deep dives, research appendix.

**Output**: Publication-ready research report with actionable recommendations.

## Key Frameworks

### Inevitability Formula

```
Inevitability = ((E + T + M) / 3) - (F / 2)

Where:
E = Economic Pressure [0-10]
T = Technical Feasibility [0-10]
M = Market Readiness [0-10]
F = Adoption Friction [1-10]

Score > 7: Inevitable
Score 5-7: Likely
Score 3-5: Possible
Score < 3: Unlikely
```

### Synthetic Worker Primitives

10 atomic job functions that become commoditized:

1. **Continuous Monitor** - Watches systems, alerts on anomalies
2. **Research Synthesizer** - Gathers and synthesizes information
3. **Document Processor** - Extracts, validates, transforms documents
4. **Communication Coordinator** - Drafts, routes, tracks messages
5. **Compliance Auditor** - Checks rules, flags violations
6. **Creative Collaborator** - Generates variants, iterates on feedback
7. **Knowledge Curator** - Organizes and retrieves information
8. **Workflow Orchestrator** - Manages multi-step processes
9. **Analysis Generator** - Runs reports, identifies patterns
10. **Relationship Maintainer** - Tracks context, personalizes outreach

### Time-Horizon Capability Unlocks

| Horizon | Context | Cost/1M | Reliability | Business Category |
|---------|---------|---------|-------------|-------------------|
| 3mo | 200K | $0.15 | 96% | Document workspace agents |
| 6mo | 500K | $0.08 | 97% | Research automation platforms |
| 12mo | 1M | $0.04 | 98% | Synthetic operations teams |
| 18mo | 2M | $0.02 | 98.5% | Executive co-pilots |
| 24mo | 5M+ | $0.01 | 99% | Synthetic departments |

## Directory Structure

```
inevitability-engine/
├── SKILL.md                           # Main skill file (START HERE)
├── README.md                          # This file
├── CHANGELOG.md                       # Version history
├── LICENSE.txt                        # License terms
├── references/                        # Detailed frameworks
│   ├── capability-mapping.md          # Phase 1 protocol
│   ├── opportunity-discovery.md       # Phase 2 protocol
│   ├── business-model-generation.md   # Phase 3 protocol
│   ├── validation-refinement.md       # Phase 4 protocol
│   ├── inevitability-framework.md     # Phase 5 scoring system
│   ├── research-protocols.md          # Complete query library
│   └── output-templates.md            # Deliverable formats
├── assets/                            # Supporting materials
├── scripts/                           # Utility scripts
└── dist/                              # Packaged releases
```

## Example Use Cases

### 1. Find AI Opportunities in Legal Services
```
User: "Find AI business opportunities in legal services"

Process:
1. Focus Phase 2 research on legal segment
2. Execute pain point queries for attorneys
3. Build problem matrix
4. Map to synthetic worker primitives (Research Synthesizer, Document Processor)
5. Generate 5-10 business concepts
6. Validate top 3 with market research
7. Calculate inevitability scores
8. Deliver ranked opportunities with GTM strategies
```

### 2. Validate Specific Business Idea
```
User: "Calculate inevitability score for AI-powered contract review"

Process:
1. Define synthetic worker (Document Processor + Compliance Auditor)
2. Research economic impact (current cost vs AI cost)
3. Assess technical feasibility (% automatable today and at horizons)
4. Gauge market readiness (budget + behavior)
5. Estimate adoption friction (integration + trust + regulatory)
6. Calculate score
7. Sensitivity analysis
8. Recommendation
```

### 3. Map Entire Opportunity Landscape
```
User: "Run full inevitability engine research on B2B SaaS"

Process:
1. Execute all 6 phases
2. 15+ segments analyzed
3. 50-100+ pain points identified
4. 25-50 business models generated
5. Top 25 validated and scored
6. Comprehensive deliverable with executive summary, matrix, deep dives
7. Strategic recommendations (internal/Catalyst/spin-out decisions)
```

## Success Criteria

Research succeeds when:
- ✅ At least 10 opportunities with inevitability score > 7
- ✅ At least 3 opportunities actionable within 90 days
- ✅ At least 1 opportunity worth spinning out as venture-backed startup
- ✅ Clear time-to-revenue estimates for each
- ✅ Defensible TAM/SAM calculations
- ✅ Competitive analysis reveals clear wedges
- ✅ Unit economics show path to profitability

Business succeeds when:
- ✅ Inevitability score proves accurate
- ✅ Market adopts faster than projected
- ✅ Unit economics improve with scale
- ✅ Synthetic workers deliver promised SLAs
- ✅ Customers achieve 10x+ ROI

## Meta-Instructions

**Prioritize businesses where:**
- AI is **native infrastructure**, not bolted on
- 10-100x cost reductions, not 10-20%
- **Workflow replacement** over enhancement
- Synthetic workers are **competitive advantage**, not just efficiency

**Constraints:**
- No crypto/web3 businesses
- No consumer social (focus B2B, prosumer)
- No hardware-dependent models
- Prefer high-margin software (>70% gross margin)
- Prefer businesses that scale with inference, not headcount

## Integration with Other Skills

- **process-mapper**: Validate automation feasibility for specific workflows
- **research-to-essay**: Transform findings into thought leadership content
- **strategy-to-artifact**: Convert opportunity analysis into pitch decks
- **concept-forge**: Test business hypotheses dialectically

## Version History

See [CHANGELOG.md](CHANGELOG.md) for version history and updates.

## License

See [LICENSE.txt](LICENSE.txt) for complete terms.

## Contributing

This skill is part of the AISkills collection. For issues, improvements, or new features, please contribute to the main repository.

---

## Getting Started Checklist

Before running the Inevitability Engine:

- [ ] Define research scope (segments, time horizons, constraints)
- [ ] Allocate 40-50 hours (or subset for specific phases)
- [ ] Set up access to web research capabilities
- [ ] Identify strategic context (BetterUp/Catalyst/spin-out criteria)
- [ ] Prepare note-taking system for research findings
- [ ] Review key frameworks (inevitability formula, synthetic workers, time horizons)

After research completion:

- [ ] Validate top opportunities with stakeholders
- [ ] Conduct primary research (customer interviews) if possible
- [ ] Make build-vs-buy-vs-partner decisions
- [ ] Create action plan with timeline and resources
- [ ] Set up monitoring for tracked opportunities
- [ ] Re-run quarterly as capabilities evolve

---

Ready to discover what's inevitable?

**Start**: Open `SKILL.md` and choose your path.
