# Research Protocols: Comprehensive Query Library

**Complete catalog of search patterns for each phase of the Inevitability Engine.**

---

## Phase 1: Capability Mapping

### Tracking Frontier Models

**OpenAI:**
```
"GPT-4 Turbo capabilities benchmarks 2024"
"GPT-5 predictions roadmap"
"OpenAI model capabilities comparison"
"site:openai.com GPT-4 system card"
"site:openai.com research 2024"
```

**Anthropic:**
```
"Claude 3.5 Sonnet capabilities"
"Claude Opus 4 announcement"
"Anthropic computer use production"
"site:anthropic.com Claude capabilities"
"site:anthropic.com research 2024"
```

**Google:**
```
"Gemini 1.5 Pro capabilities"
"Gemini Ultra benchmarks"
"Google AI model comparison"
"site:ai.google.dev Gemini"
```

**General capability tracking:**
```
"LLM capabilities comparison 2024"
"large language model benchmarks"
"AI model performance trends"
"transformer model improvements"
```

---

### Context Windows

```
"LLM context window evolution 2023 2024"
"context window roadmap 2025"
"long context models comparison"
"1M token context window"
"Claude context window roadmap"
"GPT context length improvements"
```

---

### Tool Use & Agents

```
"LLM tool use reliability enterprise"
"function calling accuracy benchmarks"
"AI agent orchestration frameworks"
"production agent workflows"
"multi-step LLM automation"
"agent planning capabilities"
"computer use AI automation"
```

---

### Cost & Inference

```
"inference cost trends 2024"
"LLM pricing comparison"
"cost per token reduction"
"AI cost projections 2025"
"model inference efficiency"
```

---

### Multimodal Capabilities

```
"multimodal AI capabilities 2024"
"vision language models comparison"
"GPT-4V benchmark results"
"Claude 3.5 vision capabilities"
"audio processing LLMs"
"video understanding AI models"
```

---

### Scaling Laws & Projections

```
"scaling laws LLM compute tokens"
"chinchilla scaling laws"
"AI capability forecasting"
"model performance predictions"
"compute efficiency trends"
```

---

## Phase 2: Opportunity Discovery

### Generic Pain Point Mining

**For each segment [segment] = lawyers, accountants, designers, etc.:**

```
"[segment] biggest time wasters 2024"
"[segment] productivity challenges survey"
"[segment] time consuming tasks"
"[segment] workflow inefficiencies"
"[segment] manual processes bottlenecks"
"[segment] repetitive tasks automation"
"what takes most time as a [segment]"
```

---

### Workflow Automation Research

```
"[segment] workflow automation pain points"
"[segment] automation challenges"
"[segment] AI adoption barriers"
"why [segment] don't use automation"
"[segment] software integration issues"
"[segment] tool fragmentation"
```

---

### Community Intelligence

**Reddit:**
```
"site:reddit.com [segment] productivity pain points"
"site:reddit.com r/[subreddit] workflow"
"site:reddit.com [segment] time management"
"site:reddit.com [segment] frustrations"
```

**Hacker News:**
```
"site:news.ycombinator.com [segment] workflow tools"
"site:news.ycombinator.com [segment] automation"
"site:news.ycombinator.com [problem] solutions"
```

**Twitter/X:**
```
"site:twitter.com [segment] wish I could automate"
"site:twitter.com [segment] biggest pain point"
"site:twitter.com [task] takes forever"
```

---

### Market Research

```
"[segment] software needs survey 2024"
"[segment] workflow tools market research"
"[segment] technology adoption study"
"[segment] software spending priorities"
"[segment] biggest frustrations with current tools"
"[segment] digital transformation challenges"
```

---

### Budget & Economics

```
"[segment] software spending trends 2024"
"[segment] technology budget allocation"
"[segment] SaaS spending"
"[segment] cost of [task]"
"[job function] salary data [geography]"
"[segment] employment statistics"
```

---

## Phase 3: Business Model Generation

### Existing AI Tools Research

```
"AI [task] automation tools"
"[task] AI assistant"
"[segment] AI software"
"AI powered [job function]"
"[task] automation platforms"
"synthetic [role] AI"
```

---

### Synthetic Worker Research

```
"AI agents for [domain]"
"automated [job function]"
"AI [role] assistant"
"virtual [position]"
"AI workforce [industry]"
```

---

### SLA & Quality Benchmarks

```
"[task] accuracy benchmarks"
"human vs AI [task] performance"
"AI [task] quality metrics"
"[task] automation success rate"
"LLM performance [domain] tasks"
```

---

### Pricing & Economics

```
"[similar tool] pricing"
"[segment] software pricing models"
"[task] automation ROI"
"cost of [job function]"
"[segment] willingness to pay for automation"
```

---

## Phase 4: Market Validation

### Competitive Intelligence

**Finding competitors:**
```
"[business concept] startup 2024"
"[business concept] AI tool"
"[business concept] companies"
"[segment] [task] automation software"
"AI [job function] replacement"
"[task] software vendors"
```

**Funding & traction:**
```
"[company name] funding"
"[company name] Crunchbase"
"[company name] revenue"
"[company name] customers"
"[space] market map 2024"
```

**Customer feedback:**
```
"[competitor] reviews"
"[competitor] G2"
"[competitor] Capterra"
"[competitor] complaints"
"[competitor] alternatives"
"vs [competitor]"
```

---

### Buyer Intent Signals

**Active search:**
```
"[segment] looking for [solution]"
"[problem] software recommendations"
"best [solution] for [segment]"
"[solution] tools comparison"
"alternatives to [incumbent]"
```

**Pain expression:**
```
"site:reddit.com [problem] solutions"
"site:reddit.com [task] automation"
"site:twitter.com need tool for [problem]"
"site:news.ycombinator.com [problem]"
```

**Workarounds:**
```
"[segment] [task] hacks"
"[task] manual process"
"how to [task] without [expensive tool]"
"DIY [solution]"
```

---

### Market Sizing

**TAM research:**
```
"[segment] market size 2024"
"[industry] market research report"
"[job function] employment statistics [country]"
"number of [job title] in [country]"
"[industry] workforce size"
```

**Software spending:**
```
"[segment] software spending 2024"
"[industry] SaaS spending trends"
"[segment] technology budget"
"[industry] software market size"
```

**Adoption rates:**
```
"[segment] AI adoption rates"
"[segment] automation adoption"
"[industry] technology adoption curve"
"[segment] digital transformation statistics"
```

---

### Willingness to Pay

```
"[segment] software budget"
"[task] automation ROI case studies"
"[similar tool] pricing"
"cost of [task] manual process"
"[segment] worth paying for [solution]"
"[segment] software spending priorities"
```

---

## Phase 5: Inevitability Scoring

### Technical Feasibility Validation

```
"GPT-4 performance [task] benchmark"
"LLM accuracy [domain]"
"AI [task] success rate"
"human vs AI [task] comparison"
"[task] automation feasibility"
"AI limitations [domain]"
```

---

### Adoption Barriers

```
"barriers to AI adoption [industry]"
"[segment] AI trust issues"
"AI implementation challenges [industry]"
"[segment] resistance to automation"
"AI compliance requirements [industry]"
```

---

### Regulatory Research

```
"[industry] AI regulations"
"[domain] professional liability AI"
"AI licensing requirements [field]"
"[industry] data privacy requirements"
"AI ethics guidelines [profession]"
```

---

### Competitive Dynamics

```
"[space] competitive landscape 2024"
"[incumbent] AI strategy"
"AI startups [domain]"
"[space] market consolidation"
"[industry] AI investment trends"
```

---

## Domain-Specific Research Patterns

### Legal Domain

```
"legal research automation"
"AI legal assistant"
"lawyer time tracking studies"
"legal tech adoption rates"
"Westlaw LexisNexis alternatives"
"attorney productivity pain points"
"legal document automation"
"AI unauthorized practice of law"
"legal AI ethics"
```

---

### Finance Domain

```
"financial analyst automation"
"AI financial reporting"
"FP&A automation tools"
"financial data aggregation"
"accounting automation AI"
"CFO technology priorities"
"financial compliance automation"
"financial services AI regulations"
```

---

### Healthcare Domain

```
"clinical documentation AI"
"healthcare workflow automation"
"physician administrative burden"
"EHR integration challenges"
"medical AI accuracy requirements"
"HIPAA AI compliance"
"healthcare AI adoption barriers"
"clinical decision support AI"
```

---

### Engineering Domain

```
"engineer productivity tools"
"CAD automation AI"
"engineering documentation automation"
"technical specification generation"
"engineer workflow bottlenecks"
"engineering software spending"
```

---

### Marketing Domain

```
"marketing automation AI"
"content creation AI tools"
"marketing research automation"
"copywriter productivity tools"
"marketing AI adoption"
"brand voice AI consistency"
"marketing ROI automation"
```

---

## Advanced Search Techniques

### Boolean Operators

```
"[term1] AND [term2]"
"[term1] OR [term2]"
"[term1] -[excluded_term]"
"[exact phrase]"
```

---

### Site-Specific Searches

**News & announcements:**
```
site:openai.com [query]
site:anthropic.com [query]
site:techcrunch.com [query]
site:theverge.com [query]
```

**Research & papers:**
```
site:arxiv.org [query]
site:scholar.google.com [query]
site:openreview.net [query]
```

**Industry analysis:**
```
site:gartner.com [query]
site:forrester.com [query]
site:mckinsey.com [query]
```

**Community:**
```
site:reddit.com [query]
site:news.ycombinator.com [query]
site:twitter.com [query]
site:linkedin.com [query]
```

---

### Time-Bounded Searches

```
"[query] 2024"
"[query] 2023"
"[query] after:2024-01-01"
"[query] before:2024-12-31"
```

---

### Finding Specific Content Types

```
"[query] filetype:pdf"
"[query] survey"
"[query] report"
"[query] benchmark"
"[query] case study"
"[query] whitepaper"
```

---

## Research Workflow Templates

### Template 1: New Segment Discovery

```
Step 1: "[segment] biggest time wasters 2024"
Step 2: "site:reddit.com [segment] productivity"
Step 3: "[segment] workflow automation challenges"
Step 4: "[segment] software spending trends"
Step 5: "[segment] AI adoption barriers"

Extract: Top 10 tasks, pain points, budget, barriers
```

---

### Template 2: Competitive Landscape

```
Step 1: "[business concept] startups 2024"
Step 2: "[business concept] companies funding"
Step 3: "[competitor1] reviews G2"
Step 4: "[competitor2] customers complaints"
Step 5: "[space] market map"

Extract: Competitors, positioning, strengths, weaknesses, gaps
```

---

### Template 3: Market Validation

```
Step 1: "[segment] looking for [solution]"
Step 2: "site:reddit.com [problem] solutions"
Step 3: "[segment] market size 2024"
Step 4: "[similar tool] pricing"
Step 5: "[task] automation ROI"

Extract: Intent signals, market size, pricing benchmarks, ROI data
```

---

### Template 4: Technical Feasibility

```
Step 1: "GPT-4 [task] benchmark"
Step 2: "AI [task] accuracy"
Step 3: "LLM performance [domain]"
Step 4: "human vs AI [task]"
Step 5: "[task] automation limitations"

Extract: Current capabilities, accuracy rates, limitations, timeline
```

---

## Source Prioritization

**Tier 1 (Highest trust):**
- Official model providers (OpenAI, Anthropic, Google)
- Academic papers (arXiv, peer-reviewed journals)
- First-hand user experiences (Reddit, HN, verified reviews)
- Official employment/market statistics (BLS, industry associations)

**Tier 2 (Moderate trust):**
- Tech journalism (TechCrunch, The Verge, Ars Technica)
- Industry analysts (Gartner, Forrester, IDC)
- Company blogs and case studies
- Survey data from reputable sources

**Tier 3 (Low trust, verify):**
- Marketing content from vendors
- Promotional blog posts
- Unverified claims
- Single-source statistics

**Always cross-reference important findings with multiple sources.**

---

## Research Quality Checklist

**For each phase, ensure:**

- [ ] Queries executed across multiple categories
- [ ] Multiple sources per finding (cross-validation)
- [ ] Recent data (prefer 2024, accept 2023, flag older)
- [ ] Primary sources when possible (not just summaries)
- [ ] Quantitative data extracted (not just qualitative)
- [ ] Sources cited (track for deliverable appendix)
- [ ] Contradictions noted (flags uncertainty)
- [ ] Gaps identified (what couldn't be found)

---

## Tips for Effective Research

1. **Start broad, narrow down**: Generic queries → specific queries
2. **Use community sources**: Reddit/HN/Twitter reveal real pain
3. **Look for recency**: AI field moves fast, use date filters
4. **Cross-validate claims**: Single source = hypothesis, multiple = data
5. **Track search queries**: Document for deliverable appendix
6. **Note dead ends**: Knowing what you can't find is valuable
7. **Follow citations**: Good papers reference other good papers
8. **Watch for bias**: Vendor content vs user experiences

---

Return to main SKILL.md or specific phase reference files to execute research protocols.
